/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.entities;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.MessageBuilder;
import net.dv8tion.jda.core.MessageHistory;
import net.dv8tion.jda.core.entities.ChannelType;
import net.dv8tion.jda.core.entities.Emote;
import net.dv8tion.jda.core.entities.EntityBuilder;
import net.dv8tion.jda.core.entities.ISnowflake;
import net.dv8tion.jda.core.entities.Message;
import net.dv8tion.jda.core.entities.MessageEmbed;
import net.dv8tion.jda.core.entities.impl.MessageImpl;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.requests.Route;
import org.apache.http.util.Args;
import org.json.JSONObject;

public interface MessageChannel
extends ISnowflake {
    public String getName();

    public ChannelType getType();

    public JDA getJDA();

    public RestAction<Message> sendMessage(String var1);

    public RestAction<Message> sendMessage(MessageEmbed var1);

    public RestAction<Message> sendMessage(Message var1);

    public RestAction<Message> sendFile(File var1, Message var2) throws IOException;

    public RestAction<Message> sendFile(File var1, String var2, Message var3) throws IOException;

    public RestAction<Message> sendFile(InputStream var1, String var2, Message var3);

    public RestAction<Message> sendFile(byte[] var1, String var2, Message var3);

    public RestAction<Message> getMessageById(String var1);

    public RestAction<Void> deleteMessageById(String var1);

    public MessageHistory getHistory();

    public RestAction<MessageHistory> getHistoryAround(Message var1, int var2);

    public RestAction<MessageHistory> getHistoryAround(String var1, int var2);

    public RestAction<Void> sendTyping();

    default public RestAction<Void> addReactionById(String messageId, String unicode) {
        String encoded;
        Args.notNull(messageId, "MessageId");
        Args.containsNoBlanks(unicode, "Provided Unicode");
        try {
            encoded = URLEncoder.encode(unicode, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        Route.CompiledRoute route = Route.Messages.ADD_REACTION.compile(this.getId(), messageId, encoded);
        return new RestAction<Void>(this.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    default public RestAction<Void> addReactionById(String messageId, Emote emote) {
        Args.notNull(messageId, "MessageId");
        Args.notNull(emote, "Emote");
        Route.CompiledRoute route = Route.Messages.ADD_REACTION.compile(this.getId(), messageId, String.format("%s:%s", emote.getName(), emote.getId()));
        return new RestAction<Void>(this.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    public RestAction<Void> pinMessageById(String var1);

    public RestAction<Void> unpinMessageById(String var1);

    public RestAction<List<Message>> getPinnedMessages();

    default public RestAction<Message> editMessageById(String id, String newContent) {
        return this.editMessageById(id, new MessageBuilder().appendString(newContent).build());
    }

    default public RestAction<Message> editMessageById(String id, Message newContent) {
        Args.notNull(id, "id");
        Args.notNull(newContent, "message");
        JSONObject json = ((MessageImpl)newContent).toJSONObject();
        Route.CompiledRoute route = Route.Messages.EDIT_MESSAGE.compile(this.getId(), id);
        return new RestAction<Message>(this.getJDA(), route, (Object)json){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    try {
                        Message m = EntityBuilder.get(this.api).createMessage(response.getObject());
                        request.onSuccess(m);
                    }
                    catch (IllegalArgumentException e) {
                        request.onFailure(e);
                    }
                } else {
                    request.onFailure(response);
                }
            }
        };
    }
}

