/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.audio;

import com.neovisionaries.ws.client.ProxySettings;
import com.neovisionaries.ws.client.WebSocket;
import com.neovisionaries.ws.client.WebSocketAdapter;
import com.neovisionaries.ws.client.WebSocketException;
import com.neovisionaries.ws.client.WebSocketFactory;
import com.neovisionaries.ws.client.WebSocketFrame;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.audio.AudioConnection;
import net.dv8tion.jda.core.audio.hooks.ConnectionListener;
import net.dv8tion.jda.core.audio.hooks.ConnectionStatus;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.entities.VoiceChannel;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.managers.impl.AudioManagerImpl;
import net.dv8tion.jda.core.utils.SimpleLog;
import org.apache.http.HttpHost;
import org.json.JSONArray;
import org.json.JSONObject;

public class AudioWebSocket
extends WebSocketAdapter {
    public static final SimpleLog LOG = SimpleLog.getLog("JDAAudioSocket");
    public static final HashMap<JDA, ScheduledThreadPoolExecutor> KEEP_ALIVE_POOLS = new HashMap();
    public static final int DISCORD_SECRET_KEY_LENGTH = 32;
    public static final int INITIAL_CONNECTION_RESPONSE = 2;
    public static final int HEARTBEAT_PING_RETURN = 3;
    public static final int CONNECTING_COMPLETED = 4;
    public static final int USER_SPEAKING_UPDATE = 5;
    public static final int HEARTBEAT_START = 8;
    protected final ConnectionListener listener;
    protected final ScheduledThreadPoolExecutor keepAlivePool;
    protected AudioConnection audioConnection;
    protected ConnectionStatus connectionStatus = ConnectionStatus.NOT_CONNECTED;
    private final JDAImpl api;
    private final Guild guild;
    private final HttpHost proxy;
    private boolean connected = false;
    private boolean ready = false;
    private Runnable keepAliveRunnable;
    public WebSocket socket;
    private String endpoint;
    private String wssEndpoint;
    private boolean shutdown;
    private boolean shouldReconnect;
    private int ssrc;
    private String sessionId;
    private String token;
    private byte[] secretKey;
    private DatagramSocket udpSocket;
    private InetSocketAddress address;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioWebSocket(ConnectionListener listener, String endpoint, JDAImpl api, Guild guild, String sessionId, String token, boolean shouldReconnect) throws WebSocketException, IOException {
        this.listener = listener;
        this.endpoint = endpoint;
        this.api = api;
        this.guild = guild;
        this.sessionId = sessionId;
        this.token = token;
        this.shouldReconnect = shouldReconnect;
        HashMap<JDA, ScheduledThreadPoolExecutor> hashMap = KEEP_ALIVE_POOLS;
        synchronized (hashMap) {
            KEEP_ALIVE_POOLS.computeIfAbsent(api, jda -> new ScheduledThreadPoolExecutor(1, new KeepAliveThreadFactory(api)));
        }
        this.keepAlivePool = KEEP_ALIVE_POOLS.get(api);
        if (!endpoint.startsWith("wss://")) {
            this.wssEndpoint = "wss://" + endpoint;
        }
        if (sessionId == null || sessionId.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a voice connection using a null/empty sessionId!");
        }
        if (token == null || token.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a voice connection using a null/empty token!");
        }
        this.proxy = api.getGlobalProxy();
        WebSocketFactory factory = new WebSocketFactory();
        if (this.proxy != null) {
            ProxySettings settings = factory.getProxySettings();
            settings.setHost(this.proxy.getHostName());
            settings.setPort(this.proxy.getPort());
        }
        try {
            this.socket = factory.createSocket(this.wssEndpoint).addListener(this);
            this.changeStatus(ConnectionStatus.CONNECTING_AWAITING_WEBSOCKET_CONNECT);
            this.socket.connect();
        }
        catch (WebSocketException e) {
            LOG.warn("Failed to establish websocket connection: " + (Object)((Object)e.getError()) + " - " + e.getMessage() + "\nClosing connection and attempting to reconnect.");
            this.close(ConnectionStatus.ERROR_WEBSOCKET_UNABLE_TO_CONNECT);
            throw e;
        }
        catch (IOException e) {
            LOG.warn("Encountered IOException while attempting to connect: " + e.getMessage() + "\nClosing connection and attempting to reconnect.");
            this.close(ConnectionStatus.ERROR_WEBSOCKET_UNABLE_TO_CONNECT);
            throw e;
        }
    }

    public void send(String message) {
        this.socket.sendText(message);
    }

    @Override
    public void onConnected(WebSocket websocket, Map<String, List<String>> headers) {
        JSONObject connectObj = new JSONObject().put("op", 0).put("d", new JSONObject().put("server_id", this.guild.getId()).put("user_id", this.api.getSelfUser().getId()).put("session_id", this.sessionId).put("token", this.token));
        this.send(connectObj.toString());
        this.connected = true;
        this.changeStatus(ConnectionStatus.CONNECTING_AWAITING_AUTHENTICATING);
    }

    @Override
    public void onTextMessage(WebSocket websocket, String message) {
        JSONObject contentAll = new JSONObject(message);
        int opCode = contentAll.getInt("op");
        switch (opCode) {
            case 2: {
                JSONObject content = contentAll.getJSONObject("d");
                this.ssrc = content.getInt("ssrc");
                int port = content.getInt("port");
                int heartbeatInterval = content.getInt("heartbeat_interval");
                InetSocketAddress externalIpAndPort = null;
                this.changeStatus(ConnectionStatus.CONNECTING_ATTEMPTING_UDP_DISCOVERY);
                int tries = 0;
                do {
                    if ((externalIpAndPort = this.handleUdpDiscovery(new InetSocketAddress(this.endpoint, port), this.ssrc)) != null || ++tries <= 5) continue;
                    this.close(ConnectionStatus.ERROR_UDP_UNABLE_TO_CONNECT);
                    return;
                } while (externalIpAndPort == null);
                this.send(new JSONObject().put("op", 1).put("d", new JSONObject().put("protocol", "udp").put("data", new JSONObject().put("address", externalIpAndPort.getHostString()).put("port", externalIpAndPort.getPort()).put("mode", "xsalsa20_poly1305"))).toString());
                this.setupKeepAlive(heartbeatInterval);
                this.changeStatus(ConnectionStatus.CONNECTING_AWAITING_READY);
                break;
            }
            case 8: {
                break;
            }
            case 3: {
                long timePingSent = contentAll.getLong("d");
                long ping = System.currentTimeMillis() - timePingSent;
                this.listener.onPing(ping);
                break;
            }
            case 4: {
                JSONArray keyArray = contentAll.getJSONObject("d").getJSONArray("secret_key");
                this.secretKey = new byte[32];
                for (int i = 0; i < keyArray.length(); ++i) {
                    this.secretKey[i] = (byte)keyArray.getInt(i);
                }
                LOG.trace("Audio connection has finished connecting!");
                this.ready = true;
                this.changeStatus(ConnectionStatus.CONNECTED);
                break;
            }
            case 5: {
                JSONObject content = contentAll.getJSONObject("d");
                boolean speaking = content.getBoolean("speaking");
                int ssrc = content.getInt("ssrc");
                String userId = content.getString("user_id");
                User user = this.api.getUserById(userId);
                if (user == null) {
                    LOG.warn("Got an Audio USER_SPEAKING_UPDATE for a non-existent User. JSON: " + contentAll);
                    return;
                }
                this.audioConnection.updateUserSSRC(ssrc, userId, speaking);
                if (user == null) break;
                this.listener.onUserSpeaking(user, speaking);
                break;
            }
            default: {
                LOG.debug("Unknown Audio OP code.\n" + contentAll.toString(4));
            }
        }
    }

    @Override
    public void onDisconnected(WebSocket websocket, WebSocketFrame serverCloseFrame, WebSocketFrame clientCloseFrame, boolean closedByServer) {
        LOG.debug("The Audio connection was closed!");
        LOG.debug("By remote? " + closedByServer);
        if (serverCloseFrame != null) {
            LOG.debug("Reason: " + serverCloseFrame.getCloseReason());
            LOG.debug("Close code: " + serverCloseFrame.getCloseCode());
        }
        if (clientCloseFrame != null) {
            LOG.debug("ClientReason: " + clientCloseFrame.getCloseReason());
            LOG.debug("ClientCode: " + clientCloseFrame.getCloseCode());
            if (clientCloseFrame.getCloseCode() != 1000) {
                this.close(ConnectionStatus.ERROR_LOST_CONNECTION);
            }
        } else {
            this.close(ConnectionStatus.NOT_CONNECTED);
        }
    }

    @Override
    public void onUnexpectedError(WebSocket websocket, WebSocketException cause) {
        this.handleCallbackError(websocket, cause);
    }

    @Override
    public void handleCallbackError(WebSocket websocket, Throwable cause) {
        LOG.log(cause);
    }

    public void close(ConnectionStatus closeStatus) {
        Guild connGuild;
        if (this.shutdown) {
            return;
        }
        this.connected = false;
        this.ready = false;
        this.shutdown = true;
        if (closeStatus != ConnectionStatus.AUDIO_REGION_CHANGE) {
            JSONObject obj = new JSONObject().put("op", 4).put("d", new JSONObject().put("guild_id", this.guild.getId()).put("channel_id", JSONObject.NULL).put("self_mute", false).put("self_deaf", false));
            this.api.getClient().send(obj.toString());
        }
        if (this.keepAliveRunnable != null) {
            this.keepAlivePool.remove(this.keepAliveRunnable);
            this.keepAliveRunnable = null;
        }
        if (this.udpSocket != null) {
            this.udpSocket.close();
        }
        if (this.socket != null && this.socket.isOpen()) {
            this.socket.sendClose(1000);
        }
        AudioManagerImpl manager = (AudioManagerImpl)this.guild.getAudioManager();
        VoiceChannel disconnectedChannel = manager.getConnectedChannel();
        manager.setAudioConnection(null);
        if (closeStatus == ConnectionStatus.ERROR_LOST_CONNECTION && (connGuild = this.api.getGuildById(this.guild.getId())) != null && connGuild.getVoiceChannelById(this.audioConnection.getChannel().getId()) == null) {
            closeStatus = ConnectionStatus.DISCONNECTED_CHANNEL_DELETED;
        }
        this.changeStatus(closeStatus);
        if (this.shouldReconnect && closeStatus != ConnectionStatus.NOT_CONNECTED && closeStatus != ConnectionStatus.DISCONNECTED_CHANNEL_DELETED && closeStatus != ConnectionStatus.DISCONNECTED_REMOVED_FROM_GUILD && closeStatus != ConnectionStatus.AUDIO_REGION_CHANGE) {
            manager.setQueuedAudioConnection(disconnectedChannel);
            this.api.getClient().queueAudioConnect(disconnectedChannel);
        }
    }

    public DatagramSocket getUdpSocket() {
        return this.udpSocket;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public byte[] getSecretKey() {
        return Arrays.copyOf(this.secretKey, this.secretKey.length);
    }

    public int getSSRC() {
        return this.ssrc;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isReady() {
        return this.ready;
    }

    private InetSocketAddress handleUdpDiscovery(InetSocketAddress address, int ssrc) {
        try {
            this.udpSocket = new DatagramSocket();
            ByteBuffer buffer = ByteBuffer.allocate(70);
            buffer.putInt(ssrc);
            DatagramPacket discoveryPacket = new DatagramPacket(buffer.array(), buffer.array().length, address);
            this.udpSocket.send(discoveryPacket);
            DatagramPacket receivedPacket = new DatagramPacket(new byte[70], 70);
            this.udpSocket.setSoTimeout(1000);
            this.udpSocket.receive(receivedPacket);
            byte[] received = receivedPacket.getData();
            String ourIP = new String(receivedPacket.getData());
            ourIP = ourIP.substring(0, ourIP.length() - 2);
            ourIP = ourIP.trim();
            byte[] portBytes = new byte[]{received[received.length - 1], received[received.length - 2]};
            int firstByte = 0xFF & portBytes[0];
            int secondByte = 0xFF & portBytes[1];
            int ourPort = firstByte << 8 | secondByte;
            this.address = address;
            return new InetSocketAddress(ourIP, ourPort);
        }
        catch (SocketException e) {
            return null;
        }
        catch (IOException e) {
            LOG.log(e);
            return null;
        }
    }

    private void setupKeepAlive(int keepAliveInterval) {
        if (this.keepAliveRunnable != null) {
            LOG.fatal("Setting up a KeepAlive runnable while the previous one seems to still be active!!");
        }
        this.keepAliveRunnable = () -> {
            if (this.socket.isOpen() && this.socket.isOpen() && !this.udpSocket.isClosed()) {
                this.send(new JSONObject().put("op", 3).put("d", System.currentTimeMillis()).toString());
                long seq = 0L;
                try {
                    ByteBuffer buffer = ByteBuffer.allocate(9);
                    buffer.put((byte)-55);
                    buffer.putLong(seq);
                    DatagramPacket keepAlivePacket = new DatagramPacket(buffer.array(), buffer.array().length, this.address);
                    this.udpSocket.send(keepAlivePacket);
                }
                catch (NoRouteToHostException e) {
                    LOG.warn("Closing AudioConnection due to inability to ping audio packets.");
                    LOG.warn("Cannot send audio packet because JDA navigate the route to Discord.\nAre you sure you have internet connection? It is likely that you've lost connection.");
                    this.close(ConnectionStatus.ERROR_LOST_CONNECTION);
                }
                catch (IOException e) {
                    LOG.log(e);
                }
            }
        };
        try {
            this.keepAlivePool.scheduleAtFixedRate(this.keepAliveRunnable, 0L, keepAliveInterval, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    public void changeStatus(ConnectionStatus newStatus) {
        this.connectionStatus = newStatus;
        this.listener.onStatusChange(newStatus);
    }

    public ConnectionStatus getConnectionStatus() {
        return this.connectionStatus;
    }

    public void setAutoReconnect(boolean shouldReconnect) {
        this.shouldReconnect = shouldReconnect;
    }

    private class KeepAliveThreadFactory
    implements ThreadFactory {
        final String identifier;
        AtomicInteger threadCount = new AtomicInteger(1);

        public KeepAliveThreadFactory(JDAImpl api) {
            this.identifier = api.getIdentifierString() + " Audio-KeepAlive Pool";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, this.identifier + " - Thread " + this.threadCount.getAndIncrement());
            t.setDaemon(true);
            return t;
        }
    }
}

