/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.youtube;

import com.sedmelluq.discord.lavaplayer.container.matroska.MatroskaAudioTrack;
import com.sedmelluq.discord.lavaplayer.container.mpeg.MpegAudioTrack;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeFormatInfo;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubePersistentHttpStream;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeTrackFormat;
import com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.DelegatedAudioTrack;
import com.sedmelluq.discord.lavaplayer.track.playback.LocalAudioTrackExecutor;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YoutubeAudioTrack
extends DelegatedAudioTrack {
    private static final Logger log = LoggerFactory.getLogger(YoutubeAudioTrack.class);
    private final YoutubeAudioSourceManager sourceManager;

    public YoutubeAudioTrack(AudioTrackInfo trackInfo, YoutubeAudioSourceManager sourceManager) {
        super(trackInfo);
        this.sourceManager = sourceManager;
    }

    @Override
    public void process(LocalAudioTrackExecutor localExecutor) throws Exception {
        try (CloseableHttpClient httpClient = this.sourceManager.createHttpClient();){
            FormatWithUrl format = this.loadBestFormatWithUrl(httpClient);
            log.debug("Starting track from URL: {}", (Object)format.signedUrl);
            try (YoutubePersistentHttpStream stream = new YoutubePersistentHttpStream(httpClient, format.signedUrl, format.details.getContentLength());){
                if ("audio/webm".equals(format.details.getType().getMimeType())) {
                    this.processDelegate(new MatroskaAudioTrack(this.trackInfo, stream), localExecutor);
                } else {
                    this.processDelegate(new MpegAudioTrack(this.trackInfo, stream), localExecutor);
                }
            }
        }
    }

    private FormatWithUrl loadBestFormatWithUrl(CloseableHttpClient httpClient) throws Exception {
        JsonBrowser info = this.getTrackInfo(httpClient);
        String playerScript = YoutubeAudioTrack.extractPlayerScriptFromInfo(info);
        List<YoutubeTrackFormat> formats = this.loadTrackFormats(info, httpClient, playerScript);
        YoutubeTrackFormat format = YoutubeAudioTrack.findBestSupportedFormat(formats);
        URI signedUrl = this.sourceManager.getCipherManager().getValidUrl(httpClient, playerScript, format);
        return new FormatWithUrl(format, signedUrl);
    }

    @Override
    public AudioTrack makeClone() {
        return new YoutubeAudioTrack(this.trackInfo, this.sourceManager);
    }

    @Override
    public AudioSourceManager getSourceManager() {
        return this.sourceManager;
    }

    private JsonBrowser getTrackInfo(CloseableHttpClient httpClient) throws Exception {
        return this.sourceManager.getTrackInfoFromMainPage(httpClient, this.getIdentifier(), true);
    }

    private List<YoutubeTrackFormat> loadTrackFormats(JsonBrowser info, CloseableHttpClient httpClient, String playerScript) throws Exception {
        String adaptiveFormats = info.safeGet("args").safeGet("adaptive_fmts").text();
        if (adaptiveFormats != null) {
            return this.loadTrackFormatsFromAdaptive(adaptiveFormats);
        }
        String dashUrl = info.safeGet("args").safeGet("dashmpd").text();
        if (dashUrl != null) {
            return this.loadTrackFormatsFromDash(dashUrl, httpClient, playerScript);
        }
        throw new FriendlyException("Unable to play this YouTube track.", FriendlyException.Severity.SUSPICIOUS, new IllegalStateException("No adaptive formats, no dash."));
    }

    private List<YoutubeTrackFormat> loadTrackFormatsFromAdaptive(String adaptiveFormats) throws Exception {
        ArrayList<YoutubeTrackFormat> tracks = new ArrayList<YoutubeTrackFormat>();
        for (String formatString : adaptiveFormats.split(",")) {
            Map<String, String> format = DataFormatTools.convertToMapLayout(URLEncodedUtils.parse(formatString, Charset.forName("UTF-8")));
            tracks.add(new YoutubeTrackFormat(ContentType.parse(format.get("type")), Long.parseLong(format.get("bitrate")), Long.parseLong(format.get("clen")), format.get("url"), format.get("s")));
        }
        return tracks;
    }

    private List<YoutubeTrackFormat> loadTrackFormatsFromDash(String dashUrl, CloseableHttpClient httpClient, String playerScript) throws Exception {
        String resolvedDashUrl = this.sourceManager.getCipherManager().getValidDashUrl(httpClient, playerScript, dashUrl);
        try (CloseableHttpResponse response = httpClient.execute(new HttpGet(resolvedDashUrl));){
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new IOException("Invalid status code for track info page response.");
            }
            Document document = Jsoup.parse(response.getEntity().getContent(), "UTF-8", "", Parser.xmlParser());
            List<YoutubeTrackFormat> list = this.loadTrackFormatsFromDashDocument(document);
            return list;
        }
    }

    private List<YoutubeTrackFormat> loadTrackFormatsFromDashDocument(Document document) {
        ArrayList<YoutubeTrackFormat> tracks = new ArrayList<YoutubeTrackFormat>();
        for (Element adaptation : document.select("AdaptationSet")) {
            String mimeType = adaptation.attr("mimeType");
            for (Element representation : adaptation.select("Representation")) {
                String url = representation.select("BaseURL").first().text();
                String contentLength = DataFormatTools.extractBetween(url, "/clen/", "/");
                String contentType = mimeType + "; codecs=" + representation.attr("codecs");
                if (contentLength == null) {
                    log.debug("Skipping format {} because the content length is missing", (Object)contentType);
                    continue;
                }
                tracks.add(new YoutubeTrackFormat(ContentType.parse(contentType), Long.parseLong(representation.attr("bandwidth")), Long.parseLong(contentLength), url, null));
            }
        }
        return tracks;
    }

    private static String extractPlayerScriptFromInfo(JsonBrowser info) {
        return info.get("assets").get("js").text();
    }

    private static boolean isBetterFormat(YoutubeTrackFormat format, YoutubeTrackFormat other) {
        YoutubeFormatInfo info = format.getInfo();
        if (info == null) {
            return false;
        }
        if (other == null) {
            return true;
        }
        if (info.ordinal() != other.getInfo().ordinal()) {
            return info.ordinal() < other.getInfo().ordinal();
        }
        return format.getBitrate() > other.getBitrate();
    }

    private static YoutubeTrackFormat findBestSupportedFormat(List<YoutubeTrackFormat> formats) throws Exception {
        YoutubeTrackFormat bestFormat = null;
        for (YoutubeTrackFormat format2 : formats) {
            if (!YoutubeAudioTrack.isBetterFormat(format2, bestFormat)) continue;
            bestFormat = format2;
        }
        if (bestFormat == null) {
            StringJoiner joiner = new StringJoiner(", ");
            formats.forEach(format -> joiner.add(format.getType().toString()));
            throw new IllegalStateException("No supported audio streams available, available types: " + joiner.toString());
        }
        return bestFormat;
    }

    private static class FormatWithUrl {
        private final YoutubeTrackFormat details;
        private final URI signedUrl;

        private FormatWithUrl(YoutubeTrackFormat details, URI signedUrl) {
            this.details = details;
            this.signedUrl = signedUrl;
        }
    }
}

