/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.youtube;

import com.sedmelluq.discord.lavaplayer.player.DefaultAudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeAudioTrack;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeSignatureCipherManager;
import com.sedmelluq.discord.lavaplayer.tools.DaemonThreadFactory;
import com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import com.sedmelluq.discord.lavaplayer.tools.ExecutorTools;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.track.AudioItem;
import com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.BasicAudioPlaylist;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YoutubeAudioSourceManager
implements AudioSourceManager {
    private static final Logger log = LoggerFactory.getLogger(YoutubeAudioSourceManager.class);
    static final String CHARSET = "UTF-8";
    private static final String VIDEO_ID_REGEX = "([a-zA-Z0-9_-]{11})";
    private static final String PLAYLIST_REGEX = "((PL|LL|FL)[a-zA-Z0-9_-]+)";
    private static final String MIX_REGEX = "(RD[a-zA-Z0-9_-]+)";
    private static final String PROTOCOL_REGEX = "(?:http://|https://|)";
    private static final String SUFFIX_REGEX = "(?:\\?.*|&.*|)";
    private static final String SEARCH_PREFIX = "ytsearch:";
    private static final Pattern[] validTrackPatterns = new Pattern[]{Pattern.compile("^([a-zA-Z0-9_-]{11})$"), Pattern.compile("^(?:http://|https://|)(?:www\\.|)youtube.com/watch\\?v=([a-zA-Z0-9_-]{11})(?:\\?.*|&.*|)$"), Pattern.compile("^(?:http://|https://|)(?:www\\.|)youtu.be/([a-zA-Z0-9_-]{11})(?:\\?.*|&.*|)$")};
    private static final Pattern[] validPlaylistPatterns = new Pattern[]{Pattern.compile("^((PL|LL|FL)[a-zA-Z0-9_-]+)$"), Pattern.compile("^(?:http://|https://|)(?:www\\.|)youtube.com/playlist\\?list=((PL|LL|FL)[a-zA-Z0-9_-]+)(?:\\?.*|&.*|)$")};
    private static final String LIST_PARAMETER = "&list=";
    private static final Pattern playlistEmbeddedPattern = Pattern.compile("&list=((PL|LL|FL)[a-zA-Z0-9_-]+)");
    private static final Pattern mixEmbeddedPattern = Pattern.compile("&list=(RD[a-zA-Z0-9_-]+)");
    private final HttpClientBuilder httpClientBuilder = YoutubeAudioSourceManager.createSharedCookiesHttpBuilder();
    private final YoutubeSignatureCipherManager signatureCipherManager = new YoutubeSignatureCipherManager();
    private final ExecutorService mixLoadingExecutor = new ThreadPoolExecutor(0, 10, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new DaemonThreadFactory("yt-mix"));
    private final boolean allowSearch;

    public YoutubeAudioSourceManager() {
        this(true);
    }

    public YoutubeAudioSourceManager(boolean allowSearch) {
        this.allowSearch = allowSearch;
    }

    @Override
    public String getSourceName() {
        return "youtube";
    }

    @Override
    public AudioItem loadItem(DefaultAudioPlayerManager manager, AudioReference reference) {
        try {
            return this.loadItemOnce(reference);
        }
        catch (FriendlyException exception) {
            if (HttpClientTools.isConnectionResetException(exception.getCause())) {
                return this.loadItemOnce(reference);
            }
            throw exception;
        }
    }

    @Override
    public boolean isTrackEncodable(AudioTrack track) {
        return true;
    }

    @Override
    public void encodeTrack(AudioTrack track, DataOutput output) {
    }

    @Override
    public AudioTrack decodeTrack(AudioTrackInfo trackInfo, DataInput input) {
        return new YoutubeAudioTrack(trackInfo, this);
    }

    @Override
    public void shutdown() {
        ExecutorTools.shutdownExecutor(this.mixLoadingExecutor, "youtube mix");
    }

    public CloseableHttpClient createHttpClient() {
        return this.httpClientBuilder.build();
    }

    public YoutubeSignatureCipherManager getCipherManager() {
        return this.signatureCipherManager;
    }

    private static HttpClientBuilder createSharedCookiesHttpBuilder() {
        BasicCookieStore cookieStore = new BasicCookieStore();
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        httpClientBuilder.setDefaultCookieStore(cookieStore);
        return httpClientBuilder;
    }

    private AudioItem loadItemOnce(AudioReference reference) {
        if (this.allowSearch && reference.identifier.startsWith(SEARCH_PREFIX)) {
            return this.loadSearchResult(reference.identifier.substring(SEARCH_PREFIX.length()).trim());
        }
        AudioItem result = this.loadTrack(reference.identifier);
        if (result == null) {
            result = this.loadPlaylist(reference.identifier);
        }
        return result;
    }

    private AudioItem loadTrack(String identifier) {
        for (Pattern pattern : validTrackPatterns) {
            Matcher matcher = pattern.matcher(identifier);
            if (!matcher.matches()) continue;
            Matcher playlistMatcher = playlistEmbeddedPattern.matcher(identifier);
            Matcher mixMatcher = mixEmbeddedPattern.matcher(identifier);
            if (playlistMatcher.find()) {
                return this.loadLinkedPlaylistWithId(playlistMatcher.group(1), matcher.group(1));
            }
            if (mixMatcher.find()) {
                return this.loadMixWithId(mixMatcher.group(1), matcher.group(1));
            }
            return this.loadTrackWithVideoId(matcher.group(1), false);
        }
        return null;
    }

    private AudioItem loadLinkedPlaylistWithId(String playlistId, String videoId) {
        AudioPlaylist playlist = this.loadPlaylistWithId(playlistId, videoId);
        if (playlist == null) {
            return this.loadTrackWithVideoId(videoId, false);
        }
        return playlist;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AudioItem loadTrackWithVideoId(String videoId, boolean mustExist) {
        try (CloseableHttpClient httpClient = this.httpClientBuilder.build();){
            JsonBrowser info = this.getTrackInfoFromMainPage(httpClient, videoId, mustExist);
            if (info == null) {
                AudioReference audioReference = AudioReference.NO_TRACK;
                return audioReference;
            }
            JsonBrowser args = info.get("args");
            AudioTrackInfo trackInfo = new AudioTrackInfo(args.get("title").text(), args.get("author").text(), args.get("length_seconds").as(Integer.class) * 1000, videoId, false);
            YoutubeAudioTrack youtubeAudioTrack = new YoutubeAudioTrack(trackInfo, this);
            return youtubeAudioTrack;
        }
        catch (Exception e) {
            throw ExceptionTools.wrapUnfriendlyExceptions("Loading information for a YouTube track failed.", FriendlyException.Severity.FAULT, e);
        }
    }

    JsonBrowser getTrackInfoFromMainPage(CloseableHttpClient httpClient, String videoId, boolean mustExist) throws Exception {
        try (CloseableHttpResponse response = httpClient.execute(new HttpGet("https://www.youtube.com/watch?v=" + videoId));){
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new IOException("Invalid status code for video page response.");
            }
            String html = IOUtils.toString(response.getEntity().getContent(), Charset.forName(CHARSET));
            String configJson = DataFormatTools.extractBetween(html, "ytplayer.config = ", ";ytplayer.load");
            if (configJson != null) {
                JsonBrowser jsonBrowser = JsonBrowser.parse(configJson);
                return jsonBrowser;
            }
        }
        if (this.determineFailureReason(httpClient, videoId, mustExist)) {
            return null;
        }
        return this.getTrackInfoFromEmbedPage(httpClient, videoId);
    }

    private boolean determineFailureReason(CloseableHttpClient httpClient, String videoId, boolean mustExist) throws Exception {
        try (CloseableHttpResponse response = httpClient.execute(new HttpGet("https://www.youtube.com/get_video_info?hl=en_GB&video_id=" + videoId));){
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new IOException("Invalid status code for video info response.");
            }
            Map<String, String> format = DataFormatTools.convertToMapLayout(URLEncodedUtils.parse(response.getEntity()));
            boolean bl = this.determineFailureReasonFromStatus(format.get("status"), format.get("reason"), mustExist);
            return bl;
        }
    }

    private boolean determineFailureReasonFromStatus(String status, String reason, boolean mustExist) {
        if ("fail".equals(status)) {
            if ("This video does not exist.".equals(reason) && !mustExist) {
                return true;
            }
            if (reason != null) {
                throw new FriendlyException(reason, FriendlyException.Severity.COMMON, null);
            }
        } else if ("ok".equals(status)) {
            return false;
        }
        throw new FriendlyException("Track is unavailable for an unknown reason.", FriendlyException.Severity.SUSPICIOUS, new IllegalStateException("Main page had no video, but video info has no error."));
    }

    private JsonBrowser getTrackInfoFromEmbedPage(CloseableHttpClient httpClient, String videoId) throws Exception {
        JsonBrowser basicInfo = this.loadTrackBaseInfoFromEmbedPage(httpClient, videoId);
        basicInfo.put("args", this.loadTrackArgsFromVideoInfoPage(httpClient, videoId, basicInfo.get("sts").text()));
        return basicInfo;
    }

    private JsonBrowser loadTrackBaseInfoFromEmbedPage(CloseableHttpClient httpClient, String videoId) throws Exception {
        try (CloseableHttpResponse response = httpClient.execute(new HttpGet("https://www.youtube.com/embed/" + videoId));){
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new IOException("Invalid status code for embed video page response.");
            }
            String html = IOUtils.toString(response.getEntity().getContent(), Charset.forName(CHARSET));
            String configJson = DataFormatTools.extractBetween(html, "'PLAYER_CONFIG': ", ",'EXPERIMENT_FLAGS'");
            if (configJson != null) {
                JsonBrowser jsonBrowser = JsonBrowser.parse(configJson);
                return jsonBrowser;
            }
        }
        throw new FriendlyException("Track information is unavailable.", FriendlyException.Severity.SUSPICIOUS, new IllegalStateException("Expected player config is not present in embed page."));
    }

    private Map<String, String> loadTrackArgsFromVideoInfoPage(CloseableHttpClient httpClient, String videoId, String sts) throws Exception {
        String url = "https://www.youtube.com/get_video_info?hl=en_GB&video_id=" + videoId + "&sts=" + sts;
        try (CloseableHttpResponse response = httpClient.execute(new HttpGet(url));){
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new IOException("Invalid status code for video info response.");
            }
            Map<String, String> map = DataFormatTools.convertToMapLayout(URLEncodedUtils.parse(response.getEntity()));
            return map;
        }
    }

    private AudioPlaylist loadPlaylist(String identifier) {
        for (Pattern pattern : validPlaylistPatterns) {
            Matcher matcher = pattern.matcher(identifier);
            if (!matcher.matches()) continue;
            return this.loadPlaylistWithId(matcher.group(1), null);
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private AudioPlaylist loadPlaylistWithId(String playlistId, String selectedVideoId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private AudioPlaylist buildPlaylist(CloseableHttpClient httpClient, Document document, String selectedVideoId) throws IOException {
        boolean isAccessible;
        boolean bl = isAccessible = !document.select("#pl-header").isEmpty();
        if (!isAccessible) {
            if (selectedVideoId != null) {
                return null;
            }
            throw new FriendlyException("The playlist is private.", FriendlyException.Severity.COMMON, null);
        }
        Element container = document.select("#pl-header").first().parent();
        String playlistName = container.select(".pl-header-title").first().text();
        ArrayList<AudioTrack> tracks = new ArrayList<AudioTrack>();
        String loadMoreUrl = this.extractPlaylistTracks(container, container, tracks);
        int loadCount = 0;
        while (loadMoreUrl != null && ++loadCount <= 5) {
            CloseableHttpResponse response = httpClient.execute(new HttpGet("https://www.youtube.com" + loadMoreUrl));
            Throwable throwable = null;
            try {
                if (response.getStatusLine().getStatusCode() != 200) {
                    throw new IOException("Invalid status code for playlist response.");
                }
                JsonBrowser json = JsonBrowser.parse(response.getEntity().getContent());
                String html = json.get("content_html").text();
                Document videoContainer = Jsoup.parse("<table>" + html + "</table>", "");
                String moreHtml = json.get("load_more_widget_html").text();
                Document moreContainer = moreHtml != null ? Jsoup.parse(moreHtml) : null;
                loadMoreUrl = this.extractPlaylistTracks(videoContainer, moreContainer, tracks);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (response == null) continue;
                if (throwable != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                response.close();
            }
        }
        return new BasicAudioPlaylist(playlistName, tracks, this.findSelectedTrack(tracks, selectedVideoId), false);
    }

    private AudioTrack findSelectedTrack(List<AudioTrack> tracks, String selectedVideoId) {
        if (selectedVideoId != null) {
            for (AudioTrack track : tracks) {
                if (!selectedVideoId.equals(track.getIdentifier())) continue;
                return track;
            }
        }
        return null;
    }

    private String extractPlaylistTracks(Element videoContainer, Element loadMoreContainer, List<AudioTrack> tracks) {
        Elements more;
        for (Element video : videoContainer.select(".pl-video")) {
            Elements lengthElements = video.select(".timestamp span");
            if (lengthElements.isEmpty()) continue;
            String videoId = video.attr("data-video-id").trim();
            String title = video.attr("data-title").trim();
            String author = video.select(".pl-video-owner a").text().trim();
            int lengthInSeconds = YoutubeAudioSourceManager.lengthTextToSeconds(lengthElements.first().text());
            AudioTrackInfo info = new AudioTrackInfo(title, author, lengthInSeconds * 1000, videoId, false);
            tracks.add(new YoutubeAudioTrack(info, this));
        }
        if (loadMoreContainer != null && !(more = loadMoreContainer.select(".load-more-button")).isEmpty()) {
            return more.first().attr("data-uix-load-more-href");
        }
        return null;
    }

    private static int lengthTextToSeconds(String durationText) {
        int length = 0;
        for (String part : durationText.split(":")) {
            length = length * 60 + Integer.valueOf(part);
        }
        return length;
    }

    private AudioPlaylist loadMixWithId(String mixId, String selectedVideoId) {
        ArrayList<String> videoIds = new ArrayList<String>();
        try (CloseableHttpClient httpClient = this.httpClientBuilder.build();){
            String mixUrl = "https://www.youtube.com/watch?v=" + selectedVideoId + LIST_PARAMETER + mixId;
            try (CloseableHttpResponse response = httpClient.execute(new HttpGet(mixUrl));){
                if (response.getStatusLine().getStatusCode() != 200) {
                    throw new IOException("Invalid status code for mix response.");
                }
                Document document = Jsoup.parse(response.getEntity().getContent(), CHARSET, "");
                this.extractVideoIdsFromMix(document, videoIds);
            }
        }
        catch (IOException e) {
            throw new FriendlyException("Could not read mix page.", FriendlyException.Severity.SUSPICIOUS, e);
        }
        if (videoIds.isEmpty()) {
            throw new FriendlyException("Could not find tracks from mix.", FriendlyException.Severity.SUSPICIOUS, null);
        }
        return this.loadTracksAsynchronously(videoIds, selectedVideoId);
    }

    private void extractVideoIdsFromMix(Document document, List<String> videoIds) {
        for (Element videoList : document.select("#playlist-autoscroll-list")) {
            for (Element item : videoList.select("li")) {
                videoIds.add(item.attr("data-video-id"));
            }
        }
    }

    private AudioPlaylist loadTracksAsynchronously(List<String> videoIds, String selectedVideoId) {
        ExecutorCompletionService<AudioItem> completion = new ExecutorCompletionService<AudioItem>(this.mixLoadingExecutor);
        ArrayList<AudioTrack> tracks = new ArrayList<AudioTrack>();
        for (String videoId : videoIds) {
            completion.submit(() -> this.loadTrackWithVideoId(videoId, true));
        }
        try {
            this.fetchTrackResultsFromExecutor(completion, tracks, videoIds.size());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        AudioTrack selectedTrack = this.findSelectedTrack(tracks, selectedVideoId);
        if (tracks.isEmpty()) {
            throw new FriendlyException("No tracks from the mix loaded succesfully.", FriendlyException.Severity.SUSPICIOUS, null);
        }
        if (selectedTrack == null) {
            throw new FriendlyException("The selected track of the mix failed to load.", FriendlyException.Severity.SUSPICIOUS, null);
        }
        return new BasicAudioPlaylist("YouTube mix", tracks, selectedTrack, false);
    }

    private void fetchTrackResultsFromExecutor(ExecutorCompletionService<AudioItem> completion, List<AudioTrack> tracks, int size) throws InterruptedException {
        for (int i = 0; i < size; ++i) {
            try {
                AudioItem item = completion.take().get();
                if (!(item instanceof AudioTrack)) continue;
                tracks.add((AudioTrack)item);
                continue;
            }
            catch (ExecutionException e) {
                log.warn("Failed to load a track from a mix.", e);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private AudioItem loadSearchResult(String query) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private AudioItem extractSearchResults(Document document, String query) {
        ArrayList<AudioTrack> tracks = new ArrayList<AudioTrack>();
        for (Element results : document.select("#page > #content #results")) {
            for (Element result : results.select(".yt-lockup-video")) {
                this.extractTrackFromResultEntry(tracks, result);
            }
        }
        if (tracks.isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        return new BasicAudioPlaylist("Search results for: " + query, tracks, null, true);
    }

    private void extractTrackFromResultEntry(List<AudioTrack> tracks, Element element) {
        Element durationElement = element.select(".video-time").first();
        Element contentElement = element.select(".yt-lockup-content").first();
        String videoId = element.attr("data-context-item-id");
        if (durationElement == null || contentElement == null || videoId.isEmpty()) {
            return;
        }
        long length = (long)YoutubeAudioSourceManager.lengthTextToSeconds(durationElement.text()) * 1000L;
        String title = contentElement.select(".yt-lockup-title > a").text();
        String author = contentElement.select(".yt-lockup-byline > a").text();
        tracks.add(new YoutubeAudioTrack(new AudioTrackInfo(title, author, length, videoId, false), this));
    }
}

