/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.natives;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.IOUtils;

public class NativeLibLoader {
    private static final String LINUX_X86 = "linux-x86";
    private static final String LINUX_X86_64 = "linux-x86-64";
    private static final String WIN_X86 = "win-x86";
    private static final String WIN_X86_64 = "win-x86-64";
    private static final String DARWIN = "darwin";
    private static final Set<String> loadedLibraries;
    private static final String systemType;
    private static final String libraryPrefix;
    private static final String librarySuffix;
    private static final String libraryDirectory;

    public static void load(String systemTypeFilter, String name) {
        if (systemType.equals(systemTypeFilter)) {
            NativeLibLoader.load(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(String name) {
        Set<String> set = loadedLibraries;
        synchronized (set) {
            if (!loadedLibraries.contains(name)) {
                try {
                    System.load(NativeLibLoader.extractLibrary(name).toFile().getAbsolutePath());
                    loadedLibraries.add(name);
                }
                catch (Exception e) {
                    throw new LinkageError("Failed to load native library due to an exception.", e);
                }
            }
        }
    }

    private static Path extractLibrary(String name) throws IOException {
        Path extractedLibrary;
        String path = "/natives/" + systemType + "/" + libraryPrefix + name + librarySuffix;
        try (InputStream libraryStream = NativeLibLoader.class.getResourceAsStream(path);){
            if (libraryStream == null) {
                throw new UnsatisfiedLinkError("Required library at " + path + " was not found");
            }
            File temporaryContainer = new File(System.getProperty("java.io.tmpdir"), "lava-jni-natives/" + libraryDirectory);
            if (!temporaryContainer.mkdirs() && !temporaryContainer.exists()) {
                throw new IOException("Failed to create directory for unpacked native library.");
            }
            extractedLibrary = new File(temporaryContainer, libraryPrefix + name + librarySuffix).toPath();
            try (FileOutputStream fileStream = new FileOutputStream(extractedLibrary.toFile());){
                IOUtils.copy(libraryStream, (OutputStream)fileStream);
            }
        }
        return extractedLibrary;
    }

    public static void loadConnectorLibrary() {
        NativeLibLoader.load(WIN_X86_64, "libmpg123-0");
        NativeLibLoader.load(WIN_X86, "libgcc_s_sjlj-1");
        NativeLibLoader.load(WIN_X86, "libmpg123-0");
        NativeLibLoader.load("connector");
    }

    static {
        String osName = System.getProperty("os.name");
        String bits = System.getProperty("sun.arch.data.model");
        libraryDirectory = String.valueOf(System.currentTimeMillis());
        loadedLibraries = new HashSet<String>();
        if (osName.startsWith("Linux")) {
            systemType = "64".equals(bits) ? LINUX_X86_64 : LINUX_X86;
            libraryPrefix = "lib";
            librarySuffix = ".so";
        } else if ((osName.startsWith("Mac") || osName.startsWith("Darwin")) && "64".equals(bits)) {
            systemType = DARWIN;
            libraryPrefix = "lib";
            librarySuffix = ".dylib";
        } else if (osName.startsWith("Windows") && !osName.startsWith("Windows CE")) {
            systemType = "64".equals(bits) ? WIN_X86_64 : WIN_X86;
            libraryPrefix = "";
            librarySuffix = ".dll";
        } else {
            throw new IllegalStateException("Native libraries not supported on this platform.");
        }
    }
}

