/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.filter.volume;

import com.sedmelluq.discord.lavaplayer.filter.volume.PcmVolumeProcessor;
import com.sedmelluq.discord.lavaplayer.natives.opus.OpusDecoder;
import com.sedmelluq.discord.lavaplayer.natives.opus.OpusEncoder;
import com.sedmelluq.discord.lavaplayer.player.AudioConfiguration;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioFrame;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioFrameConsumer;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioFrameRebuilder;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;

public class AudioFrameVolumeChanger
implements AudioFrameRebuilder {
    private final AudioConfiguration configuration;
    private final int newVolume;
    private final ByteBuffer encodedBuffer;
    private final ShortBuffer sampleBuffer;
    private final PcmVolumeProcessor volumeProcessor;
    private OpusEncoder encoder;
    private OpusDecoder decoder;
    private int frameIndex;

    private AudioFrameVolumeChanger(AudioConfiguration configuration, int newVolume) {
        this.configuration = configuration;
        this.newVolume = newVolume;
        this.encodedBuffer = ByteBuffer.allocateDirect(4096);
        this.sampleBuffer = ByteBuffer.allocateDirect(3840).order(ByteOrder.nativeOrder()).asShortBuffer();
        this.volumeProcessor = new PcmVolumeProcessor(100);
    }

    @Override
    public AudioFrame rebuild(AudioFrame frame) {
        if (frame.volume == this.newVolume) {
            return frame;
        }
        this.encodedBuffer.clear();
        this.encodedBuffer.put(frame.data);
        this.encodedBuffer.flip();
        this.sampleBuffer.clear();
        this.decoder.decode(this.encodedBuffer, this.sampleBuffer);
        this.encodedBuffer.clear();
        int targetVolume = this.newVolume;
        if (++this.frameIndex < 50) {
            targetVolume = (int)((double)(this.newVolume - frame.volume) * ((double)this.frameIndex / 50.0) + (double)frame.volume);
        }
        if (targetVolume != 0) {
            this.volumeProcessor.applyVolume(frame.volume, targetVolume, this.sampleBuffer);
        }
        this.encoder.encode(this.sampleBuffer, 960, this.encodedBuffer);
        byte[] bytes = new byte[this.encodedBuffer.remaining()];
        this.encodedBuffer.get(bytes);
        try {
            Thread.sleep(5L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return new AudioFrame(frame.timecode, bytes, targetVolume);
    }

    private void setupLibraries() {
        this.encoder = new OpusEncoder(48000, 2, this.configuration.getOpusEncodingQuality());
        this.decoder = new OpusDecoder(48000, 2);
    }

    private void clearLibraries() {
        if (this.encoder != null) {
            this.encoder.close();
        }
        if (this.decoder != null) {
            this.decoder.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void apply(AudioConfiguration configuration, AudioFrameConsumer frameConsumer, int newVolume) {
        AudioFrameVolumeChanger volumeChanger = new AudioFrameVolumeChanger(configuration, newVolume);
        try {
            volumeChanger.setupLibraries();
            frameConsumer.rebuild(volumeChanger);
        }
        finally {
            volumeChanger.clearLibraries();
        }
    }
}

