/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.filter;

import com.sedmelluq.discord.lavaplayer.filter.FloatPcmAudioFilter;
import com.sedmelluq.discord.lavaplayer.filter.ShortPcmAudioFilter;
import com.sedmelluq.discord.lavaplayer.filter.SplitShortPcmAudioFilter;
import java.nio.ShortBuffer;

public class ShortToFloatPcmAudioFilter
implements ShortPcmAudioFilter,
SplitShortPcmAudioFilter {
    private static final int BUFFER_SIZE = 4096;
    private final FloatPcmAudioFilter downstream;
    private final float[][] buffers;

    public ShortToFloatPcmAudioFilter(int channelCount, FloatPcmAudioFilter downstream) {
        this.downstream = downstream;
        this.buffers = new float[channelCount][];
        for (int i = 0; i < channelCount; ++i) {
            this.buffers[i] = new float[4096];
        }
    }

    @Override
    public void seekPerformed(long requestedTime, long providedTime) {
        this.downstream.seekPerformed(requestedTime, providedTime);
    }

    @Override
    public void flush() throws InterruptedException {
        this.downstream.flush();
    }

    @Override
    public void close() {
        this.downstream.close();
    }

    @Override
    public void process(short[] input, int offset, int length) throws InterruptedException {
        this.process(ShortBuffer.wrap(input, offset, length));
    }

    @Override
    public void process(ShortBuffer buffer) throws InterruptedException {
        int pos = 0;
        while (buffer.remaining() > 0) {
            for (int i = 0; i < this.buffers.length; ++i) {
                this.buffers[i][pos] = (float)buffer.get() / 32768.0f;
            }
            if (++pos != 4096) continue;
            this.downstream.process(this.buffers, 0, pos);
            pos = 0;
        }
        if (pos > 0) {
            this.downstream.process(this.buffers, 0, pos);
        }
    }

    @Override
    public void process(short[][] input, int offset, int length) throws InterruptedException {
        int chunkSize;
        int inputEndPosition = offset + length;
        for (int inputPosition = offset; inputPosition < inputEndPosition; inputPosition += chunkSize) {
            chunkSize = Math.min(this.buffers[0].length, inputEndPosition - inputPosition);
            for (int channel = 0; channel < this.buffers.length; ++channel) {
                for (int i = 0; i < chunkSize; ++i) {
                    this.buffers[channel][i] = (float)input[channel][inputPosition + i] / 32768.0f;
                }
            }
            this.downstream.process(this.buffers, 0, chunkSize);
        }
    }
}

