/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.filter;

import com.sedmelluq.discord.lavaplayer.filter.FloatPcmAudioFilter;
import com.sedmelluq.discord.lavaplayer.filter.ShortPcmAudioFilter;
import com.sedmelluq.discord.lavaplayer.filter.SplitShortPcmAudioFilter;
import com.sedmelluq.discord.lavaplayer.filter.volume.AudioFrameVolumeChanger;
import com.sedmelluq.discord.lavaplayer.filter.volume.PcmVolumeProcessor;
import com.sedmelluq.discord.lavaplayer.natives.opus.OpusEncoder;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioFrame;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioProcessingContext;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpusEncodingPcmAudioFilter
implements FloatPcmAudioFilter,
ShortPcmAudioFilter,
SplitShortPcmAudioFilter {
    private static final Logger log = LoggerFactory.getLogger(OpusEncodingPcmAudioFilter.class);
    private static final short[] zeroPadding = new short[128];
    public static final int FREQUENCY = 48000;
    public static final int CHANNEL_COUNT = 2;
    public static final int FRAME_SIZE = 960;
    private static final int CHUNK_LENGTH_MS = 20;
    private static final int SAMPLES_PER_MS = 48;
    private final AudioProcessingContext context;
    private final ShortBuffer frameBuffer;
    private final ByteBuffer encoded;
    private final OpusEncoder opusEncoder;
    private final PcmVolumeProcessor volumeProcessor;
    private long ignoredFrames;
    private long nextTimecode;

    public OpusEncodingPcmAudioFilter(AudioProcessingContext context) {
        this.context = context;
        this.frameBuffer = ByteBuffer.allocateDirect(3840).order(ByteOrder.nativeOrder()).asShortBuffer();
        this.encoded = ByteBuffer.allocateDirect(4096);
        this.volumeProcessor = new PcmVolumeProcessor(context.volumeLevel.get());
        this.opusEncoder = new OpusEncoder(48000, 2, context.configuration.getOpusEncodingQuality());
        this.nextTimecode = 0L;
    }

    private short decodeSample(float sample) {
        return (short)Math.min(Math.max((int)(sample * 32768.0f), Short.MIN_VALUE), Short.MAX_VALUE);
    }

    @Override
    public void seekPerformed(long requestedTime, long providedTime) {
        this.frameBuffer.clear();
        this.ignoredFrames = requestedTime > providedTime ? (requestedTime - providedTime) * 48L * 2L : 0L;
        this.nextTimecode = Math.max(requestedTime, providedTime);
        if (this.ignoredFrames > 0L) {
            log.debug("Ignoring {} frames due to inaccurate seek (requested {}, provided {}).", this.ignoredFrames, requestedTime, providedTime);
        }
    }

    @Override
    public void flush() throws InterruptedException {
        if (this.frameBuffer.position() > 0) {
            this.fillFrameBuffer();
            this.dispatch();
        }
    }

    @Override
    public void close() {
        this.opusEncoder.close();
    }

    private void fillFrameBuffer() {
        while (this.frameBuffer.remaining() >= zeroPadding.length) {
            this.frameBuffer.put(zeroPadding);
        }
        while (this.frameBuffer.remaining() > 0) {
            this.frameBuffer.put((short)0);
        }
    }

    @Override
    public void process(short[] input, int offset, int length) throws InterruptedException {
        for (int i = 0; i < length; ++i) {
            if (this.ignoredFrames > 0L) {
                --this.ignoredFrames;
                continue;
            }
            this.frameBuffer.put(input[offset + i]);
            this.dispatch();
        }
    }

    @Override
    public void process(short[][] input, int offset, int length) throws InterruptedException {
        int secondChannelIndex = Math.min(1, input.length - 1);
        for (int i = 0; i < length; ++i) {
            if (this.ignoredFrames > 0L) {
                this.ignoredFrames -= 2L;
                continue;
            }
            this.frameBuffer.put(input[0][offset + i]);
            this.frameBuffer.put(input[secondChannelIndex][offset + i]);
            this.dispatch();
        }
    }

    @Override
    public void process(ShortBuffer buffer) throws InterruptedException {
        ShortBuffer local = buffer.duplicate();
        while (buffer.remaining() > 0) {
            if (this.ignoredFrames > 0L) {
                --this.ignoredFrames;
                continue;
            }
            int chunk = Math.min(buffer.remaining(), this.frameBuffer.remaining());
            local.position(buffer.position());
            local.limit(local.position() + chunk);
            this.frameBuffer.put(local);
            this.dispatch();
            buffer.position(buffer.position() + chunk);
        }
    }

    @Override
    public void process(float[][] buffer, int offset, int length) throws InterruptedException {
        int secondChannelIndex = Math.min(1, buffer.length - 1);
        for (int i = 0; i < length; ++i) {
            if (this.ignoredFrames > 0L) {
                --this.ignoredFrames;
                continue;
            }
            this.frameBuffer.put(this.decodeSample(buffer[0][offset + i]));
            this.frameBuffer.put(this.decodeSample(buffer[secondChannelIndex][offset + i]));
            this.dispatch();
        }
    }

    private void dispatch() throws InterruptedException {
        if (!this.frameBuffer.hasRemaining()) {
            int currentVolume = this.context.volumeLevel.get();
            if (currentVolume != this.volumeProcessor.getLastVolume()) {
                AudioFrameVolumeChanger.apply(this.context.configuration, this.context.frameConsumer, currentVolume);
            }
            this.frameBuffer.clear();
            if (currentVolume != 0) {
                this.volumeProcessor.applyVolume(100, currentVolume, this.frameBuffer);
            } else {
                this.volumeProcessor.setLastVolume(0);
            }
            this.encoded.clear();
            int encodedLength = this.opusEncoder.encode(this.frameBuffer, 960, this.encoded);
            byte[] encodedBytes = new byte[encodedLength];
            this.encoded.get(encodedBytes);
            this.context.frameConsumer.consume(new AudioFrame(this.nextTimecode, encodedBytes, currentVolume));
            this.frameBuffer.clear();
            this.nextTimecode += 20L;
        }
    }
}

