/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.filter;

import com.sedmelluq.discord.lavaplayer.filter.ChannelCountPcmAudioFilter;
import com.sedmelluq.discord.lavaplayer.filter.FloatPcmAudioFilter;
import com.sedmelluq.discord.lavaplayer.filter.OpusEncodingPcmAudioFilter;
import com.sedmelluq.discord.lavaplayer.filter.ResamplingPcmAudioFilter;
import com.sedmelluq.discord.lavaplayer.filter.ShortPcmAudioFilter;
import com.sedmelluq.discord.lavaplayer.filter.ShortToFloatPcmAudioFilter;
import com.sedmelluq.discord.lavaplayer.filter.SplitShortPcmAudioFilter;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioProcessingContext;

public class FilterChainBuilder {
    public static ShortPcmAudioFilter forShortPcm(AudioProcessingContext context, int channels, int frequency, boolean noPartialFrames) {
        OpusEncodingPcmAudioFilter opusEncoder = new OpusEncodingPcmAudioFilter(context);
        int outChannels = 2;
        ShortPcmAudioFilter filter = frequency != 48000 ? new ShortToFloatPcmAudioFilter(outChannels, new ResamplingPcmAudioFilter(context.configuration, outChannels, opusEncoder, frequency, 48000)) : opusEncoder;
        if (channels != outChannels || !noPartialFrames) {
            filter = new ChannelCountPcmAudioFilter(channels, outChannels, filter);
        }
        return filter;
    }

    public static SplitShortPcmAudioFilter forSplitShortPcm(AudioProcessingContext context, int frequency) {
        OpusEncodingPcmAudioFilter opusEncoder = new OpusEncodingPcmAudioFilter(context);
        int outChannels = 2;
        ShortPcmAudioFilter filter = frequency != 48000 ? new ShortToFloatPcmAudioFilter(outChannels, new ResamplingPcmAudioFilter(context.configuration, outChannels, opusEncoder, frequency, 48000)) : opusEncoder;
        return filter;
    }

    public static FloatPcmAudioFilter forFloatPcm(AudioProcessingContext context, int channels, int frequency) {
        FloatPcmAudioFilter filter = new OpusEncodingPcmAudioFilter(context);
        if (frequency != 48000) {
            filter = new ResamplingPcmAudioFilter(context.configuration, channels, filter, frequency, 48000);
        }
        return filter;
    }
}

