/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.container.ogg;

import com.sedmelluq.discord.lavaplayer.container.ogg.OggPacketInputStream;
import com.sedmelluq.discord.lavaplayer.container.ogg.OggTrackProvider;
import com.sedmelluq.discord.lavaplayer.filter.FilterChainBuilder;
import com.sedmelluq.discord.lavaplayer.filter.FloatPcmAudioFilter;
import com.sedmelluq.discord.lavaplayer.natives.vorbis.VorbisDecoder;
import com.sedmelluq.discord.lavaplayer.tools.io.DirectBufferStreamBroker;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioProcessingContext;
import java.io.IOException;
import java.nio.ByteBuffer;

public class OggVorbisTrackProvider
implements OggTrackProvider {
    private static final int PCM_BUFFER_SIZE = 4096;
    private final OggPacketInputStream packetInputStream;
    private final DirectBufferStreamBroker broker;
    private final VorbisDecoder decoder;
    private final int sampleRate;
    private float[][] channelPcmBuffers;
    private FloatPcmAudioFilter downstream;

    public OggVorbisTrackProvider(OggPacketInputStream packetInputStream, DirectBufferStreamBroker broker) {
        this.packetInputStream = packetInputStream;
        this.broker = broker;
        this.decoder = new VorbisDecoder();
        this.sampleRate = Integer.reverseBytes(broker.getBuffer().getInt(12));
        int channelCount = broker.getBuffer().get(11) & 0xFF;
        this.channelPcmBuffers = new float[channelCount][];
        for (int i = 0; i < this.channelPcmBuffers.length; ++i) {
            this.channelPcmBuffers[i] = new float[4096];
        }
    }

    @Override
    public void initialise(AudioProcessingContext context) throws IOException {
        this.passHeader(0);
        this.passHeader(1);
        this.passHeader(2);
        this.decoder.initialise();
        this.broker.resetAndCompact();
        this.downstream = FilterChainBuilder.forFloatPcm(context, this.decoder.getChannelCount(), this.sampleRate);
    }

    private void passHeader(int index) throws IOException {
        if (index > 0) {
            if (!this.packetInputStream.startNewPacket()) {
                throw new IllegalStateException("End of track before header " + index + " .");
            }
            this.broker.consume(true, this.packetInputStream);
        }
        ByteBuffer headerBuffer = this.broker.getBuffer();
        this.decoder.parseHeader(headerBuffer, headerBuffer.limit(), index == 0);
    }

    @Override
    public void provideFrames() throws InterruptedException {
        try {
            while (this.packetInputStream.startNewPacket()) {
                this.broker.consume(true, this.packetInputStream);
                this.provideFromBuffer(this.broker.getBuffer());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void provideFromBuffer(ByteBuffer buffer) throws InterruptedException {
        int output;
        this.decoder.input(buffer);
        do {
            if ((output = this.decoder.output(this.channelPcmBuffers)) <= 0) continue;
            this.downstream.process(this.channelPcmBuffers, 0, output);
        } while (output == 4096);
    }

    @Override
    public void seekToTimecode(long timecode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        if (this.downstream != null) {
            this.downstream.close();
        }
        this.decoder.close();
    }
}

