/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.container.mpeg;

import com.sedmelluq.discord.lavaplayer.container.MediaContainerDetection;
import com.sedmelluq.discord.lavaplayer.container.MediaContainerDetectionResult;
import com.sedmelluq.discord.lavaplayer.container.MediaContainerProbe;
import com.sedmelluq.discord.lavaplayer.container.mpeg.MpegAudioTrack;
import com.sedmelluq.discord.lavaplayer.container.mpeg.MpegFileLoader;
import com.sedmelluq.discord.lavaplayer.container.mpeg.MpegNoopTrackConsumer;
import com.sedmelluq.discord.lavaplayer.container.mpeg.MpegTrackInfo;
import com.sedmelluq.discord.lavaplayer.container.mpeg.reader.MpegFileTrackProvider;
import com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MpegContainerProbe
implements MediaContainerProbe {
    private static final Logger log = LoggerFactory.getLogger(MpegContainerProbe.class);
    private static final int[] ISO_TAG = new int[]{0, 0, 0, -1, 102, 116, 121, 112};

    @Override
    public String getName() {
        return "mp4";
    }

    @Override
    public MediaContainerDetectionResult probe(AudioReference reference, SeekableInputStream inputStream) throws IOException {
        if (!MediaContainerDetection.checkNextBytes(inputStream, ISO_TAG)) {
            return null;
        }
        log.debug("Track {} is an MP4 file.", (Object)reference.identifier);
        MpegFileLoader file = new MpegFileLoader(inputStream);
        file.parseHeaders();
        MpegTrackInfo audioTrack = this.getSupportedAudioTrack(file);
        if (audioTrack == null) {
            return new MediaContainerDetectionResult((MediaContainerProbe)this, "No supported audio format in the MP4 file.");
        }
        MpegNoopTrackConsumer trackConsumer = new MpegNoopTrackConsumer(audioTrack);
        MpegFileTrackProvider fileReader = file.loadReader(trackConsumer);
        if (fileReader == null) {
            return new MediaContainerDetectionResult((MediaContainerProbe)this, "MP4 file uses an unsupported format.");
        }
        return new MediaContainerDetectionResult((MediaContainerProbe)this, new AudioTrackInfo(DataFormatTools.defaultOnNull(file.getTextMetadata("Title"), "Unknown title"), DataFormatTools.defaultOnNull(file.getTextMetadata("Artist"), "Unknown artist"), fileReader.getDuration(), reference.identifier, false));
    }

    @Override
    public AudioTrack createTrack(AudioTrackInfo trackInfo, SeekableInputStream inputStream) {
        return new MpegAudioTrack(trackInfo, inputStream);
    }

    private MpegTrackInfo getSupportedAudioTrack(MpegFileLoader file) {
        for (MpegTrackInfo track : file.getTrackList()) {
            if (!"soun".equals(track.handler) || !"mp4a".equals(track.codecName)) continue;
            return track;
        }
        return null;
    }
}

