/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.container.matroska;

import com.sedmelluq.discord.lavaplayer.container.matroska.MatroskaTrackConsumer;
import com.sedmelluq.discord.lavaplayer.container.mpeg.MpegAacTrackConsumer;
import com.sedmelluq.discord.lavaplayer.filter.FilterChainBuilder;
import com.sedmelluq.discord.lavaplayer.filter.ShortPcmAudioFilter;
import com.sedmelluq.discord.lavaplayer.natives.aac.AacDecoder;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioProcessingContext;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import org.ebml.matroska.MatroskaFileFrame;
import org.ebml.matroska.MatroskaFileTrack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatroskaAacTrackConsumer
implements MatroskaTrackConsumer {
    private static final Logger log = LoggerFactory.getLogger(MpegAacTrackConsumer.class);
    private final MatroskaFileTrack track;
    private final ByteBuffer inputBuffer;
    private final ShortBuffer outputBuffer;
    private final ShortPcmAudioFilter downstream;
    private AacDecoder decoder;

    public MatroskaAacTrackConsumer(AudioProcessingContext context, MatroskaFileTrack track) {
        this.track = track;
        this.decoder = new AacDecoder();
        this.inputBuffer = ByteBuffer.allocateDirect(4096);
        this.outputBuffer = ByteBuffer.allocateDirect(2048 * track.getAudio().getChannels()).order(ByteOrder.nativeOrder()).asShortBuffer();
        this.downstream = FilterChainBuilder.forShortPcm(context, track.getAudio().getChannels(), (int)track.getAudio().getSamplingFrequency(), true);
    }

    @Override
    public void initialise() {
        log.debug("Initialising AAC track with frequency {} and channel count {}.", (Object)Float.valueOf(this.track.getAudio().getSamplingFrequency()), (Object)this.track.getAudio().getChannels());
        this.configureDecoder();
    }

    private void configureDecoder() {
        ByteBuffer buffer = this.track.getCodecPrivate().duplicate();
        byte[] header = new byte[buffer.remaining()];
        buffer.get(header);
        this.decoder.configure(header);
    }

    @Override
    public MatroskaFileTrack getTrack() {
        return this.track;
    }

    @Override
    public void seekPerformed(long requestedTimecode, long providedTimecode) {
        this.downstream.seekPerformed(requestedTimecode, providedTimecode);
        this.decoder.close();
        this.decoder = new AacDecoder();
        this.configureDecoder();
    }

    @Override
    public void flush() throws InterruptedException {
        while (this.decoder.decode(this.outputBuffer, true)) {
            this.downstream.process(this.outputBuffer);
            this.outputBuffer.clear();
        }
    }

    @Override
    public void consume(MatroskaFileFrame frame) throws InterruptedException {
        ByteBuffer buffer = frame.getData();
        while (buffer.hasRemaining()) {
            int chunk = Math.min(buffer.remaining(), this.inputBuffer.capacity());
            ByteBuffer chunkBuffer = buffer.duplicate();
            chunkBuffer.limit(chunkBuffer.position() + chunk);
            this.inputBuffer.clear();
            this.inputBuffer.put(chunkBuffer);
            this.inputBuffer.flip();
            this.decoder.fill(this.inputBuffer);
            while (this.decoder.decode(this.outputBuffer, false)) {
                this.downstream.process(this.outputBuffer);
                this.outputBuffer.clear();
            }
            buffer.position(chunkBuffer.position());
        }
    }

    @Override
    public void close() {
        this.downstream.close();
        this.decoder.close();
    }
}

