/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.container.common;

import com.sedmelluq.discord.lavaplayer.filter.FilterChainBuilder;
import com.sedmelluq.discord.lavaplayer.filter.ShortPcmAudioFilter;
import com.sedmelluq.discord.lavaplayer.filter.volume.AudioFrameVolumeChanger;
import com.sedmelluq.discord.lavaplayer.natives.opus.OpusDecoder;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioFrame;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioProcessingContext;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpusPacketRouter {
    private static final Logger log = LoggerFactory.getLogger(OpusPacketRouter.class);
    private final AudioProcessingContext context;
    private final boolean hasStandardInput;
    private final int inputFrequency;
    private final int inputChannels;
    private final byte[] headerBytes;
    private long currentTimecode;
    private boolean hasStandardSize;
    private OpusDecoder opusDecoder;
    private ShortPcmAudioFilter downstream;
    private ByteBuffer directInput;
    private ShortBuffer frameBuffer;

    public OpusPacketRouter(AudioProcessingContext context, int inputFrequency, int inputChannels) {
        this.context = context;
        this.hasStandardInput = inputFrequency == 48000 && inputChannels == 2;
        this.inputFrequency = inputFrequency;
        this.inputChannels = inputChannels;
        this.headerBytes = new byte[2];
        this.hasStandardSize = true;
    }

    public void seekPerformed(long requestedTimecode, long providedTimecode) {
        this.currentTimecode = providedTimecode;
        if (this.downstream != null) {
            this.downstream.seekPerformed(requestedTimecode, providedTimecode);
        }
    }

    public void flush() throws InterruptedException {
        if (this.downstream != null) {
            this.downstream.flush();
        }
    }

    public void process(ByteBuffer buffer) throws InterruptedException {
        int frameSize = this.processFrameSize(buffer);
        if (frameSize != 0) {
            this.checkDecoderNecessity();
            if (this.opusDecoder != null) {
                this.passDownstream(buffer, frameSize);
            } else {
                this.passThrough(buffer);
            }
        }
    }

    public void close() {
        if (this.opusDecoder != null) {
            this.destroyDecoder();
        }
    }

    private int processFrameSize(ByteBuffer buffer) {
        int frameSize;
        if (buffer.isDirect()) {
            buffer.mark();
            buffer.get(this.headerBytes);
            buffer.reset();
            frameSize = OpusDecoder.getPacketFrameSize(this.inputFrequency, this.headerBytes, 0, this.headerBytes.length);
        } else {
            frameSize = OpusDecoder.getPacketFrameSize(this.inputFrequency, buffer.array(), buffer.position(), buffer.remaining());
        }
        if (frameSize == 0) {
            return 0;
        }
        if (frameSize != 960) {
            this.hasStandardSize = false;
        }
        this.currentTimecode += (long)(frameSize * 1000 / this.inputFrequency);
        return frameSize;
    }

    private void passDownstream(ByteBuffer buffer, int frameSize) throws InterruptedException {
        ByteBuffer nativeBuffer;
        if (!buffer.isDirect()) {
            if (this.directInput == null || this.directInput.capacity() < buffer.remaining()) {
                this.directInput = ByteBuffer.allocateDirect(buffer.remaining() + 200);
            }
            this.directInput.clear();
            this.directInput.put(buffer);
            this.directInput.flip();
            nativeBuffer = this.directInput;
        } else {
            nativeBuffer = buffer;
        }
        if (this.frameBuffer == null || this.frameBuffer.capacity() < frameSize * this.inputChannels) {
            this.frameBuffer = ByteBuffer.allocateDirect(frameSize * this.inputChannels * 2).order(ByteOrder.nativeOrder()).asShortBuffer();
        }
        this.frameBuffer.clear();
        this.frameBuffer.limit(frameSize);
        this.opusDecoder.decode(nativeBuffer, this.frameBuffer);
        this.downstream.process(this.frameBuffer);
    }

    private void passThrough(ByteBuffer buffer) throws InterruptedException {
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        this.context.frameConsumer.consume(new AudioFrame(this.currentTimecode, bytes, 100));
    }

    private boolean needsDecoding() {
        return this.context.volumeLevel.get() != 100 || !this.hasStandardSize || !this.hasStandardInput;
    }

    private void checkDecoderNecessity() {
        if (this.needsDecoding()) {
            if (this.opusDecoder == null) {
                log.debug("Enabling reencode mode on opus track.");
                this.initialiseDecoder();
                AudioFrameVolumeChanger.apply(this.context.configuration, this.context.frameConsumer, this.context.volumeLevel.get());
            }
        } else if (this.opusDecoder != null) {
            log.debug("Enabling passthrough mode on opus track.");
            this.destroyDecoder();
            AudioFrameVolumeChanger.apply(this.context.configuration, this.context.frameConsumer, this.context.volumeLevel.get());
        }
    }

    private void initialiseDecoder() {
        this.opusDecoder = new OpusDecoder(this.inputFrequency, this.inputChannels);
        this.downstream = FilterChainBuilder.forShortPcm(this.context, this.inputChannels, this.inputFrequency, true);
        this.downstream.seekPerformed(this.currentTimecode, this.currentTimecode);
    }

    private void destroyDecoder() {
        this.opusDecoder.close();
        this.opusDecoder = null;
        this.downstream.close();
        this.downstream = null;
        this.directInput = null;
        this.frameBuffer = null;
    }
}

