/*
 * Decompiled with CFR 0.152.
 */
package org.ebml.matroska;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.ebml.EBMLReader;
import org.ebml.Element;
import org.ebml.io.DataWriter;
import org.ebml.matroska.MatroskaDocTypes;

public class VoidElement
extends Element {
    private static final long MAX_SIZE = (long)(Math.pow(2.0, 56.0) - 2.0);
    private long realSize;

    public VoidElement(long size) {
        this.setElementType(MatroskaDocTypes.Void);
        this.setType(MatroskaDocTypes.Void.getType());
        this.setSize(size);
    }

    @Override
    public long writeHeaderData(DataWriter writer) {
        int len = 0;
        byte[] encodedSize = Element.makeEbmlCodedSize(this.getSize(), (int)Math.min(this.realSize - (long)(len += this.getType().remaining()), 8L));
        ByteBuffer buf = ByteBuffer.allocate(len += encodedSize.length);
        buf.put(this.getType());
        buf.put(encodedSize);
        buf.flip();
        LOG.trace("Writing out header {}, {}", (Object)buf.remaining(), (Object)EBMLReader.bytesToHex(buf.array()));
        writer.write(buf);
        return len;
    }

    @Override
    public long writeData(DataWriter ioDW) {
        byte[] voids = new byte[(int)this.getSize()];
        Arrays.fill(voids, (byte)1);
        return ioDW.write(ByteBuffer.wrap(voids));
    }

    @Override
    public void setSize(long size) {
        if (size < 2L || size > MAX_SIZE) {
            throw new IllegalArgumentException("Size must be greater than one and less than (2^52 - 2)");
        }
        this.realSize = size;
        long partialSize = size - (long)this.type.remaining();
        super.setSize(partialSize - Math.min(partialSize, 8L));
    }

    public void reduceSize(long size) {
        super.setSize(this.getSize() - size);
    }
}

