/*
 * Decompiled with CFR 0.152.
 */
package org.ebml.matroska;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatroskaFileFrame {
    private static final Logger LOG = LoggerFactory.getLogger(MatroskaFileFrame.class);
    private int trackNo;
    private long timecode;
    private long duration = Long.MIN_VALUE;
    private ArrayList<Long> references = new ArrayList();
    private ByteBuffer data;
    private boolean keyFrame;

    public MatroskaFileFrame() {
        this.references = new ArrayList();
    }

    public MatroskaFileFrame(MatroskaFileFrame copy) {
        this.trackNo = copy.trackNo;
        this.setTimecode(copy.getTimecode());
        this.setDuration(copy.getDuration());
        this.setKeyFrame(copy.isKeyFrame());
        if (copy.getReferences() != null) {
            this.references.addAll(copy.getReferences());
        }
        if (copy.getData() != null) {
            this.setData(copy.getData().duplicate());
        }
    }

    public boolean isKeyFrame() {
        return this.keyFrame;
    }

    public void setKeyFrame(boolean keyFrame) {
        this.keyFrame = keyFrame;
    }

    public int getTrackNo() {
        return this.trackNo;
    }

    public void setTrackNo(int trackNo) {
        this.trackNo = trackNo;
    }

    public ArrayList<Long> getReferences() {
        return this.references;
    }

    public void addReferences(long ... references) {
        long[] lArray = references;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            Long ref = lArray[i];
            this.references.add(ref);
        }
    }

    public long getTimecode() {
        return this.timecode;
    }

    public void setTimecode(long timecode) {
        this.timecode = timecode;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public ByteBuffer getData() {
        return this.data.duplicate();
    }

    public void setData(ByteBuffer data) {
        LOG.trace("Setting data with size {}", (Object)data.remaining());
        this.data = data.duplicate();
    }
}

