/*
 * Decompiled with CFR 0.152.
 */
package org.ebml.matroska;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.ebml.MasterElement;
import org.ebml.UnsignedIntegerElement;
import org.ebml.io.DataWriter;
import org.ebml.matroska.MatroskaDocTypes;
import org.ebml.matroska.MatroskaFileFrame;
import org.ebml.matroska.MatroskaSimpleBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MatroskaCluster {
    private static final Logger LOG = LoggerFactory.getLogger(MatroskaCluster.class);
    private final Queue<MatroskaFileFrame> frames = new ConcurrentLinkedQueue<MatroskaFileFrame>();
    private final Set<Integer> tracks = new HashSet<Integer>();
    private final List<Long> sliencedTracks = new ArrayList<Long>();
    private long clusterTimecode = Long.MAX_VALUE;
    private int sizeLimit = Integer.MAX_VALUE;
    private int totalSize = 0;
    private long durationLimit = Long.MAX_VALUE;

    void setLimitParameters(long duration, int size) {
        this.sizeLimit = size;
        this.durationLimit = duration;
    }

    public boolean addFrame(MatroskaFileFrame frame) {
        if (frame.getTimecode() < this.clusterTimecode) {
            this.clusterTimecode = frame.getTimecode();
        }
        this.frames.add(frame);
        this.totalSize += frame.getData().remaining();
        this.tracks.add(frame.getTrackNo());
        return frame.getTimecode() - this.clusterTimecode < this.durationLimit && this.totalSize < this.sizeLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long flush(DataWriter ioDW) {
        if (this.frames.size() == 0) {
            return 0L;
        }
        try {
            MasterElement clusterElem = MatroskaDocTypes.Cluster.getInstance();
            UnsignedIntegerElement timecodeElem = MatroskaDocTypes.Timecode.getInstance();
            timecodeElem.setValue(this.clusterTimecode);
            clusterElem.addChildElement(timecodeElem);
            if (!this.sliencedTracks.isEmpty()) {
                MasterElement silentElem = MatroskaDocTypes.SilentTracks.getInstance();
                for (Long silent : this.sliencedTracks) {
                    UnsignedIntegerElement silentTrackElem = MatroskaDocTypes.SilentTrackNumber.getInstance();
                    silentTrackElem.setValue(silent);
                    silentElem.addChildElement(silentTrackElem);
                }
                clusterElem.addChildElement(silentElem);
            }
            MatroskaSimpleBlock block = null;
            boolean forceNew = true;
            long lastTimecode = 0L;
            int lastTrackNumber = 0;
            LOG.trace("Timecode for cluster set to {}", (Object)this.clusterTimecode);
            for (MatroskaFileFrame frame : this.frames) {
                frame.setTimecode(frame.getTimecode() - this.clusterTimecode);
                LOG.trace("Timecode for frame set to {}", (Object)frame.getTimecode());
                if (forceNew || lastTimecode != frame.getTimecode() || lastTrackNumber != frame.getTrackNo()) {
                    if (block != null) {
                        clusterElem.addChildElement(block.toElement());
                    }
                    block = new MatroskaSimpleBlock();
                }
                lastTimecode = frame.getTimecode();
                lastTrackNumber = frame.getTrackNo();
                forceNew = !block.addFrame(frame);
            }
            if (block != null) {
                clusterElem.addChildElement(block.toElement());
            }
            long l = clusterElem.writeElement(ioDW);
            return l;
        }
        finally {
            this.frames.clear();
            this.tracks.clear();
            this.totalSize = 0;
            this.clusterTimecode = Long.MAX_VALUE;
        }
    }

    public long getClusterTimecode() {
        return this.clusterTimecode;
    }

    public Collection<Integer> getTracks() {
        return this.tracks;
    }

    public void unsilenceTrack(long trackNumber) {
        this.sliencedTracks.remove(trackNumber);
    }

    public void silenceTrack(long trackNumber) {
        this.sliencedTracks.add(trackNumber);
    }
}

