/*
 * Decompiled with CFR 0.152.
 */
package org.ebml;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.ebml.EBMLReader;
import org.ebml.ProtoType;
import org.ebml.io.DataSource;
import org.ebml.io.DataWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Element {
    protected static final Logger LOG = LoggerFactory.getLogger(Element.class);
    private static int minSizeLength = 0;
    protected Element parent;
    protected ProtoType<?> typeInfo;
    protected ByteBuffer type;
    protected long size = 0L;
    protected ByteBuffer data = null;
    protected boolean dataRead = false;
    private Long headersSize = null;

    public Element(byte[] type) {
        this.type = ByteBuffer.wrap(type);
    }

    public Element() {
    }

    public void readData(DataSource source) {
        this.data = ByteBuffer.allocate((int)this.size);
        source.read(this.data);
        this.data.flip();
        this.dataRead = true;
        LOG.trace("Read {} bytes from {}", (Object)this.size, (Object)this.typeInfo.getName());
    }

    public void skipData(DataSource source) {
        if (!this.dataRead) {
            source.skip(this.size);
            this.dataRead = true;
        }
    }

    public long writeElement(DataWriter writer) {
        LOG.trace("Writing element {} with size {}", (Object)this.typeInfo.getName(), (Object)this.getTotalSize());
        return this.writeHeaderData(writer) + this.writeData(writer);
    }

    public long writeHeaderData(DataWriter writer) {
        int len = 0;
        len += this.getType().remaining();
        byte[] encodedSize = Element.makeEbmlCodedSize(this.getSize());
        ByteBuffer buf = ByteBuffer.allocate(len += encodedSize.length);
        buf.put(this.getType());
        buf.put(encodedSize);
        buf.flip();
        LOG.trace("Writing out header {}, {}", (Object)buf.remaining(), (Object)EBMLReader.bytesToHex(buf.array()));
        writer.write(buf);
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long writeData(DataWriter writer) {
        if (this.data == null) {
            throw new NullPointerException(String.format("No data to write: %s : %s", this.typeInfo.getName(), Arrays.toString(this.type.array())));
        }
        this.data.mark();
        try {
            LOG.trace("Writing data {} bytes of {}", (Object)this.data.remaining(), (Object)EBMLReader.bytesToHex(this.data.array()));
            long l = writer.write(this.data);
            return l;
        }
        finally {
            this.data.reset();
        }
    }

    public ByteBuffer getData() {
        return this.data.duplicate();
    }

    public void setData(ByteBuffer data) {
        this.data = data;
        this.size = data.remaining();
    }

    public void clearData() {
        this.data = null;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.headersSize = null;
        this.size = size;
    }

    public long getTotalSize() {
        long totalSize = 0L;
        if (this.headersSize != null) {
            totalSize += this.headersSize.longValue();
        } else {
            totalSize += (long)this.getType().array().length;
            totalSize += (long)Element.codedSizeLength(this.getSize(), 0);
        }
        return totalSize += this.getSize();
    }

    public ByteBuffer getType() {
        return this.type.duplicate();
    }

    public void setType(byte[] type) {
        this.type = ByteBuffer.wrap(type);
    }

    public void setType(ByteBuffer type) {
        this.type = type;
    }

    public void setElementType(ProtoType<?> typeInfo) {
        this.typeInfo = typeInfo;
    }

    public ProtoType<?> getElementType() {
        return this.typeInfo;
    }

    public Element getParent() {
        return this.parent;
    }

    public void setParent(Element parent) {
        this.parent = parent;
    }

    public boolean isType(byte[] typeId) {
        return Arrays.equals(this.type.array(), typeId);
    }

    public boolean isType(ByteBuffer typeId) {
        return typeId.equals(this.type);
    }

    public static void setMinSizeLength(int minSize) {
        minSizeLength = minSize;
    }

    public static int getMinSizeLength() {
        return minSizeLength;
    }

    public static byte[] makeEbmlCodedSize(long size) {
        return Element.makeEbmlCodedSize(size, 0);
    }

    public static byte[] makeEbmlCodedSize(long size, int minSizeLen) {
        int len = Element.codedSizeLength(size, minSizeLen);
        byte[] ret = new byte[len];
        long mask = 255L;
        for (int i = 0; i < len; ++i) {
            ret[len - 1 - i] = (byte)((size & mask) >>> i * 8);
            mask <<= 8;
        }
        ret[0] = (byte)(ret[0] | 128 >> len - 1);
        LOG.trace("Ebml coded size {} for {}", (Object)EBMLReader.bytesToHex(ret), (Object)size);
        return ret;
    }

    public static int getMinByteSize(long value) {
        long absValue = Math.abs(value);
        return Element.getMinByteSizeUnsigned(absValue << 1);
    }

    public static int getMinByteSizeUnsigned(long value) {
        int size = 8;
        long mask = -72057594037927936L;
        for (int i = 0; i < 8; ++i) {
            if ((value & mask) == 0L) {
                mask >>>= 8;
                --size;
                continue;
            }
            return size;
        }
        return 8;
    }

    public static int codedSizeLength(long value, int minSizeLen) {
        int codedSize = 0;
        if (value < 127L) {
            codedSize = 1;
        } else if (value < 16383L) {
            codedSize = 2;
        } else if (value < 0x1FFFFFL) {
            codedSize = 3;
        } else if (value < 0xFFFFFFFL) {
            codedSize = 4;
        }
        if (minSizeLen > 0 && codedSize <= minSizeLen) {
            codedSize = minSizeLen;
        }
        return codedSize;
    }

    public static byte[] packIntUnsigned(long value) {
        int size = Element.getMinByteSizeUnsigned(value);
        return Element.packInt(value, size);
    }

    public static byte[] packInt(long value) {
        int size = Element.getMinByteSize(value);
        return Element.packInt(value, size);
    }

    public static byte[] packInt(long value, int size) {
        byte[] ret = new byte[size];
        long mask = 255L;
        int b = size - 1;
        for (int i = 0; i < size; ++i) {
            ret[b] = (byte)(value >>> 8 * i & 0xFFL);
            --b;
        }
        return ret;
    }

    public void setHeadersSize(long headersSize) {
        this.headersSize = headersSize;
    }
}

