/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.utils;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.dv8tion.jda.core.OnlineStatus;
import net.dv8tion.jda.core.entities.Game;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.IMentionable;
import net.dv8tion.jda.core.entities.ISnowflake;
import net.dv8tion.jda.core.entities.impl.UserImpl;
import net.dv8tion.jda.core.exceptions.RateLimitedException;
import org.apache.http.util.Args;
import org.json.JSONArray;
import org.json.JSONObject;

public class WidgetUtil {
    public static final String WIDGET_PNG = "https://discordapp.com/api/guilds/%s/widget.png?style=%s";
    public static final String WIDGET_URL = "https://discordapp.com/api/guilds/%s/widget.json";
    public static final String WIDGET_HTML = "<iframe src=\"https://discordapp.com/widget?id=%s&theme=%s\" width=\"%d\" height=\"%d\" allowtransparency=\"true\" frameborder=\"0\"></iframe>";

    public static String getWidgetBanner(Guild guild, BannerType type) {
        Args.notNull(guild, "Guild");
        return WidgetUtil.getWidgetBanner(guild.getId(), type);
    }

    public static String getWidgetBanner(String guildId, BannerType type) {
        Args.notNull(guildId, "GuildId");
        Args.notNull(type, "BannerType");
        return String.format(WIDGET_PNG, guildId, type.name().toLowerCase());
    }

    public static String getPremadeWidgetHtml(Guild guild, WidgetTheme theme, int width, int height) {
        Args.notNull(guild, "Guild");
        return WidgetUtil.getPremadeWidgetHtml(guild.getId(), theme, width, height);
    }

    public static String getPremadeWidgetHtml(String guildId, WidgetTheme theme, int width, int height) {
        Args.notNull(guildId, "GuildId");
        Args.notNull(theme, "WidgetTheme");
        Args.notNegative(width, "Width");
        Args.notNegative(height, "Height");
        return String.format(WIDGET_HTML, guildId, theme.name().toLowerCase(), width, height);
    }

    public static Widget getWidget(String guildId) throws RateLimitedException {
        Args.notNull(guildId, "GuildId");
        try {
            HttpResponse<JsonNode> result = Unirest.get(String.format(WIDGET_URL, guildId)).asJson();
            switch (result.getStatus()) {
                case 200: {
                    return new Widget(result.getBody().getObject());
                }
                case 400: 
                case 404: {
                    return null;
                }
                case 403: {
                    return new Widget(guildId);
                }
                case 429: {
                    long retryAfter;
                    try {
                        retryAfter = result.getBody().getObject().getLong("retry_after");
                    }
                    catch (Exception e) {
                        retryAfter = 0L;
                    }
                    throw new RateLimitedException(WIDGET_URL, retryAfter);
                }
            }
            throw new RuntimeException("An unknown status was returned: " + result.getStatus() + " " + result.getStatusText());
        }
        catch (UnirestException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static class Widget
    implements ISnowflake {
        private final boolean isAvailable;
        private final String id;
        private final String name;
        private final String invite;
        private final HashMap<String, VoiceChannel> channels;
        private final HashMap<String, Member> members;

        private Widget(String guildId) {
            this.isAvailable = false;
            this.id = guildId;
            this.name = null;
            this.invite = null;
            this.channels = null;
            this.members = null;
        }

        private Widget(JSONObject json) {
            String inviteCode;
            String string = inviteCode = json.isNull("instant_invite") ? null : json.getString("instant_invite");
            if (inviteCode != null) {
                inviteCode = inviteCode.substring(inviteCode.lastIndexOf("/") + 1);
            }
            this.isAvailable = true;
            this.id = json.getString("id");
            this.name = json.getString("name");
            this.invite = inviteCode;
            this.channels = new HashMap();
            this.members = new HashMap();
            JSONArray channelsJson = json.getJSONArray("channels");
            for (int i = 0; i < channelsJson.length(); ++i) {
                JSONObject channel = channelsJson.getJSONObject(i);
                this.channels.put(channel.getString("id"), new VoiceChannel(channel, this));
            }
            JSONArray membersJson = json.getJSONArray("members");
            for (int i = 0; i < membersJson.length(); ++i) {
                JSONObject memberJson = membersJson.getJSONObject(i);
                Member member = new Member(memberJson, this);
                if (!memberJson.isNull("channel_id")) {
                    VoiceChannel channel = this.channels.get(memberJson.getString("channel_id"));
                    member.setVoiceState(new VoiceState(channel, memberJson.getBoolean("mute"), memberJson.getBoolean("deaf"), memberJson.getBoolean("suppress"), memberJson.getBoolean("self_mute"), memberJson.getBoolean("self_deaf"), member, this));
                    channel.addMember(member);
                }
                this.members.put(member.getId(), member);
            }
        }

        public boolean isAvailable() {
            return this.isAvailable;
        }

        @Override
        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getInviteCode() {
            return this.invite;
        }

        public List<VoiceChannel> getVoiceChannels() {
            return new ArrayList<VoiceChannel>(this.channels.values());
        }

        public VoiceChannel getVoiceChannelById(String id) {
            return this.channels.get(id);
        }

        public List<Member> getMembers() {
            return new ArrayList<Member>(this.members.values());
        }

        public Member getMemberById(String id) {
            return this.members.get(id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Widget)) {
                return false;
            }
            Widget oWidget = (Widget)obj;
            return this == oWidget || this.id.equals(oWidget.getId());
        }

        public String toString() {
            return "W:" + (this.isAvailable() ? this.getName() : "") + '(' + this.getId() + ')';
        }

        public static class VoiceState {
            private final VoiceChannel channel;
            private final boolean muted;
            private final boolean deafened;
            private final boolean suppress;
            private final boolean selfMute;
            private final boolean selfDeaf;
            private final Member member;
            private final Widget widget;

            private VoiceState(Member member, Widget widget) {
                this(null, false, false, false, false, false, member, widget);
            }

            private VoiceState(VoiceChannel channel, boolean muted, boolean deafened, boolean suppress, boolean selfMute, boolean selfDeaf, Member member, Widget widget) {
                this.channel = channel;
                this.muted = muted;
                this.deafened = deafened;
                this.suppress = suppress;
                this.selfMute = selfMute;
                this.selfDeaf = selfDeaf;
                this.member = member;
                this.widget = widget;
            }

            public VoiceChannel getChannel() {
                return this.channel;
            }

            public boolean inVoiceChannel() {
                return this.channel != null;
            }

            public boolean isGuildMuted() {
                return this.muted;
            }

            public boolean isGuildDeafened() {
                return this.deafened;
            }

            public boolean isSuppressed() {
                return this.suppress;
            }

            public boolean isSelfMuted() {
                return this.selfMute;
            }

            public boolean isSelfDeafened() {
                return this.selfDeaf;
            }

            public boolean isMuted() {
                return this.selfMute || this.muted;
            }

            public boolean isDeafened() {
                return this.selfDeaf || this.deafened;
            }

            public Member getMember() {
                return this.member;
            }

            public Widget getWidget() {
                return this.widget;
            }

            public int hashCode() {
                return this.member.hashCode();
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof VoiceState)) {
                    return false;
                }
                VoiceState oState = (VoiceState)obj;
                return this == oState || this.member.equals(oState.getMember()) && this.widget.equals(oState.getWidget());
            }

            public String toString() {
                return "VS:" + this.widget.getName() + ':' + this.member.getEffectiveName();
            }
        }

        public static class VoiceChannel {
            private final int position;
            private final String id;
            private final String name;
            private final List<Member> members;
            private final Widget widget;

            private VoiceChannel(JSONObject json, Widget widget) {
                this.widget = widget;
                this.position = json.getInt("position");
                this.id = json.getString("id");
                this.name = json.getString("name");
                this.members = new ArrayList<Member>();
            }

            private void addMember(Member member) {
                this.members.add(member);
            }

            public int getPosition() {
                return this.position;
            }

            public String getId() {
                return this.id;
            }

            public String getName() {
                return this.name;
            }

            public List<Member> getMembers() {
                return this.members;
            }

            public Widget getWidget() {
                return this.widget;
            }

            public int hashCode() {
                return this.id.hashCode();
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof VoiceChannel)) {
                    return false;
                }
                VoiceChannel oVChannel = (VoiceChannel)obj;
                return this == oVChannel || this.id.equals(oVChannel.getId());
            }

            public String toString() {
                return "W.VC:" + this.getName() + '(' + this.getId() + ')';
            }
        }

        public static class Member
        implements ISnowflake,
        IMentionable {
            private final boolean bot;
            private final String id;
            private final String username;
            private final String discriminator;
            private final String avatar;
            private final String nickname;
            private final OnlineStatus status;
            private final Game game;
            private final Widget widget;
            private VoiceState state;

            private Member(JSONObject json, Widget widget) {
                this.widget = widget;
                this.bot = !json.isNull("bot") && json.getBoolean("bot");
                this.id = json.getString("id");
                this.username = json.getString("username");
                this.discriminator = json.getString("discriminator");
                this.avatar = json.isNull("avatar") ? null : json.getString("avatar");
                this.nickname = json.isNull("nick") ? null : json.getString("nick");
                this.status = OnlineStatus.fromKey(json.getString("status"));
                this.game = json.isNull("game") ? null : (json.getJSONObject("game").isNull("name") || json.getJSONObject("game").getString("name").isEmpty() ? null : Game.of(json.getJSONObject("game").getString("name")));
            }

            private void setVoiceState(VoiceState voiceState) {
                this.state = voiceState;
            }

            public boolean isBot() {
                return this.bot;
            }

            public String getName() {
                return this.username;
            }

            @Override
            public String getId() {
                return this.id;
            }

            @Override
            public String getAsMention() {
                return "<@" + this.getId() + ">";
            }

            public String getDiscriminator() {
                return this.discriminator;
            }

            public String getAvatarId() {
                return this.avatar;
            }

            public String getAvatarUrl() {
                return this.getAvatarId() == null ? null : "https://cdn.discordapp.com/avatars/" + this.getId() + "/" + this.getAvatarId() + ".jpg";
            }

            public String getDefaultAvatarId() {
                return UserImpl.DefaultAvatar.values()[Integer.parseInt(this.getDiscriminator()) % UserImpl.DefaultAvatar.values().length].toString();
            }

            public String getDefaultAvatarUrl() {
                return "https://discordapp.com/assets/" + this.getDefaultAvatarId() + ".png";
            }

            public String getEffectiveAvatarUrl() {
                return this.getAvatarUrl() == null ? this.getDefaultAvatarUrl() : this.getAvatarUrl();
            }

            public String getNickname() {
                return this.nickname;
            }

            public String getEffectiveName() {
                return this.nickname == null ? this.username : this.nickname;
            }

            public OnlineStatus getOnlineStatus() {
                return this.status;
            }

            public Game getGame() {
                return this.game;
            }

            public VoiceState getVoiceState() {
                return this.state == null ? new VoiceState(this, this.widget) : this.state;
            }

            public Widget getWidget() {
                return this.widget;
            }

            public int hashCode() {
                return (this.widget.getId() + ' ' + this.id).hashCode();
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof Member)) {
                    return false;
                }
                Member oMember = (Member)obj;
                return this == oMember || this.id.equals(oMember.getId()) && this.widget.getId().equals(oMember.getWidget().getId());
            }

            public String toString() {
                return "W.M:" + this.getName() + '(' + this.getId() + ')';
            }
        }
    }

    public static enum WidgetTheme {
        LIGHT,
        DARK;

    }

    public static enum BannerType {
        SHIELD,
        BANNER1,
        BANNER2,
        BANNER3,
        BANNER4;

    }
}

