/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.requests;

import java.util.function.Consumer;
import net.dv8tion.jda.core.exceptions.ErrorResponseException;
import net.dv8tion.jda.core.exceptions.RateLimitedException;
import net.dv8tion.jda.core.requests.ErrorResponse;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.requests.Route;

public class Request<T> {
    private final RestAction<T> restAction;
    private final Object data;
    private final Consumer<T> onSuccess;
    private final Consumer<Throwable> onFailure;
    private final boolean shouldQueue;
    private boolean isCanceled = false;

    public Request(RestAction<T> restAction, Consumer<T> onSuccess, Consumer<Throwable> onFailure, boolean shouldQueue) {
        this.restAction = restAction;
        this.data = restAction.data;
        this.onSuccess = onSuccess;
        this.onFailure = onFailure;
        this.shouldQueue = shouldQueue;
    }

    public void onSuccess(T successObj) {
        try {
            this.onSuccess.accept(successObj);
        }
        catch (Throwable t) {
            RestAction.LOG.fatal("Encountered error while processing success consumer");
            RestAction.LOG.log(t);
        }
    }

    public void onFailure(Response response) {
        if (response.code == 429) {
            this.onFailure(new RateLimitedException(this.getRoute(), response.retryAfter));
        } else {
            this.onFailure(new ErrorResponseException(ErrorResponse.fromJSON(response.getObject()), response));
        }
    }

    public void onFailure(Throwable failException) {
        try {
            this.onFailure.accept(failException);
        }
        catch (Throwable t) {
            RestAction.LOG.fatal("Encountered error while processing failure consumer");
            RestAction.LOG.log(t);
        }
    }

    public RestAction<T> getRestAction() {
        return this.restAction;
    }

    public Consumer<T> getOnSuccess() {
        return this.onSuccess;
    }

    public Consumer<Throwable> getOnFailure() {
        return this.onFailure;
    }

    public Route.CompiledRoute getRoute() {
        return this.restAction.route;
    }

    public Object getData() {
        return this.data;
    }

    public boolean shouldQueue() {
        return this.shouldQueue;
    }

    public void cancel() {
        this.isCanceled = true;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }
}

