/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.managers;

import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.Permission;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.managers.RoleManagerUpdatable;
import net.dv8tion.jda.core.requests.RestAction;

public class RoleManager {
    protected final RoleManagerUpdatable updatable;

    public RoleManager(Role role) {
        this.updatable = new RoleManagerUpdatable(role);
    }

    public JDA getJDA() {
        return this.updatable.getJDA();
    }

    public Guild getGuild() {
        return this.updatable.getGuild();
    }

    public Role getRole() {
        return this.updatable.getRole();
    }

    public RestAction<Void> setName(String name) {
        return ((RoleManagerUpdatable)this.updatable.getNameField().setValue(name)).update();
    }

    public RestAction<Void> setPermissions(Long perms) {
        return this.updatable.getPermissionField().setValue(perms).update();
    }

    public RestAction<Void> setPermissions(Permission ... permissions) {
        return this.setPermissions(Arrays.asList(permissions));
    }

    public RestAction<Void> setPermissions(Collection<Permission> permissions) {
        return this.updatable.getPermissionField().setPermissions(permissions).update();
    }

    public RestAction<Void> setColor(Color color) {
        return ((RoleManagerUpdatable)this.updatable.getColorField().setValue(color)).update();
    }

    public RestAction<Void> setHoisted(Boolean hoisted) {
        return ((RoleManagerUpdatable)this.updatable.getHoistedField().setValue(hoisted)).update();
    }

    public RestAction<Void> setMentionable(Boolean mentionable) {
        return ((RoleManagerUpdatable)this.updatable.getMentionableField().setValue(mentionable)).update();
    }

    public RestAction<Void> givePermissions(Permission ... perms) {
        return this.givePermissions(Arrays.asList(perms));
    }

    public RestAction<Void> givePermissions(Collection<Permission> perms) {
        return this.updatable.getPermissionField().givePermissions(perms).update();
    }

    public RestAction<Void> revokePermissions(Permission ... perms) {
        return this.revokePermissions(Arrays.asList(perms));
    }

    public RestAction<Void> revokePermissions(Collection<Permission> perms) {
        return this.updatable.getPermissionField().revokePermissions(perms).update();
    }
}

