/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.entities.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.dv8tion.jda.client.managers.EmoteManager;
import net.dv8tion.jda.client.managers.EmoteManagerUpdatable;
import net.dv8tion.jda.core.AccountType;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.Permission;
import net.dv8tion.jda.core.entities.Emote;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.exceptions.AccountTypeException;
import net.dv8tion.jda.core.exceptions.PermissionException;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.utils.PermissionUtil;

public class EmoteImpl
implements Emote {
    private final String id;
    private final Guild guild;
    private final JDA api;
    private volatile EmoteManager manager = null;
    private volatile EmoteManagerUpdatable managerUpdatable = null;
    private Object mngLock = new Object();
    private boolean managed = false;
    private HashSet<Role> roles = null;
    private String name;

    public EmoteImpl(String id, Guild guild) {
        this.id = id;
        this.guild = guild;
        this.api = guild.getJDA();
        this.roles = new HashSet();
    }

    public EmoteImpl(String id, JDA api) {
        this.id = id;
        this.api = api;
        this.guild = null;
    }

    @Override
    public Guild getGuild() {
        return this.guild;
    }

    @Override
    public List<Role> getRoles() {
        if (this.isFake()) {
            throw new IllegalStateException("Unable to return roles because this emote is fake. (We do not know the origin Guild of this emote)");
        }
        return Collections.unmodifiableList(new LinkedList<Role>(this.roles));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isManaged() {
        return this.managed;
    }

    @Override
    public boolean isFake() {
        return this.guild == null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public JDA getJDA() {
        return this.api;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EmoteManager getManager() {
        EmoteManager m = this.manager;
        if (m == null) {
            Object object = this.mngLock;
            synchronized (object) {
                m = this.manager;
                if (m == null) {
                    m = this.manager = new EmoteManager(this);
                }
            }
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EmoteManagerUpdatable getManagerUpdatable() {
        EmoteManagerUpdatable m = this.managerUpdatable;
        if (m == null) {
            Object object = this.mngLock;
            synchronized (object) {
                m = this.managerUpdatable;
                if (m == null) {
                    m = this.managerUpdatable = new EmoteManagerUpdatable(this);
                }
            }
        }
        return m;
    }

    @Override
    public RestAction<Void> delete() {
        if (this.getJDA().getAccountType() != AccountType.CLIENT) {
            throw new AccountTypeException(AccountType.CLIENT);
        }
        if (this.isFake()) {
            throw new IllegalStateException("The emote you are trying to delete is not an actual emote we have access to (it is fake)!");
        }
        if (this.managed) {
            throw new IllegalStateException("You cannot delete a managed emote!");
        }
        if (!PermissionUtil.checkPermission(this.guild, this.guild.getSelfMember(), Permission.MANAGE_EMOTES)) {
            throw new PermissionException(Permission.MANAGE_EMOTES);
        }
        return new RestAction<Void>(this.getJDA(), Route.Emotes.DELETE_EMOTE.compile(this.getGuild().getId(), this.getId()), null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    public EmoteImpl setName(String name) {
        this.name = name;
        return this;
    }

    public EmoteImpl setManaged(boolean val) {
        this.managed = val;
        return this;
    }

    public HashSet<Role> getRoleSet() {
        return this.roles;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Emote)) {
            return false;
        }
        Emote oEmote = (Emote)obj;
        return this.getId().equals(oEmote.getId()) && this.getName().equals(oEmote.getName());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return "E:" + this.getName() + '(' + this.getId() + ')';
    }
}

