/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.entities;

import java.awt.Color;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.iblitzkriegi.vixio.org.apache.commons.lang3.StringUtils;
import net.dv8tion.jda.client.entities.Friend;
import net.dv8tion.jda.client.entities.Group;
import net.dv8tion.jda.client.entities.Relationship;
import net.dv8tion.jda.client.entities.RelationshipType;
import net.dv8tion.jda.client.entities.impl.BlockedUserImpl;
import net.dv8tion.jda.client.entities.impl.FriendImpl;
import net.dv8tion.jda.client.entities.impl.GroupImpl;
import net.dv8tion.jda.client.entities.impl.IncomingFriendRequestImpl;
import net.dv8tion.jda.client.entities.impl.JDAClientImpl;
import net.dv8tion.jda.client.entities.impl.OutgoingFriendRequestImpl;
import net.dv8tion.jda.core.AccountType;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.OnlineStatus;
import net.dv8tion.jda.core.Region;
import net.dv8tion.jda.core.entities.Channel;
import net.dv8tion.jda.core.entities.ChannelType;
import net.dv8tion.jda.core.entities.EmbedType;
import net.dv8tion.jda.core.entities.Emote;
import net.dv8tion.jda.core.entities.Game;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.Message;
import net.dv8tion.jda.core.entities.MessageChannel;
import net.dv8tion.jda.core.entities.MessageEmbed;
import net.dv8tion.jda.core.entities.MessageReaction;
import net.dv8tion.jda.core.entities.PermissionOverride;
import net.dv8tion.jda.core.entities.PrivateChannel;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.entities.SelfUser;
import net.dv8tion.jda.core.entities.TextChannel;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.entities.VoiceChannel;
import net.dv8tion.jda.core.entities.Webhook;
import net.dv8tion.jda.core.entities.impl.EmoteImpl;
import net.dv8tion.jda.core.entities.impl.GameImpl;
import net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.dv8tion.jda.core.entities.impl.GuildVoiceStateImpl;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.entities.impl.MemberImpl;
import net.dv8tion.jda.core.entities.impl.MessageEmbedImpl;
import net.dv8tion.jda.core.entities.impl.MessageImpl;
import net.dv8tion.jda.core.entities.impl.PermissionOverrideImpl;
import net.dv8tion.jda.core.entities.impl.PrivateChannelImpl;
import net.dv8tion.jda.core.entities.impl.RoleImpl;
import net.dv8tion.jda.core.entities.impl.SelfUserImpl;
import net.dv8tion.jda.core.entities.impl.TextChannelImpl;
import net.dv8tion.jda.core.entities.impl.UserImpl;
import net.dv8tion.jda.core.entities.impl.VoiceChannelImpl;
import net.dv8tion.jda.core.entities.impl.WebhookImpl;
import net.dv8tion.jda.core.exceptions.AccountTypeException;
import net.dv8tion.jda.core.handle.GuildMembersChunkHandler;
import net.dv8tion.jda.core.handle.ReadyHandler;
import net.dv8tion.jda.core.requests.GuildLock;
import net.dv8tion.jda.core.requests.WebSocketClient;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EntityBuilder {
    public static final String MISSING_CHANNEL = "MISSING_CHANNEL";
    public static final String MISSING_USER = "MISSING_USER";
    private static final HashMap<JDA, EntityBuilder> builders = new HashMap();
    private static final Pattern channelMentionPattern = Pattern.compile("<#(\\d+)>");
    protected final JDAImpl api;
    protected final HashMap<String, JSONObject> cachedGuildJsons = new HashMap();
    protected final HashMap<String, Consumer<Guild>> cachedGuildCallbacks = new HashMap();

    public static EntityBuilder get(JDA api) {
        EntityBuilder builder = builders.get(api);
        if (builder == null) {
            builder = new EntityBuilder(api);
            builders.put(api, builder);
        }
        return builder;
    }

    private EntityBuilder(JDA api) {
        this.api = (JDAImpl)api;
    }

    public SelfUser createSelfUser(JSONObject self) {
        SelfUserImpl selfUser = (SelfUserImpl)this.api.getSelfUser();
        if (selfUser == null) {
            selfUser = new SelfUserImpl(self.getString("id"), this.api);
            this.api.setSelfUser(selfUser);
        }
        if (!this.api.getUserMap().containsKey(selfUser.getId())) {
            this.api.getUserMap().put(selfUser.getId(), selfUser);
        }
        return (SelfUser)((Object)selfUser.setVerified(self.getBoolean("verified")).setMfaEnabled(self.getBoolean("mfa_enabled")).setEmail(!self.isNull("email") ? self.getString("email") : null).setName(self.getString("username")).setDiscriminator(self.getString("discriminator")).setAvatarId(self.isNull("avatar") ? null : self.getString("avatar")).setBot(self.has("bot") && self.getBoolean("bot")));
    }

    public void createGuildFirstPass(JSONObject guild, Consumer<Guild> secondPassCallback) {
        JSONArray channels;
        Member owner;
        int i;
        String id = guild.getString("id");
        GuildImpl guildObj = (GuildImpl)this.api.getGuildMap().get(id);
        if (guildObj == null) {
            guildObj = new GuildImpl(this.api, id);
            this.api.getGuildMap().put(id, guildObj);
        }
        if (guild.has("unavailable") && guild.getBoolean("unavailable")) {
            guildObj.setAvailable(false);
            if (secondPassCallback != null) {
                secondPassCallback.accept(guildObj);
            }
            GuildLock.get(this.api).lock(id);
            return;
        }
        guildObj.setAvailable(true).setIconId(guild.isNull("icon") ? null : guild.getString("icon")).setSplashId(guild.isNull("splash") ? null : guild.getString("splash")).setRegion(Region.fromKey(guild.getString("region"))).setName(guild.getString("name")).setAfkTimeout(Guild.Timeout.fromKey(guild.getInt("afk_timeout"))).setVerificationLevel(Guild.VerificationLevel.fromKey(guild.getInt("verification_level"))).setDefaultNotificationLevel(Guild.NotificationLevel.fromKey(guild.getInt("default_message_notifications"))).setRequiredMFALevel(Guild.MFALevel.fromKey(guild.getInt("mfa_level")));
        JSONArray roles = guild.getJSONArray("roles");
        for (int i2 = 0; i2 < roles.length(); ++i2) {
            Role role = this.createRole(roles.getJSONObject(i2), guildObj.getId());
            guildObj.getRolesMap().put(role.getId(), role);
            if (!role.getId().equals(guildObj.getId())) continue;
            guildObj.setPublicRole(role);
        }
        if (!guild.isNull("emojis")) {
            JSONArray array = guild.getJSONArray("emojis");
            HashMap<String, Emote> emoteMap = guildObj.getEmoteMap();
            for (i = 0; i < array.length(); ++i) {
                JSONObject object = array.getJSONObject(i);
                JSONArray emoteRoles = object.getJSONArray("roles");
                String emoteId = object.getString("id");
                EmoteImpl emoteObj = new EmoteImpl(emoteId, guildObj);
                HashSet<Role> roleSet = emoteObj.getRoleSet();
                for (int j = 0; j < emoteRoles.length(); ++j) {
                    roleSet.add(guildObj.getRoleById(emoteRoles.getString(j)));
                }
                emoteMap.put(emoteId, emoteObj.setName(object.getString("name")).setManaged(object.getBoolean("managed")));
            }
        }
        if (guild.has("members")) {
            JSONArray members = guild.getJSONArray("members");
            this.createGuildMemberPass(guildObj, members);
        }
        if ((owner = guildObj.getMemberById(guild.getString("owner_id"))) != null) {
            guildObj.setOwner(owner);
        }
        if (guild.has("presences")) {
            JSONArray presences = guild.getJSONArray("presences");
            for (i = 0; i < presences.length(); ++i) {
                JSONObject presence = presences.getJSONObject(i);
                String userId = presence.getJSONObject("user").getString("id");
                MemberImpl member = (MemberImpl)guildObj.getMembersMap().get(userId);
                if (member == null) {
                    WebSocketClient.LOG.debug("Received a ghost presence in GuildFirstPass! Guild: " + guildObj + " UserId: " + userId);
                    continue;
                }
                this.createPresence(member, presence);
            }
        }
        if (guild.has("channels")) {
            channels = guild.getJSONArray("channels");
            for (i = 0; i < channels.length(); ++i) {
                Comparable<TextChannel> newChannel;
                JSONObject channel = channels.getJSONObject(i);
                ChannelType type = ChannelType.fromId(channel.getInt("type"));
                if (type == ChannelType.TEXT) {
                    newChannel = this.createTextChannel(channel, guildObj.getId());
                    if (!newChannel.getId().equals(guildObj.getId())) continue;
                    guildObj.setPublicChannel((TextChannel)newChannel);
                    continue;
                }
                if (type == ChannelType.VOICE) {
                    newChannel = this.createVoiceChannel(channel, guildObj.getId());
                    if (guild.isNull("afk_channel_id") || !newChannel.getId().equals(guild.getString("afk_channel_id"))) continue;
                    guildObj.setAfkChannel((VoiceChannel)newChannel);
                    continue;
                }
                WebSocketClient.LOG.fatal("Received a channel for a guild that isn't a text or voice channel. JSON: " + channel);
            }
        }
        if (guild.getJSONArray("members").length() != guild.getInt("member_count")) {
            this.cachedGuildJsons.put(id, guild);
            this.cachedGuildCallbacks.put(id, secondPassCallback);
            GuildMembersChunkHandler handler = (GuildMembersChunkHandler)this.api.getClient().getHandler("GUILD_MEMBERS_CHUNK");
            handler.setExpectedGuildMembers(id, guild.getInt("member_count"));
            if (this.api.getClient().isReady()) {
                if (this.api.getAccountType() == AccountType.CLIENT) {
                    JSONObject obj = new JSONObject().put("op", 12).put("guild_id", guildObj.getId());
                    this.api.getClient().send(obj.toString());
                }
                JSONObject obj = new JSONObject().put("op", 8).put("d", new JSONObject().put("guild_id", id).put("query", "").put("limit", 0));
                this.api.getClient().send(obj.toString());
            } else {
                ReadyHandler readyHandler = (ReadyHandler)this.api.getClient().getHandler("READY");
                readyHandler.acknowledgeGuild(guildObj, true, true, this.api.getAccountType() == AccountType.CLIENT);
            }
            GuildLock.get(this.api).lock(id);
            return;
        }
        channels = guild.getJSONArray("channels");
        this.createGuildChannelPass(guildObj, channels);
        JSONArray voiceStates = guild.getJSONArray("voice_states");
        this.createGuildVoiceStatePass(guildObj, voiceStates);
        GuildLock.get(this.api).unlock(guildObj.getId());
        if (secondPassCallback != null) {
            secondPassCallback.accept(guildObj);
        }
    }

    public void createGuildSecondPass(String guildId, List<JSONArray> memberChunks) {
        JSONObject guildJson = this.cachedGuildJsons.remove(guildId);
        Consumer<Guild> secondPassCallback = this.cachedGuildCallbacks.remove(guildId);
        GuildImpl guildObj = (GuildImpl)this.api.getGuildMap().get(guildId);
        if (guildObj == null) {
            throw new IllegalStateException("Attempted to preform a second pass on an unknown Guild. Guild not in JDA mapping. GuildId: " + guildId);
        }
        if (guildJson == null) {
            throw new IllegalStateException("Attempted to preform a second pass on an unknown Guild. No cached Guild for second pass. GuildId: " + guildId);
        }
        if (secondPassCallback == null) {
            throw new IllegalArgumentException("No callback provided for the second pass on the Guild!");
        }
        for (JSONArray chunk : memberChunks) {
            this.createGuildMemberPass(guildObj, chunk);
        }
        Member owner = guildObj.getMemberById(guildJson.getString("owner_id"));
        if (owner != null) {
            guildObj.setOwner(owner);
        }
        if (guildObj.getOwner() == null) {
            WebSocketClient.LOG.fatal("Never set the Owner of the Guild: " + guildObj.getId() + " because we don't have the owner User object! How?!");
        }
        JSONArray channels = guildJson.getJSONArray("channels");
        this.createGuildChannelPass(guildObj, channels);
        JSONArray voiceStates = guildJson.getJSONArray("voice_states");
        this.createGuildVoiceStatePass(guildObj, voiceStates);
        secondPassCallback.accept(guildObj);
        GuildLock.get(this.api).unlock(guildId);
    }

    public void handleGuildSync(GuildImpl guild, JSONArray members, JSONArray presences) {
        int i;
        for (i = 0; i < members.length(); ++i) {
            JSONObject memberJson = members.getJSONObject(i);
            Member member = this.createMember(guild, memberJson);
        }
        for (i = 0; i < presences.length(); ++i) {
            JSONObject presenceJson = presences.getJSONObject(i);
            String userId = presenceJson.getJSONObject("user").getString("id");
            MemberImpl member = (MemberImpl)guild.getMembersMap().get(userId);
            if (member == null) {
                WebSocketClient.LOG.fatal("Received a Presence for a non-existent Member when dealing with GuildSync!");
                continue;
            }
            this.createPresence(member, presenceJson);
        }
    }

    private void createGuildMemberPass(GuildImpl guildObj, JSONArray members) {
        for (int i = 0; i < members.length(); ++i) {
            JSONObject memberJson = members.getJSONObject(i);
            Member member = this.createMember(guildObj, memberJson);
        }
    }

    private void createGuildChannelPass(GuildImpl guildObj, JSONArray channels) {
        for (int i = 0; i < channels.length(); ++i) {
            JSONObject channel = channels.getJSONObject(i);
            ChannelType type = ChannelType.fromId(channel.getInt("type"));
            Comparable<TextChannel> channelObj = null;
            if (type == ChannelType.TEXT) {
                channelObj = this.api.getTextChannelById(channel.getString("id"));
            } else if (type == ChannelType.VOICE) {
                channelObj = this.api.getVoiceChannelById(channel.getString("id"));
            } else {
                WebSocketClient.LOG.fatal("Received a channel for a guild that isn't a text or voice channel (ChannelPass). JSON: " + channel);
            }
            if (channelObj != null) {
                JSONArray permissionOverwrites = channel.getJSONArray("permission_overwrites");
                for (int j = 0; j < permissionOverwrites.length(); ++j) {
                    try {
                        this.createPermissionOverride(permissionOverwrites.getJSONObject(j), (Channel)((Object)channelObj));
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        WebSocketClient.LOG.warn(e.getMessage() + ". Ignoring PermissionOverride.");
                    }
                }
                continue;
            }
            throw new RuntimeException("Got permission_override for unknown channel with id: " + channel.getString("id"));
        }
    }

    public void createGuildVoiceStatePass(GuildImpl guildObj, JSONArray voiceStates) {
        for (int i = 0; i < voiceStates.length(); ++i) {
            JSONObject voiceStateJson = voiceStates.getJSONObject(i);
            Member member = guildObj.getMembersMap().get(voiceStateJson.getString("user_id"));
            if (member == null) {
                WebSocketClient.LOG.fatal("Received a VoiceState for a unknown Member! GuildId: " + guildObj.getId() + " MemberId: " + voiceStateJson.getString("user_id"));
                continue;
            }
            VoiceChannelImpl voiceChannel = (VoiceChannelImpl)guildObj.getVoiceChannelMap().get(voiceStateJson.getString("channel_id"));
            voiceChannel.getConnectedMembersMap().put(member.getUser().getId(), member);
            GuildVoiceStateImpl voiceState = (GuildVoiceStateImpl)member.getVoiceState();
            voiceState.setSelfMuted(voiceStateJson.getBoolean("self_mute")).setSelfDeafened(voiceStateJson.getBoolean("self_deaf")).setGuildMuted(voiceStateJson.getBoolean("mute")).setGuildDeafened(voiceStateJson.getBoolean("deaf")).setSuppressed(voiceStateJson.getBoolean("suppress")).setSessionId(voiceStateJson.getString("session_id")).setConnectedChannel(voiceChannel);
        }
    }

    public User createFakeUser(JSONObject user, boolean modifyCache) {
        return this.createUser(user, true, modifyCache);
    }

    public User createUser(JSONObject user) {
        return this.createUser(user, false, true);
    }

    private User createUser(JSONObject user, boolean fake, boolean modifyCache) {
        String id = user.getString("id");
        UserImpl userObj = (UserImpl)this.api.getUserMap().get(id);
        if (userObj == null) {
            userObj = (UserImpl)this.api.getFakeUserMap().get(id);
            if (userObj != null) {
                if (!fake && modifyCache) {
                    this.api.getFakeUserMap().remove(id);
                    userObj.setFake(false);
                    this.api.getUserMap().put(userObj.getId(), userObj);
                    if (userObj.hasPrivateChannel()) {
                        PrivateChannelImpl priv = (PrivateChannelImpl)userObj.getPrivateChannel();
                        priv.setFake(false);
                        this.api.getFakePrivateChannelMap().remove(priv.getId());
                        this.api.getPrivateChannelMap().put(priv.getId(), priv);
                    }
                }
            } else {
                userObj = new UserImpl(id, this.api).setFake(fake);
                if (modifyCache) {
                    if (fake) {
                        this.api.getFakeUserMap().put(id, userObj);
                    } else {
                        this.api.getUserMap().put(id, userObj);
                    }
                }
            }
        }
        return userObj.setName(user.getString("username")).setDiscriminator(user.get("discriminator").toString()).setAvatarId(user.isNull("avatar") ? null : user.getString("avatar")).setBot(user.has("bot") && user.getBoolean("bot"));
    }

    public Member createMember(GuildImpl guild, JSONObject memberJson) {
        User user = this.createUser(memberJson.getJSONObject("user"));
        MemberImpl member = (MemberImpl)guild.getMember(user);
        if (member == null) {
            member = new MemberImpl(guild, user);
            guild.getMembersMap().put(user.getId(), member);
        }
        ((GuildVoiceStateImpl)member.getVoiceState()).setGuildMuted(memberJson.getBoolean("mute")).setGuildDeafened(memberJson.getBoolean("deaf"));
        member.setJoinDate(OffsetDateTime.parse(memberJson.getString("joined_at"))).setNickname(memberJson.has("nick") && !memberJson.isNull("nick") ? memberJson.getString("nick") : null);
        JSONArray rolesJson = memberJson.getJSONArray("roles");
        for (int k = 0; k < rolesJson.length(); ++k) {
            String roleId = rolesJson.getString(k);
            Role r = guild.getRolesMap().get(roleId);
            if (r == null) {
                WebSocketClient.LOG.fatal("Received a Member with an unknown Role. MemberId: " + member.getUser().getId() + " GuildId: " + guild.getId() + " roleId: " + roleId);
                continue;
            }
            member.getRoleSet().add(r);
        }
        return member;
    }

    public void createPresence(Object memberOrFriend, JSONObject presenceJson) {
        if (memberOrFriend == null) {
            throw new NullPointerException("Provided memberOrFriend was null!");
        }
        JSONObject gameJson = presenceJson.isNull("game") ? null : presenceJson.getJSONObject("game");
        OnlineStatus onlineStatus = OnlineStatus.fromKey(presenceJson.getString("status"));
        GameImpl game = null;
        if (gameJson != null && !gameJson.isNull("name")) {
            Game.GameType gameType;
            String gameName = gameJson.get("name").toString();
            String url = gameJson.isNull("url") ? null : gameJson.get("url").toString();
            try {
                gameType = gameJson.isNull("type") ? Game.GameType.DEFAULT : Game.GameType.fromKey(Integer.parseInt(gameJson.get("type").toString()));
            }
            catch (NumberFormatException e) {
                gameType = Game.GameType.DEFAULT;
            }
            game = new GameImpl(gameName, url, gameType);
        }
        if (memberOrFriend instanceof Member) {
            MemberImpl member = (MemberImpl)memberOrFriend;
            member.setOnlineStatus(onlineStatus);
            member.setGame(game);
        } else if (memberOrFriend instanceof Friend) {
            FriendImpl friend = (FriendImpl)memberOrFriend;
            friend.setOnlineStatus(onlineStatus);
            friend.setGame(game);
            OffsetDateTime lastModified = OffsetDateTime.ofInstant(Instant.ofEpochMilli(presenceJson.getLong("last_modified")), TimeZone.getTimeZone("GMT").toZoneId());
            friend.setOnlineStatusModifiedTime(lastModified);
        } else {
            throw new IllegalArgumentException("An object was provided to EntityBuilder#createPresence that wasn't a Member or Friend. JSON: " + presenceJson);
        }
    }

    public TextChannel createTextChannel(JSONObject json, String guildId) {
        String id = json.getString("id");
        TextChannelImpl channel = (TextChannelImpl)this.api.getTextChannelMap().get(id);
        if (channel == null) {
            GuildImpl guild = (GuildImpl)this.api.getGuildMap().get(guildId);
            channel = new TextChannelImpl(id, guild);
            guild.getTextChannelsMap().put(id, channel);
            this.api.getTextChannelMap().put(id, channel);
        }
        return channel.setName(json.getString("name")).setTopic(json.isNull("topic") ? "" : json.getString("topic")).setRawPosition(json.getInt("position"));
    }

    public VoiceChannel createVoiceChannel(JSONObject json, String guildId) {
        String id = json.getString("id");
        VoiceChannelImpl channel = (VoiceChannelImpl)this.api.getVoiceChannelMap().get(id);
        if (channel == null) {
            GuildImpl guild = (GuildImpl)this.api.getGuildMap().get(guildId);
            channel = new VoiceChannelImpl(id, guild);
            guild.getVoiceChannelMap().put(id, channel);
            this.api.getVoiceChannelMap().put(id, channel);
        }
        return channel.setName(json.getString("name")).setRawPosition(json.getInt("position")).setUserLimit(json.getInt("user_limit")).setBitrate(json.getInt("bitrate"));
    }

    public PrivateChannel createPrivateChannel(JSONObject privatechat) {
        JSONObject recipient = privatechat.has("recipients") ? privatechat.getJSONArray("recipients").getJSONObject(0) : privatechat.getJSONObject("recipient");
        UserImpl user = (UserImpl)this.api.getUserMap().get(recipient.getString("id"));
        if (user == null) {
            user = (UserImpl)this.createFakeUser(recipient, true);
        }
        PrivateChannelImpl priv = new PrivateChannelImpl(privatechat.getString("id"), user);
        user.setPrivateChannel(priv);
        if (user.isFake()) {
            priv.setFake(true);
            this.api.getFakePrivateChannelMap().put(priv.getId(), priv);
        } else {
            this.api.getPrivateChannelMap().put(priv.getId(), priv);
        }
        return priv;
    }

    public Role createRole(JSONObject roleJson, String guildId) {
        String id = roleJson.getString("id");
        GuildImpl guild = (GuildImpl)this.api.getGuildMap().get(guildId);
        RoleImpl role = (RoleImpl)guild.getRolesMap().get(id);
        if (role == null) {
            role = new RoleImpl(id, guild);
            guild.getRolesMap().put(id, role);
        }
        return role.setName(roleJson.getString("name")).setRawPosition(roleJson.getInt("position")).setRawPermissions(roleJson.getLong("permissions")).setManaged(roleJson.getBoolean("managed")).setHoisted(roleJson.getBoolean("hoist")).setColor(roleJson.getInt("color") != 0 ? new Color(roleJson.getInt("color")) : null).setMentionable(roleJson.has("mentionable") && roleJson.getBoolean("mentionable"));
    }

    public Message createMessage(JSONObject jsonObject) {
        return this.createMessage(jsonObject, false);
    }

    public Message createMessage(JSONObject jsonObject, boolean exceptionOnMissingUser) {
        String id = jsonObject.getString("id");
        String content = !jsonObject.isNull("content") ? jsonObject.getString("content") : "";
        String channelId = jsonObject.getString("channel_id");
        JSONObject author = jsonObject.getJSONObject("author");
        String authorId = author.getString("id");
        boolean fromWebhook = jsonObject.has("webhook_id");
        MessageChannel chan = this.api.getTextChannelById(channelId);
        if (chan == null) {
            chan = this.api.getPrivateChannelById(channelId);
        }
        if (chan == null) {
            chan = this.api.getFakePrivateChannelMap().get(channelId);
        }
        if (chan == null && this.api.getAccountType() == AccountType.CLIENT) {
            chan = this.api.asClient().getGroupById(channelId);
        }
        if (chan == null) {
            throw new IllegalArgumentException(MISSING_CHANNEL);
        }
        MessageImpl message = new MessageImpl(id, chan, fromWebhook).setContent(content).setTime(!jsonObject.isNull("timestamp") ? OffsetDateTime.parse(jsonObject.getString("timestamp")) : OffsetDateTime.now()).setMentionsEveryone(!jsonObject.isNull("mention_everyone") && jsonObject.getBoolean("mention_everyone")).setTTS(!jsonObject.isNull("tts") && jsonObject.getBoolean("tts")).setPinned(!jsonObject.isNull("pinned") && jsonObject.getBoolean("pinned"));
        if (chan instanceof PrivateChannel) {
            if (StringUtils.equals(authorId, this.api.getSelfUser().getId())) {
                message.setAuthor(this.api.getSelfUser());
            } else {
                message.setAuthor(((PrivateChannel)chan).getUser());
            }
        } else if (chan instanceof Group) {
            UserImpl user = (UserImpl)this.api.getUserMap().get(authorId);
            if (user == null) {
                user = (UserImpl)this.api.getFakeUserMap().get(authorId);
            }
            if (user == null && fromWebhook) {
                user = (UserImpl)this.createFakeUser(author, false);
            }
            if (user == null) {
                if (exceptionOnMissingUser) {
                    throw new IllegalArgumentException(MISSING_USER);
                }
                user = (UserImpl)this.createFakeUser(author, false);
            }
            message.setAuthor(user);
            if (user.isFake() && !fromWebhook) {
                user.setName(author.getString("username")).setDiscriminator(author.get("discriminator").toString()).setAvatarId(author.isNull("avatar") ? null : author.getString("avatar")).setBot(author.has("bot") && author.getBoolean("bot"));
            }
        } else {
            User user;
            GuildImpl guild = (GuildImpl)chan.getGuild();
            Member member = guild.getMembersMap().get(authorId);
            User user2 = user = member != null ? member.getUser() : null;
            if (user != null) {
                message.setAuthor(user);
            } else if (fromWebhook || !exceptionOnMissingUser) {
                message.setAuthor(this.createFakeUser(author, false));
            } else {
                throw new IllegalArgumentException(MISSING_USER);
            }
        }
        LinkedList<Message.Attachment> attachments = new LinkedList<Message.Attachment>();
        if (!jsonObject.isNull("attachments")) {
            JSONArray jsonAttachments = jsonObject.getJSONArray("attachments");
            for (int i = 0; i < jsonAttachments.length(); ++i) {
                JSONObject jsonAttachment = jsonAttachments.getJSONObject(i);
                attachments.add(new Message.Attachment(jsonAttachment.getString("id"), jsonAttachment.getString("url"), jsonAttachment.getString("proxy_url"), jsonAttachment.getString("filename"), jsonAttachment.getInt("size"), jsonAttachment.has("height") ? jsonAttachment.getInt("height") : 0, jsonAttachment.has("width") ? jsonAttachment.getInt("width") : 0, this.api));
            }
        }
        message.setAttachments(attachments);
        LinkedList<MessageEmbed> embeds = new LinkedList<MessageEmbed>();
        JSONArray jsonEmbeds = jsonObject.getJSONArray("embeds");
        for (int i = 0; i < jsonEmbeds.length(); ++i) {
            embeds.add(this.createMessageEmbed(jsonEmbeds.getJSONObject(i)));
        }
        message.setEmbeds(embeds);
        if (!jsonObject.isNull("edited_timestamp")) {
            message.setEditedTime(OffsetDateTime.parse(jsonObject.getString("edited_timestamp")));
        }
        if (jsonObject.has("reactions")) {
            JSONArray reactions = jsonObject.getJSONArray("reactions");
            LinkedList<MessageReaction> list = new LinkedList<MessageReaction>();
            for (int i = 0; i < reactions.length(); ++i) {
                JSONObject obj = reactions.getJSONObject(i);
                JSONObject emoji = obj.getJSONObject("emoji");
                String emojiId = emoji.isNull("id") ? null : emoji.getString("id");
                String emojiName = emoji.getString("name");
                boolean self = obj.has("self") && obj.getBoolean("self");
                int count = obj.getInt("count");
                Emote emote = null;
                if (emojiId != null && (emote = this.api.getEmoteById(emojiId)) == null) {
                    emote = new EmoteImpl(emojiId, this.api).setName(emojiName);
                }
                MessageReaction.ReactionEmote reactionEmote = emote == null ? new MessageReaction.ReactionEmote(emojiName, null, this.api) : new MessageReaction.ReactionEmote(emote);
                list.add(new MessageReaction(chan, reactionEmote, message.getId(), self, count));
            }
            message.setReactions(list);
        }
        if (message.isFromType(ChannelType.TEXT)) {
            int index;
            TextChannel textChannel = message.getTextChannel();
            TreeMap<Integer, User> mentionedUsers = new TreeMap<Integer, User>();
            if (!jsonObject.isNull("mentions")) {
                JSONArray mentions = jsonObject.getJSONArray("mentions");
                for (int i = 0; i < mentions.length(); ++i) {
                    JSONObject mention = mentions.getJSONObject(i);
                    User u = this.api.getUserMap().get(mention.getString("id"));
                    if (u == null) continue;
                    String mentionId = mention.getString("id");
                    index = content.indexOf("<@" + mentionId + ">");
                    if (index < 0) {
                        index = content.indexOf("<@!" + mentionId + ">");
                    }
                    mentionedUsers.put(index, u);
                }
            }
            message.setMentionedUsers(new LinkedList<User>(mentionedUsers.values()));
            TreeMap<Integer, Role> mentionedRoles = new TreeMap<Integer, Role>();
            if (!jsonObject.isNull("mention_roles")) {
                JSONArray roleMentions = jsonObject.getJSONArray("mention_roles");
                for (int i = 0; i < roleMentions.length(); ++i) {
                    String roleId = roleMentions.getString(i);
                    Role r = textChannel.getGuild().getRoleById(roleId);
                    if (r == null) continue;
                    index = content.indexOf("<@&" + roleId + ">");
                    mentionedRoles.put(index, r);
                }
            }
            message.setMentionedRoles(new LinkedList<Role>(mentionedRoles.values()));
            LinkedList<TextChannel> mentionedChannels = new LinkedList<TextChannel>();
            HashMap<String, TextChannel> chanMap = ((GuildImpl)textChannel.getGuild()).getTextChannelsMap();
            Matcher matcher = channelMentionPattern.matcher(content);
            while (matcher.find()) {
                TextChannel channel = (TextChannel)chanMap.get(matcher.group(1));
                if (channel == null || mentionedChannels.contains(channel)) continue;
                mentionedChannels.add(channel);
            }
            message.setMentionedChannels(mentionedChannels);
        }
        return message;
    }

    public MessageEmbed createMessageEmbed(JSONObject messageEmbed) {
        if (messageEmbed.isNull("type")) {
            throw new JSONException("Encountered embed object with missing/null type field for Json: " + messageEmbed);
        }
        EmbedType type = EmbedType.fromKey(messageEmbed.getString("type"));
        MessageEmbedImpl embed = new MessageEmbedImpl().setType(type).setUrl(messageEmbed.isNull("url") ? null : messageEmbed.getString("url")).setTitle(messageEmbed.isNull("title") ? null : messageEmbed.getString("title")).setDescription(messageEmbed.isNull("description") ? null : messageEmbed.getString("description")).setColor(messageEmbed.isNull("color") || messageEmbed.getInt("color") == 0 ? null : new Color(messageEmbed.getInt("color"))).setTimestamp(messageEmbed.isNull("timestamp") ? null : OffsetDateTime.parse(messageEmbed.getString("timestamp")));
        if (messageEmbed.has("thumbnail")) {
            JSONObject thumbnailJson = messageEmbed.getJSONObject("thumbnail");
            embed.setThumbnail(new MessageEmbed.Thumbnail(thumbnailJson.getString("url"), thumbnailJson.getString("proxy_url"), thumbnailJson.getInt("width"), thumbnailJson.getInt("height")));
        } else {
            embed.setThumbnail(null);
        }
        if (messageEmbed.has("provider")) {
            JSONObject providerJson = messageEmbed.getJSONObject("provider");
            embed.setSiteProvider(new MessageEmbed.Provider(providerJson.isNull("name") ? null : providerJson.getString("name"), providerJson.isNull("url") ? null : providerJson.getString("url")));
        } else {
            embed.setSiteProvider(null);
        }
        if (messageEmbed.has("author")) {
            JSONObject authorJson = messageEmbed.getJSONObject("author");
            embed.setAuthor(new MessageEmbed.AuthorInfo(authorJson.isNull("name") ? null : authorJson.getString("name"), authorJson.isNull("url") ? null : authorJson.getString("url"), authorJson.isNull("icon_url") ? null : authorJson.getString("icon_url"), authorJson.isNull("proxy_icon_url") ? null : authorJson.getString("proxy_icon_url")));
        } else {
            embed.setAuthor(null);
        }
        if (messageEmbed.has("image")) {
            JSONObject imageJson = messageEmbed.getJSONObject("image");
            embed.setImage(new MessageEmbed.ImageInfo(imageJson.isNull("url") ? null : imageJson.getString("url"), imageJson.isNull("proxy_url") ? null : imageJson.getString("proxy_url"), imageJson.isNull("width") ? -1 : imageJson.getInt("width"), imageJson.isNull("height") ? -1 : imageJson.getInt("height")));
        } else {
            embed.setImage(null);
        }
        if (messageEmbed.has("footer")) {
            JSONObject footerJson = messageEmbed.getJSONObject("footer");
            embed.setFooter(new MessageEmbed.Footer(footerJson.isNull("text") ? null : footerJson.getString("text"), footerJson.isNull("icon_url") ? null : footerJson.getString("icon_url"), footerJson.isNull("proxy_icon_url") ? null : footerJson.getString("proxy_icon_url")));
        } else {
            embed.setFooter(null);
        }
        if (messageEmbed.has("fields")) {
            JSONArray fieldsJson = messageEmbed.getJSONArray("fields");
            LinkedList<MessageEmbed.Field> fields = new LinkedList<MessageEmbed.Field>();
            for (int index = 0; index < fieldsJson.length(); ++index) {
                JSONObject fieldJson = fieldsJson.getJSONObject(index);
                fields.add(new MessageEmbed.Field(fieldJson.isNull("name") ? null : fieldJson.getString("name"), fieldJson.isNull("value") ? null : fieldJson.getString("value"), !fieldJson.isNull("inline") && fieldJson.getBoolean("inline")));
            }
            embed.setFields(fields);
        } else {
            embed.setFields(Collections.emptyList());
        }
        if (messageEmbed.has("video")) {
            JSONObject videoJson = messageEmbed.getJSONObject("video");
            embed.setVideoInfo(new MessageEmbed.VideoInfo(videoJson.getString("url"), videoJson.isNull("width") ? -1 : videoJson.getInt("width"), videoJson.isNull("height") ? -1 : videoJson.getInt("height")));
        }
        return embed;
    }

    public PermissionOverride createPermissionOverride(JSONObject override, Channel chan) {
        PermissionOverrideImpl permOverride = null;
        String id = override.getString("id");
        long allow = override.getLong("allow");
        long deny = override.getLong("deny");
        switch (override.getString("type")) {
            case "member": {
                Member member = chan.getGuild().getMemberById(id);
                if (member == null) {
                    throw new IllegalArgumentException("Attempted to create a PermissionOverride for a non-existent user. Guild: " + chan.getGuild() + ", Channel: " + chan + ", JSON: " + override);
                }
                permOverride = (PermissionOverrideImpl)chan.getPermissionOverride(member);
                if (permOverride != null) break;
                permOverride = new PermissionOverrideImpl(chan, member, null);
                if (chan instanceof TextChannel) {
                    ((TextChannelImpl)chan).getMemberOverrideMap().put(member, permOverride);
                    break;
                }
                ((VoiceChannelImpl)chan).getMemberOverrideMap().put(member, permOverride);
                break;
            }
            case "role": {
                Role role = ((GuildImpl)chan.getGuild()).getRolesMap().get(id);
                if (role == null) {
                    throw new IllegalArgumentException("Attempted to create a PermissionOverride for a non-existent role! JSON: " + override);
                }
                permOverride = (PermissionOverrideImpl)chan.getPermissionOverride(role);
                if (permOverride != null) break;
                permOverride = new PermissionOverrideImpl(chan, null, role);
                if (chan instanceof TextChannel) {
                    ((TextChannelImpl)chan).getRoleOverrideMap().put(role, permOverride);
                    break;
                }
                ((VoiceChannelImpl)chan).getRoleOverrideMap().put(role, permOverride);
                break;
            }
            default: {
                throw new IllegalArgumentException("Provided with an unknown PermissionOverride type! JSON: " + override);
            }
        }
        return permOverride.setAllow(allow).setDeny(deny);
    }

    public Webhook createWebhook(JSONObject object) {
        String id = object.getString("id");
        String token = !object.isNull("token") ? object.getString("token") : null;
        String guildId = object.getString("guild_id");
        String channelId = object.getString("channel_id");
        TextChannel channel = this.api.getTextChannelById(channelId);
        if (channel == null) {
            throw new NullPointerException(String.format("Tried to create Webhook for an un-cached TextChannel! WebhookId: %s ChannelId: %s GuildId: %s", id, channelId, guildId));
        }
        Object name = !object.isNull("name") ? object.get("name") : JSONObject.NULL;
        Object avatar = !object.isNull("avatar") ? object.get("avatar") : JSONObject.NULL;
        JSONObject fakeUser = new JSONObject().put("username", name).put("discriminator", "0000").put("id", id).put("avatar", avatar);
        User defaultUser = this.createFakeUser(fakeUser, false);
        JSONObject ownerJson = object.getJSONObject("user");
        String userId = ownerJson.getString("id");
        User owner = this.api.getUserById(userId);
        if (owner == null) {
            ownerJson.put("id", userId);
            owner = this.createFakeUser(ownerJson, false);
        }
        return new WebhookImpl(channel, id).setToken(token).setOwner(channel.getGuild().getMember(owner)).setUser(defaultUser);
    }

    public Relationship createRelationship(JSONObject relationshipJson) {
        if (this.api.getAccountType() != AccountType.CLIENT) {
            throw new AccountTypeException(AccountType.CLIENT, "Attempted to create a Relationship but the logged in account is not a CLIENT!");
        }
        RelationshipType type = RelationshipType.fromKey(relationshipJson.getInt("type"));
        User user = type == RelationshipType.FRIEND ? this.createUser(relationshipJson.getJSONObject("user")) : this.createFakeUser(relationshipJson.getJSONObject("user"), true);
        Relationship relationship = this.api.asClient().getRelationshipById(user.getId(), type);
        if (relationship == null) {
            switch (type) {
                case FRIEND: {
                    relationship = new FriendImpl(user);
                    break;
                }
                case BLOCKED: {
                    relationship = new BlockedUserImpl(user);
                    break;
                }
                case INCOMING_FRIEND_REQUEST: {
                    relationship = new IncomingFriendRequestImpl(user);
                    break;
                }
                case OUTGOING_FRIEND_REQUEST: {
                    relationship = new OutgoingFriendRequestImpl(user);
                    break;
                }
                default: {
                    return null;
                }
            }
            ((JDAClientImpl)this.api.asClient()).getRelationshipMap().put(user.getId(), relationship);
        }
        return relationship;
    }

    public Group createGroup(JSONObject groupJson) {
        if (this.api.getAccountType() != AccountType.CLIENT) {
            throw new AccountTypeException(AccountType.CLIENT, "Attempted to create a Group but the logged in account is not a CLIENT!");
        }
        String groupId = groupJson.getString("id");
        JSONArray recipients = groupJson.getJSONArray("recipients");
        String ownerId = groupJson.getString("owner_id");
        String name = !groupJson.isNull("name") ? groupJson.getString("name") : null;
        String iconId = !groupJson.isNull("icon") ? groupJson.getString("icon") : null;
        GroupImpl group = (GroupImpl)this.api.asClient().getGroupById(groupId);
        if (group == null) {
            group = new GroupImpl(groupId, this.api);
            ((JDAClientImpl)this.api.asClient()).getGroupMap().put(groupId, group);
        }
        HashMap<String, User> groupUsers = group.getUserMap();
        groupUsers.put(this.api.getSelfUser().getId(), this.api.getSelfUser());
        for (int i = 0; i < recipients.length(); ++i) {
            JSONObject groupUser = recipients.getJSONObject(i);
            groupUsers.put(groupUser.getString("id"), this.createFakeUser(groupUser, true));
        }
        User owner = this.api.getUserMap().get(ownerId);
        if (owner == null) {
            owner = this.api.getFakeUserMap().get(ownerId);
        }
        if (owner == null) {
            throw new IllegalArgumentException("Attempted to build a Group, but could not find user by provided owner id.This should not be possible because the owner should be IN the group!");
        }
        return group.setOwner(owner).setName(name).setIconId(iconId);
    }

    public void clearCache() {
        this.cachedGuildJsons.clear();
        this.cachedGuildCallbacks.clear();
    }
}

