/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.tools.io;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.commons.io.input.CountingInputStream;

public class MessageInput {
    private final CountingInputStream countingInputStream;
    private final DataInputStream dataInputStream;
    private int messageSize;

    public MessageInput(InputStream inputStream) {
        this.countingInputStream = new CountingInputStream(inputStream);
        this.dataInputStream = new DataInputStream(inputStream);
    }

    public DataInput nextMessage() throws IOException {
        this.messageSize = this.dataInputStream.readInt();
        if (this.messageSize == 0) {
            return null;
        }
        return new DataInputStream(new BoundedInputStream(this.countingInputStream, this.messageSize));
    }

    public void skipRemainingBytes() throws IOException {
        long count = this.countingInputStream.resetByteCount();
        if (count < (long)this.messageSize) {
            IOUtils.skipFully(this.dataInputStream, (long)this.messageSize - count);
        }
        this.messageSize = 0;
    }
}

