/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.soundcloud;

import com.sedmelluq.discord.lavaplayer.player.DefaultAudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.soundcloud.SoundCloudAudioTrack;
import com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.track.AudioItem;
import com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.BasicAudioPlaylist;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoundCloudAudioSourceManager
implements AudioSourceManager {
    private static final Logger log = LoggerFactory.getLogger(SoundCloudAudioSourceManager.class);
    private static final String CHARSET = "UTF-8";
    private static final String CLIENT_ID = "fDoItMDbsbZz8dY16ZzARCZmzgHBPotA";
    private static final String TRACK_URL_REGEX = "^(?:http://|https://|)(?:www\\.|)soundcloud\\.com/([a-zA-Z0-9-_]+)/([a-zA-Z0-9-_]+)(?:\\?.*|)$";
    private static final String PLAYLIST_URL_REGEX = "^(?:http://|https://|)(?:www\\.|)soundcloud\\.com/([a-zA-Z0-9-_]+)/sets/([a-zA-Z0-9-_]+)(?:\\?.*|)$";
    private static final String LIKED_URL_REGEX = "^(?:http://|https://|)(?:www\\.|)soundcloud\\.com/([a-zA-Z0-9-_]+)/likes/?(?:\\?.*|)$";
    private static final String LIKED_USER_URN_REGEX = "\"urn\":\"soundcloud:users:([0-9]+)\",\"username\":\"([^\"]+)\"";
    private static final Pattern trackUrlPattern = Pattern.compile("^(?:http://|https://|)(?:www\\.|)soundcloud\\.com/([a-zA-Z0-9-_]+)/([a-zA-Z0-9-_]+)(?:\\?.*|)$");
    private static final Pattern playlistUrlPattern = Pattern.compile("^(?:http://|https://|)(?:www\\.|)soundcloud\\.com/([a-zA-Z0-9-_]+)/sets/([a-zA-Z0-9-_]+)(?:\\?.*|)$");
    private static final Pattern likedUrlPattern = Pattern.compile("^(?:http://|https://|)(?:www\\.|)soundcloud\\.com/([a-zA-Z0-9-_]+)/likes/?(?:\\?.*|)$");
    private static final Pattern likedUserUrnPattern = Pattern.compile("\"urn\":\"soundcloud:users:([0-9]+)\",\"username\":\"([^\"]+)\"");
    private final HttpClientBuilder httpClientBuilder = HttpClientTools.createSharedCookiesHttpBuilder();

    @Override
    public String getSourceName() {
        return "soundcloud";
    }

    @Override
    public AudioItem loadItem(DefaultAudioPlayerManager manager, AudioReference reference) {
        Matcher trackUrlMatcher = trackUrlPattern.matcher(reference.identifier);
        if (trackUrlMatcher.matches() && !"likes".equals(trackUrlMatcher.group(2))) {
            return this.loadFromTrackPage(reference.identifier);
        }
        if (playlistUrlPattern.matcher(reference.identifier).matches()) {
            return this.loadFromPlaylist(reference.identifier);
        }
        if (likedUrlPattern.matcher(reference.identifier).matches()) {
            return this.loadFromLikedTracks(reference.identifier);
        }
        return null;
    }

    @Override
    public boolean isTrackEncodable(AudioTrack track) {
        return true;
    }

    @Override
    public void encodeTrack(AudioTrack track, DataOutput output) throws IOException {
    }

    @Override
    public AudioTrack decodeTrack(AudioTrackInfo trackInfo, DataInput input) throws IOException {
        return new SoundCloudAudioTrack(trackInfo, this);
    }

    @Override
    public void shutdown() {
    }

    public CloseableHttpClient createHttpClient() {
        return this.httpClientBuilder.build();
    }

    public String getTrackUrlFromId(String trackId) {
        return "https://api.soundcloud.com/tracks/" + trackId + "/stream?client_id=" + CLIENT_ID;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AudioTrack loadFromTrackPage(String trackWebUrl) {
        try (CloseableHttpClient httpClient = this.httpClientBuilder.build();){
            JsonBrowser trackInfoJson = this.loadTrackInfoFromJson(this.loadPageConfigJson(httpClient, trackWebUrl));
            AudioTrack audioTrack = this.buildAudioTrack(trackInfoJson);
            return audioTrack;
        }
        catch (IOException e) {
            throw new FriendlyException("Loading track from SoundCloud failed.", FriendlyException.Severity.SUSPICIOUS, e);
        }
    }

    private AudioTrack buildAudioTrack(JsonBrowser trackInfoJson) {
        String trackId = trackInfoJson.get("id").text();
        AudioTrackInfo trackInfo = new AudioTrackInfo(trackInfoJson.get("title").text(), trackInfoJson.get("user").get("username").text(), trackInfoJson.get("duration").as(Integer.class).intValue(), trackId, false);
        return new SoundCloudAudioTrack(trackInfo, this);
    }

    private JsonBrowser loadPageConfigJson(CloseableHttpClient httpClient, String url) throws IOException {
        try (CloseableHttpResponse response = httpClient.execute(new HttpGet(url));){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 404) {
                throw new FriendlyException("That track does not exist.", FriendlyException.Severity.COMMON, null);
            }
            if (statusCode != 200) {
                throw new IOException("Invalid status code for video page response.");
            }
            String html = IOUtils.toString(response.getEntity().getContent(), Charset.forName(CHARSET));
            String configJson = DataFormatTools.extractBetween(html, "e}var c=", ",o=Date.now()");
            if (configJson == null) {
                throw new FriendlyException("This url does not appear to be a playable track.", FriendlyException.Severity.SUSPICIOUS, null);
            }
            JsonBrowser jsonBrowser = JsonBrowser.parse(configJson);
            return jsonBrowser;
        }
    }

    private JsonBrowser loadTrackInfoFromJson(JsonBrowser json) {
        for (JsonBrowser value : json.values()) {
            for (JsonBrowser entry : value.safeGet("data").values()) {
                if (!entry.isMap() || !"track".equals(entry.get("kind").text())) continue;
                return entry;
            }
        }
        throw new IllegalStateException("Could not find track information block.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AudioPlaylist loadFromPlaylist(String playlistWebUrl) {
        try (CloseableHttpClient httpClient = this.httpClientBuilder.build();){
            JsonBrowser playlistInfo = this.loadPlaylistInfoFromJson(this.loadPageConfigJson(httpClient, playlistWebUrl));
            BasicAudioPlaylist basicAudioPlaylist = new BasicAudioPlaylist(playlistInfo.get("title").text(), this.loadTracksFromPlaylist(httpClient, playlistInfo, playlistWebUrl), null, false);
            return basicAudioPlaylist;
        }
        catch (IOException e) {
            throw new FriendlyException("Loading playlist from SoundCloud failed.", FriendlyException.Severity.SUSPICIOUS, e);
        }
    }

    private JsonBrowser loadPlaylistInfoFromJson(JsonBrowser json) {
        for (JsonBrowser value : json.values()) {
            for (JsonBrowser entry : value.safeGet("data").values()) {
                if (!entry.isMap() || !"playlist".equals(entry.get("kind").text())) continue;
                return entry;
            }
        }
        throw new IllegalStateException("Could not find playlist information block.");
    }

    private List<AudioTrack> loadTracksFromPlaylist(CloseableHttpClient httpClient, JsonBrowser playlistInfo, String playlistWebUrl) throws IOException {
        ArrayList<AudioTrack> tracks = new ArrayList<AudioTrack>();
        URI trackListUrl = this.buildTrackListUrl(playlistInfo);
        try (CloseableHttpResponse response = httpClient.execute(new HttpGet(trackListUrl));){
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new IOException("Invalid status code for track list response.");
            }
            JsonBrowser trackList = JsonBrowser.parse(response.getEntity().getContent());
            int blockedCount = 0;
            for (JsonBrowser trackInfoJson : trackList.values()) {
                if ("BLOCK".equals(trackInfoJson.get("policy").text())) {
                    ++blockedCount;
                    continue;
                }
                tracks.add(this.buildAudioTrack(trackInfoJson));
            }
            if (blockedCount > 0) {
                log.debug("In soundcloud playlist {}, {} tracks were omitted because they are blocked.", (Object)playlistWebUrl, (Object)blockedCount);
            }
        }
        return tracks;
    }

    private URI buildTrackListUrl(JsonBrowser playlistInfo) {
        try {
            return new URIBuilder("https://api-v2.soundcloud.com/tracks").addParameter("ids", this.buildTrackIdList(playlistInfo)).addParameter("client_id", CLIENT_ID).build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private String buildTrackIdList(JsonBrowser playlistInfo) {
        StringJoiner joiner = new StringJoiner(",");
        for (JsonBrowser trackInfo : playlistInfo.get("tracks").values()) {
            joiner.add(trackInfo.get("id").text());
        }
        return joiner.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AudioItem loadFromLikedTracks(String likedListUrl) {
        try (CloseableHttpClient httpClient = this.httpClientBuilder.build();){
            UserInfo userInfo = this.findUserIdFromLikedList(httpClient, likedListUrl);
            if (userInfo == null) {
                AudioReference audioReference = AudioReference.NO_TRACK;
                return audioReference;
            }
            AudioItem audioItem = this.extractTracksFromLikedList(this.loadLikedListForUserId(httpClient, userInfo), userInfo);
            return audioItem;
        }
        catch (IOException e) {
            throw new FriendlyException("Loading liked tracks from SoundCloud failed.", FriendlyException.Severity.SUSPICIOUS, e);
        }
    }

    private UserInfo findUserIdFromLikedList(CloseableHttpClient httpClient, String likedListUrl) throws IOException {
        try (CloseableHttpResponse response = httpClient.execute(new HttpGet(likedListUrl));){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 404) {
                UserInfo userInfo = null;
                return userInfo;
            }
            if (statusCode != 200) {
                throw new IOException("Invalid status code for track list response.");
            }
            Matcher matcher = likedUserUrnPattern.matcher(IOUtils.toString(response.getEntity().getContent(), StandardCharsets.UTF_8));
            UserInfo userInfo = matcher.find() ? new UserInfo(matcher.group(1), matcher.group(2)) : null;
            return userInfo;
        }
    }

    private JsonBrowser loadLikedListForUserId(CloseableHttpClient httpClient, UserInfo userInfo) throws IOException {
        HttpGet request = new HttpGet("https://api-v2.soundcloud.com/users/" + userInfo.id + "/likes?client_id=" + CLIENT_ID + "&limit=200&offset=0");
        try (CloseableHttpResponse response = httpClient.execute(request);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new IOException("Invalid status code for liked tracks response.");
            }
            JsonBrowser jsonBrowser = JsonBrowser.parse(response.getEntity().getContent());
            return jsonBrowser;
        }
    }

    private AudioItem extractTracksFromLikedList(JsonBrowser likedTracks, UserInfo userInfo) {
        ArrayList<AudioTrack> tracks = new ArrayList<AudioTrack>();
        for (JsonBrowser item : likedTracks.get("collection").values()) {
            JsonBrowser trackItem = item.get("track");
            if (trackItem.isNull()) continue;
            tracks.add(this.buildAudioTrack(trackItem));
        }
        return new BasicAudioPlaylist("Liked by " + userInfo.name, tracks, null, false);
    }

    private static class UserInfo {
        private final String id;
        private final String name;

        private UserInfo(String id, String name) {
            this.id = id;
            this.name = name;
        }
    }
}

