/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.remote;

import com.sedmelluq.discord.lavaplayer.player.AudioPlayer;
import com.sedmelluq.discord.lavaplayer.player.DefaultAudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.player.event.AudioEventAdapter;
import com.sedmelluq.discord.lavaplayer.remote.RemoteAudioTrackExecutor;
import com.sedmelluq.discord.lavaplayer.remote.RemoteNodeProcessor;
import com.sedmelluq.discord.lavaplayer.tools.DaemonThreadFactory;
import com.sedmelluq.discord.lavaplayer.tools.ExecutorTools;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackEndReason;
import com.sedmelluq.discord.lavaplayer.track.InternalAudioTrack;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioTrackExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class RemoteNodeManager
extends AudioEventAdapter
implements Runnable {
    private final DefaultAudioPlayerManager playerManager;
    private final List<RemoteNodeProcessor> processors;
    private final AtomicBoolean enabled;
    private volatile ScheduledThreadPoolExecutor scheduler;

    public RemoteNodeManager(DefaultAudioPlayerManager playerManager) {
        this.playerManager = playerManager;
        this.processors = new ArrayList<RemoteNodeProcessor>();
        this.enabled = new AtomicBoolean();
    }

    public void initialise(List<String> nodeAddresses) {
        if (!this.enabled.compareAndSet(false, true)) {
            throw new IllegalStateException("Remote nodes already configured.");
        }
        ScheduledThreadPoolExecutor scheduledExecutor = new ScheduledThreadPoolExecutor(nodeAddresses.size() + 1, new DaemonThreadFactory("remote"));
        scheduledExecutor.scheduleAtFixedRate(this, 2000L, 2000L, TimeUnit.MILLISECONDS);
        for (String nodeAddress : nodeAddresses) {
            RemoteNodeProcessor processor = new RemoteNodeProcessor(this.playerManager, nodeAddress, scheduledExecutor);
            scheduledExecutor.submit(processor);
            this.processors.add(processor);
        }
        this.scheduler = scheduledExecutor;
    }

    public void shutdown() {
        if (!this.enabled.compareAndSet(true, false)) {
            return;
        }
        ExecutorTools.shutdownExecutor(this.scheduler, "node manager");
        for (RemoteNodeProcessor processor : this.processors) {
            processor.processHealthCheck(true);
        }
    }

    public boolean isEnabled() {
        return this.enabled.get();
    }

    public void startPlaying(RemoteAudioTrackExecutor remoteExecutor) {
        RemoteNodeProcessor processor = this.getNodeForNextTrack();
        processor.startPlaying(remoteExecutor);
    }

    private RemoteNodeProcessor getNodeForNextTrack() {
        int lowestPenalty = Integer.MAX_VALUE;
        RemoteNodeProcessor node = null;
        for (RemoteNodeProcessor processor : this.processors) {
            int penalty = processor.getBalancerPenalty();
            if (penalty >= lowestPenalty) continue;
            lowestPenalty = penalty;
            node = processor;
        }
        if (node == null) {
            throw new FriendlyException("No available machines for playing track.", FriendlyException.Severity.SUSPICIOUS, null);
        }
        return node;
    }

    @Override
    public void onTrackEnd(AudioPlayer player, AudioTrack track, AudioTrackEndReason endReason) {
        AudioTrackExecutor executor = ((InternalAudioTrack)track).getActiveExecutor();
        if (endReason != AudioTrackEndReason.FINISHED && executor instanceof RemoteAudioTrackExecutor) {
            for (RemoteNodeProcessor processor : this.processors) {
                processor.trackEnded((RemoteAudioTrackExecutor)executor, true);
            }
        }
    }

    @Override
    public void run() {
        for (RemoteNodeProcessor processor : this.processors) {
            processor.processHealthCheck(false);
        }
    }
}

