/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.player;

import com.sedmelluq.discord.lavaplayer.player.DefaultAudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.player.event.AudioEvent;
import com.sedmelluq.discord.lavaplayer.player.event.AudioEventListener;
import com.sedmelluq.discord.lavaplayer.player.event.PlayerPauseEvent;
import com.sedmelluq.discord.lavaplayer.player.event.PlayerResumeEvent;
import com.sedmelluq.discord.lavaplayer.player.event.TrackEndEvent;
import com.sedmelluq.discord.lavaplayer.player.event.TrackExceptionEvent;
import com.sedmelluq.discord.lavaplayer.player.event.TrackStartEvent;
import com.sedmelluq.discord.lavaplayer.player.event.TrackStuckEvent;
import com.sedmelluq.discord.lavaplayer.player.hook.AudioOutputHook;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackEndReason;
import com.sedmelluq.discord.lavaplayer.track.InternalAudioTrack;
import com.sedmelluq.discord.lavaplayer.track.TrackStateListener;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioFrame;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioFrameProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioPlayer
implements AudioFrameProvider,
TrackStateListener {
    private static final Logger log = LoggerFactory.getLogger(AudioPlayer.class);
    private volatile InternalAudioTrack activeTrack;
    private volatile long lastRequestTime;
    private volatile long lastReceiveTime;
    private volatile boolean stuckEventSent;
    private volatile InternalAudioTrack shadowTrack;
    private final AtomicBoolean paused;
    private final DefaultAudioPlayerManager manager;
    private final List<AudioEventListener> listeners;
    private final AtomicInteger volumeLevel;
    private final AudioOutputHook outputHook;
    private final Object trackSwitchLock;

    public AudioPlayer(DefaultAudioPlayerManager manager, AudioOutputHook outputHook) {
        this.manager = manager;
        this.outputHook = outputHook;
        this.activeTrack = null;
        this.paused = new AtomicBoolean();
        this.listeners = new ArrayList<AudioEventListener>();
        this.volumeLevel = new AtomicInteger(100);
        this.trackSwitchLock = new Object();
    }

    public AudioTrack getPlayingTrack() {
        return this.activeTrack;
    }

    public void playTrack(AudioTrack track) {
        this.startTrack(track, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startTrack(AudioTrack track, boolean noInterrupt) {
        InternalAudioTrack newTrack = (InternalAudioTrack)track;
        Object object = this.trackSwitchLock;
        synchronized (object) {
            InternalAudioTrack previousTrack = this.activeTrack;
            if (noInterrupt && previousTrack != null) {
                return false;
            }
            this.activeTrack = newTrack;
            this.lastRequestTime = System.currentTimeMillis();
            this.lastReceiveTime = System.nanoTime();
            this.stuckEventSent = false;
            if (previousTrack != null) {
                previousTrack.stop();
                this.dispatchEvent(new TrackEndEvent(this, previousTrack, newTrack == null ? AudioTrackEndReason.STOPPED : AudioTrackEndReason.REPLACED));
                this.shadowTrack = previousTrack;
            }
        }
        if (newTrack == null) {
            this.shadowTrack = null;
            return false;
        }
        this.dispatchEvent(new TrackStartEvent(this, newTrack));
        this.manager.executeTrack(this, newTrack, this.manager.getConfiguration(), this.volumeLevel);
        return true;
    }

    public void stopTrack() {
        this.stopWithReason(AudioTrackEndReason.STOPPED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopWithReason(AudioTrackEndReason reason) {
        this.shadowTrack = null;
        Object object = this.trackSwitchLock;
        synchronized (object) {
            InternalAudioTrack previousTrack = this.activeTrack;
            this.activeTrack = null;
            if (previousTrack != null) {
                previousTrack.stop();
                this.dispatchEvent(new TrackEndEvent(this, previousTrack, reason));
            }
        }
    }

    private AudioFrame provideShadowFrame() {
        InternalAudioTrack shadow = this.shadowTrack;
        AudioFrame frame = null;
        if (shadow != null && (frame = shadow.provide()) != null && frame.isTerminator()) {
            this.shadowTrack = null;
            frame = null;
        }
        return frame;
    }

    @Override
    public AudioFrame provide() {
        AudioFrame frame = this.provideDirectly();
        if (this.outputHook != null) {
            frame = this.outputHook.outgoingFrame(this, frame);
        }
        return frame;
    }

    public AudioFrame provideDirectly() {
        InternalAudioTrack track;
        this.lastRequestTime = System.currentTimeMillis();
        if (this.paused.get()) {
            return null;
        }
        while ((track = this.activeTrack) != null) {
            AudioFrame frame = track.provide();
            if (frame != null) {
                this.lastReceiveTime = System.nanoTime();
                this.shadowTrack = null;
                if (frame.isTerminator()) {
                    this.handleTerminator(track);
                    continue;
                }
            } else {
                if (!this.stuckEventSent && System.nanoTime() - this.lastReceiveTime > this.manager.getTrackStuckThresholdNanos()) {
                    this.stuckEventSent = true;
                    this.dispatchEvent(new TrackStuckEvent(this, track, TimeUnit.NANOSECONDS.toMillis(this.manager.getTrackStuckThresholdNanos())));
                }
                frame = this.provideShadowFrame();
            }
            return frame;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTerminator(InternalAudioTrack track) {
        Object object = this.trackSwitchLock;
        synchronized (object) {
            if (this.activeTrack == track) {
                this.activeTrack = null;
                this.dispatchEvent(new TrackEndEvent(this, track, track.getActiveExecutor().failedBeforeLoad() ? AudioTrackEndReason.LOAD_FAILED : AudioTrackEndReason.FINISHED));
            }
        }
    }

    public int getVolume() {
        return this.volumeLevel.get();
    }

    public void setVolume(int volume) {
        this.volumeLevel.set(Math.min(150, Math.max(0, volume)));
    }

    public boolean isPaused() {
        return this.paused.get();
    }

    public void setPaused(boolean value) {
        if (this.paused.compareAndSet(!value, value)) {
            if (value) {
                this.dispatchEvent(new PlayerPauseEvent(this));
            } else {
                this.dispatchEvent(new PlayerResumeEvent(this));
                this.lastReceiveTime = System.nanoTime();
            }
        }
    }

    public void destroy() {
        this.stopTrack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(AudioEventListener listener) {
        List<AudioEventListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(AudioEventListener listener) {
        List<AudioEventListener> list = this.listeners;
        synchronized (list) {
            Iterator<AudioEventListener> iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() != listener) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchEvent(AudioEvent event) {
        log.debug("Firing an event with class {}", (Object)event.getClass().getSimpleName());
        List<AudioEventListener> list = this.listeners;
        synchronized (list) {
            for (AudioEventListener listener : this.listeners) {
                try {
                    listener.onEvent(event);
                }
                catch (Exception e) {
                    log.error("Handler of event {} threw an exception.", (Object)event, (Object)e);
                }
            }
        }
    }

    @Override
    public void onTrackException(AudioTrack track, FriendlyException exception) {
        this.dispatchEvent(new TrackExceptionEvent(this, track, exception));
    }

    public void checkCleanup(long threshold) {
        AudioTrack track = this.getPlayingTrack();
        if (track != null && System.currentTimeMillis() - this.lastRequestTime >= threshold) {
            log.debug("Triggering cleanup on an audio player playing track {}", (Object)track);
            this.stopWithReason(AudioTrackEndReason.CLEANUP);
        }
    }
}

