/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.filter;

import com.sedmelluq.discord.lavaplayer.filter.ShortPcmAudioFilter;
import java.nio.ShortBuffer;

public class ChannelCountPcmAudioFilter
implements ShortPcmAudioFilter {
    private final ShortPcmAudioFilter downstream;
    private final int outputChannels;
    private final ShortBuffer outputBuffer;
    private final int inputChannels;
    private int nextChannelIndex;
    private short lastSample;

    public ChannelCountPcmAudioFilter(int inputChannels, int outputChannels, ShortPcmAudioFilter downstream) {
        this.downstream = downstream;
        this.inputChannels = inputChannels;
        this.outputChannels = outputChannels;
        this.outputBuffer = ShortBuffer.allocate(2048 * inputChannels);
        this.nextChannelIndex = 0;
    }

    @Override
    public void process(short[] input, int offset, int length) throws InterruptedException {
        if (this.canPassThrough(length)) {
            this.downstream.process(input, offset, length);
        } else {
            this.processNormalizer(ShortBuffer.wrap(input, offset, length));
        }
    }

    @Override
    public void process(ShortBuffer buffer) throws InterruptedException {
        if (this.canPassThrough(buffer.remaining())) {
            this.downstream.process(buffer);
        } else {
            this.processNormalizer(buffer);
        }
    }

    private void processNormalizer(ShortBuffer buffer) throws InterruptedException {
        int frameRemaining = this.inputChannels - this.nextChannelIndex;
        int commonChannels = Math.min(this.outputChannels, this.inputChannels);
        while (buffer.remaining() >= frameRemaining) {
            while (this.nextChannelIndex < commonChannels) {
                this.lastSample = buffer.get();
                this.outputBuffer.put(this.lastSample);
                ++this.nextChannelIndex;
            }
            while (this.nextChannelIndex < this.inputChannels) {
                buffer.get();
                ++this.nextChannelIndex;
            }
            while (this.nextChannelIndex < this.outputChannels) {
                this.outputBuffer.put(this.lastSample);
                ++this.nextChannelIndex;
            }
            this.nextChannelIndex = 0;
        }
        this.outputBuffer.flip();
        this.downstream.process(this.outputBuffer);
        this.outputBuffer.clear();
        int remainingInputChannels = buffer.remaining();
        if (remainingInputChannels > 0) {
            int remainingCommonChannels = Math.min(this.outputChannels, remainingInputChannels);
            while (this.nextChannelIndex < remainingCommonChannels) {
                this.lastSample = buffer.get();
                this.outputBuffer.put(this.lastSample);
                ++this.nextChannelIndex;
            }
            while (this.nextChannelIndex < remainingInputChannels) {
                buffer.get();
                ++this.nextChannelIndex;
            }
        }
    }

    private boolean canPassThrough(int length) {
        return this.nextChannelIndex == 0 && this.inputChannels == this.outputChannels && length % this.inputChannels == 0;
    }

    @Override
    public void seekPerformed(long requestedTime, long providedTime) {
        this.downstream.seekPerformed(requestedTime, providedTime);
        this.outputBuffer.clear();
        this.nextChannelIndex = 0;
    }

    @Override
    public void flush() throws InterruptedException {
        this.downstream.flush();
    }

    @Override
    public void close() {
        this.downstream.close();
    }
}

