/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.container.mp3;

import com.sedmelluq.discord.lavaplayer.container.mp3.Mp3Seeker;
import com.sedmelluq.discord.lavaplayer.natives.mp3.Mp3Decoder;
import com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import java.io.IOException;

public class Mp3ConstantRateSeeker
implements Mp3Seeker {
    private final double averageFrameSize;
    private final int sampleRate;
    private final long firstFramePosition;
    private final long contentLength;

    private Mp3ConstantRateSeeker(double averageFrameSize, int sampleRate, long firstFramePosition, long contentLength) {
        this.averageFrameSize = averageFrameSize;
        this.sampleRate = sampleRate;
        this.firstFramePosition = firstFramePosition;
        this.contentLength = contentLength;
    }

    public static Mp3ConstantRateSeeker createFromFrame(long firstFramePosition, long contentLength, byte[] frameBuffer) {
        int sampleRate = Mp3Decoder.getFrameSampleRate(frameBuffer, 0);
        double averageFrameSize = Mp3Decoder.getAverageFrameSize(frameBuffer, 0);
        return new Mp3ConstantRateSeeker(averageFrameSize, sampleRate, firstFramePosition, contentLength);
    }

    @Override
    public long getDuration() {
        return this.getMaximumFrameCount() * 1152L * 1000L / (long)this.sampleRate;
    }

    @Override
    public boolean isSeekable() {
        return true;
    }

    @Override
    public long seekAndGetFrameIndex(long timecode, SeekableInputStream inputStream) throws IOException {
        long maximumFrameCount = this.getMaximumFrameCount();
        long sampleIndex = timecode * (long)this.sampleRate / 1000L;
        long frameIndex = Math.min(sampleIndex / 1152L, maximumFrameCount);
        long seekPosition = (long)((double)frameIndex * this.averageFrameSize) - 8L;
        inputStream.seek(this.firstFramePosition + seekPosition);
        return frameIndex;
    }

    private long getMaximumFrameCount() {
        return (long)((double)(this.contentLength - this.firstFramePosition + 8L) / this.averageFrameSize);
    }
}

