/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.container.matroska;

import com.sedmelluq.discord.lavaplayer.container.matroska.MatroskaCuePoint;
import com.sedmelluq.discord.lavaplayer.container.matroska.MatroskaFixedBlock;
import com.sedmelluq.discord.lavaplayer.container.matroska.MatroskaTrackConsumer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ebml.EBMLReader;
import org.ebml.Element;
import org.ebml.FloatElement;
import org.ebml.MasterElement;
import org.ebml.SignedIntegerElement;
import org.ebml.StringElement;
import org.ebml.UnsignedIntegerElement;
import org.ebml.io.DataSource;
import org.ebml.matroska.MatroskaDocTypes;
import org.ebml.matroska.MatroskaFileFrame;
import org.ebml.matroska.MatroskaFileTrack;

public class MatroskaStreamingFile {
    private final DataSource dataSource;
    private final EBMLReader reader;
    private long timecodeScale = 1000000L;
    private double duration;
    private final ArrayList<MatroskaFileTrack> trackList = new ArrayList();
    private Element firstClusterElement = null;
    private long minimumTimecode = 0L;
    private boolean seeking = false;
    private Long segmentElementPosition = null;
    private Long segmentEndPosition = null;
    private Long firstClusterPosition = null;
    private Long cueElementPosition = null;
    private List<MatroskaCuePoint> cuePoints = null;

    public MatroskaStreamingFile(DataSource inputDataSource) {
        this.dataSource = inputDataSource;
        this.reader = new EBMLReader(this.dataSource);
    }

    public long getTimecodeScale() {
        return this.timecodeScale;
    }

    public double getDuration() {
        return this.duration;
    }

    public MatroskaFileTrack[] getTrackList() {
        if (!this.trackList.isEmpty()) {
            MatroskaFileTrack[] tracks = new MatroskaFileTrack[this.trackList.size()];
            for (int t = 0; t < this.trackList.size(); ++t) {
                tracks[t] = this.trackList.get(t);
            }
            return tracks;
        }
        return new MatroskaFileTrack[0];
    }

    public void readFile() {
        Element level0 = this.reader.readNextElement();
        if (level0 == null) {
            throw new RuntimeException("Unable to scan for EBML elements");
        }
        if (!level0.isType(MatroskaDocTypes.EBML.getType())) {
            throw new RuntimeException("EBML Header not the first element in the file");
        }
        this.parseEbmlElement((MasterElement)level0);
        level0 = this.reader.readNextElement();
        this.segmentElementPosition = this.dataSource.getFilePointer();
        this.segmentEndPosition = this.dataSource.getFilePointer() + level0.getSize();
        if (!level0.isType(MatroskaDocTypes.Segment.getType())) {
            throw new RuntimeException(String.format("Segment not the second element in the file: was %s instead", level0.getElementType().getName()));
        }
        this.parseSegmentElement((MasterElement)level0);
    }

    private void parseEbmlElement(MasterElement ebml) {
        Element level1 = ebml.readNextChild(this.reader);
        while (level1 != null) {
            String docType;
            level1.readData(this.dataSource);
            if (level1.isType(MatroskaDocTypes.DocType.getType()) && (docType = ((StringElement)level1).getValue()).compareTo("matroska") != 0 && docType.compareTo("webm") != 0) {
                throw new RuntimeException("Error: DocType is not matroska, \"" + ((StringElement)level1).getValue() + "\"");
            }
            level1 = ebml.readNextChild(this.reader);
        }
    }

    private void parseSegmentElement(MasterElement segment) {
        long currentPosition = this.dataSource.getFilePointer();
        Element level1 = segment.readNextChild(this.reader);
        while (level1 != null) {
            if (level1.isType(MatroskaDocTypes.Info.getType())) {
                this.parseSegmentInfo(level1);
            } else if (level1.isType(MatroskaDocTypes.Tracks.getType())) {
                this.parseTracks(level1);
            } else {
                if (level1.isType(MatroskaDocTypes.Cluster.getType())) {
                    this.firstClusterPosition = currentPosition;
                    this.firstClusterElement = level1;
                    break;
                }
                if (level1.isType(MatroskaDocTypes.SeekHead.getType())) {
                    this.parseSeekInfoForCuePosition((MasterElement)level1);
                } else if (level1.isType(MatroskaDocTypes.Cues.getType())) {
                    this.cuePoints = this.parseCues((MasterElement)level1);
                }
            }
            level1.skipData(this.dataSource);
            currentPosition = this.dataSource.getFilePointer();
            level1 = segment.readNextChild(this.reader);
        }
    }

    private void parseSeekInfoForCuePosition(MasterElement level1) {
        Element level2;
        while ((level2 = level1.readNextChild(this.reader)) != null) {
            if (level2.isType(MatroskaDocTypes.Seek.getType())) {
                this.parseSeekElement((MasterElement)level2);
            }
            level2.skipData(this.dataSource);
        }
    }

    private void parseSeekElement(MasterElement level2) {
        Element level3;
        boolean isCueElement = false;
        while ((level3 = level2.readNextChild(this.reader)) != null) {
            if (level3.isType(MatroskaDocTypes.SeekID.getType())) {
                level3.readData(this.dataSource);
                isCueElement = level3.getData().equals(MatroskaDocTypes.Cues.getType());
            } else if (level3.isType(MatroskaDocTypes.SeekPosition.getType()) && isCueElement) {
                level3.readData(this.dataSource);
                this.cueElementPosition = ((UnsignedIntegerElement)level3).getValue();
            }
            level3.skipData(this.dataSource);
        }
    }

    private List<MatroskaCuePoint> parseCues(MasterElement level1) {
        Element level2;
        ArrayList<MatroskaCuePoint> parsedCuePoints = new ArrayList<MatroskaCuePoint>();
        while ((level2 = level1.readNextChild(this.reader)) != null) {
            MatroskaCuePoint cuePoint;
            if (level2.isType(MatroskaDocTypes.CuePoint.getType()) && (cuePoint = this.parseCuePoint((MasterElement)level2)) != null) {
                parsedCuePoints.add(cuePoint);
            }
            level2.skipData(this.dataSource);
        }
        return parsedCuePoints.isEmpty() ? null : parsedCuePoints;
    }

    private MatroskaCuePoint parseCuePoint(MasterElement level2) {
        Element level3;
        Long cueTime = null;
        long[] positions = null;
        while ((level3 = level2.readNextChild(this.reader)) != null) {
            if (level3.isType(MatroskaDocTypes.CueTime.getType())) {
                level3.readData(this.dataSource);
                cueTime = ((UnsignedIntegerElement)level3).getValue();
            } else if (level3.isType(MatroskaDocTypes.CueTrackPositions.getType())) {
                positions = this.parseCueTrackPositions((MasterElement)level3);
            }
            level3.skipData(this.dataSource);
        }
        if (cueTime != null && positions != null) {
            return new MatroskaCuePoint(cueTime, positions);
        }
        return null;
    }

    private long[] parseCueTrackPositions(MasterElement level3) {
        Element level4;
        Long currentTrackId = null;
        long[] positions = new long[this.trackList.size() + 1];
        Arrays.fill(positions, -1L);
        while ((level4 = level3.readNextChild(this.reader)) != null) {
            if (level4.isType(MatroskaDocTypes.CueTrack.getType())) {
                level4.readData(this.dataSource);
                currentTrackId = ((UnsignedIntegerElement)level4).getValue();
            } else if (level4.isType(MatroskaDocTypes.CueClusterPosition.getType()) && currentTrackId != null) {
                level4.readData(this.dataSource);
                positions[currentTrackId.intValue()] = ((UnsignedIntegerElement)level4).getValue();
            }
            level4.skipData(this.dataSource);
        }
        return positions;
    }

    public void seekToTimecode(int trackId, long timecode) {
        MatroskaCuePoint cuePoint;
        this.minimumTimecode = timecode;
        this.seeking = true;
        this.firstClusterElement = null;
        if (this.cuePoints == null && this.cueElementPosition != null) {
            this.dataSource.seek(this.segmentElementPosition + this.cueElementPosition);
            Element level1 = this.reader.readNextElement();
            if (!level1.isType(MatroskaDocTypes.Cues.getType())) {
                throw new IllegalStateException("The element here should be cue.");
            }
            this.cuePoints = this.parseCues((MasterElement)level1);
        }
        if (this.cuePoints != null && (cuePoint = this.lastCueNotAfterTimecode(timecode)) != null && cuePoint.trackClusterOffsets[trackId] >= 0L) {
            this.dataSource.seek(this.segmentElementPosition + cuePoint.trackClusterOffsets[trackId]);
            return;
        }
        this.dataSource.seek(this.firstClusterPosition);
    }

    private MatroskaCuePoint lastCueNotAfterTimecode(long timecode) {
        int largerTimecodeIndex;
        for (largerTimecodeIndex = 0; largerTimecodeIndex < this.cuePoints.size() && this.cuePoints.get((int)largerTimecodeIndex).timecode <= timecode; ++largerTimecodeIndex) {
        }
        if (largerTimecodeIndex > 0) {
            return this.cuePoints.get(largerTimecodeIndex - 1);
        }
        return null;
    }

    public void provideFrames(MatroskaTrackConsumer consumer) throws InterruptedException {
        Element level1 = this.firstClusterElement != null ? this.firstClusterElement : this.reader.readNextElement();
        this.firstClusterElement = null;
        while (level1 != null) {
            if (level1.isType(MatroskaDocTypes.Cluster.getType())) {
                this.parseNextCluster((MasterElement)level1, consumer);
            }
            level1.skipData(this.dataSource);
            if (this.dataSource.getFilePointer() >= this.segmentEndPosition) break;
            level1 = this.reader.readNextElement();
        }
    }

    private void parseNextCluster(MasterElement cluster, MatroskaTrackConsumer consumer) throws InterruptedException {
        long clusterTimecode = 0L;
        Element level2 = cluster.readNextChild(this.reader);
        while (level2 != null) {
            if (level2.isType(MatroskaDocTypes.Timecode.getType())) {
                level2.readData(this.dataSource);
                clusterTimecode = ((UnsignedIntegerElement)level2).getValue();
            } else if (level2.isType(MatroskaDocTypes.SimpleBlock.getType())) {
                this.parseClusterSimpleBlock(level2, consumer, clusterTimecode);
            } else if (level2.isType(MatroskaDocTypes.BlockGroup.getType())) {
                this.parseClusterBlockGroup((MasterElement)level2, consumer, clusterTimecode);
            }
            level2.skipData(this.dataSource);
            level2 = cluster.readNextChild(this.reader);
        }
    }

    private void parseClusterSimpleBlock(Element simpleBlock, MatroskaTrackConsumer consumer, long clusterTimecode) throws InterruptedException {
        simpleBlock.readData(this.dataSource);
        long blockDuration = 0L;
        MatroskaFixedBlock block = new MatroskaFixedBlock(simpleBlock.getData());
        block.parseHeader();
        this.processFrameInBlock(block, consumer, clusterTimecode, 0L, false, 0L);
    }

    private void parseClusterBlockGroup(MasterElement blockGroup, MatroskaTrackConsumer consumer, long clusterTimecode) throws InterruptedException {
        long blockDuration = 0L;
        long blockReference = 0L;
        Element level3 = blockGroup.readNextChild(this.reader);
        MatroskaFixedBlock block = null;
        while (level3 != null) {
            if (level3.isType(MatroskaDocTypes.Block.getType())) {
                level3.readData(this.dataSource);
                block = new MatroskaFixedBlock(level3.getData());
                block.parseHeader();
            } else if (level3.isType(MatroskaDocTypes.BlockDuration.getType())) {
                level3.readData(this.dataSource);
                blockDuration = ((UnsignedIntegerElement)level3).getValue();
            } else if (level3.isType(MatroskaDocTypes.ReferenceBlock.getType())) {
                level3.readData(this.dataSource);
                blockReference = ((SignedIntegerElement)level3).getValue();
            }
            level3.skipData(this.dataSource);
            level3 = blockGroup.readNextChild(this.reader);
        }
        if (block == null) {
            throw new NullPointerException("BlockGroup element with no child Block!");
        }
        this.processFrameInBlock(block, consumer, clusterTimecode, blockDuration, true, blockReference);
    }

    private void processFrameInBlock(MatroskaFixedBlock block, MatroskaTrackConsumer consumer, long clusterTimecode, long blockDuration, boolean hasReference, long blockReference) throws InterruptedException {
        if (consumer.getTrack().getTrackNo() != block.getTrackNumber()) {
            return;
        }
        long timecode = clusterTimecode + (long)block.getTimecode();
        if (timecode >= this.minimumTimecode) {
            int frameCount = block.getFrameCount();
            MatroskaFileFrame frame = new MatroskaFileFrame();
            frame.setTrackNo(block.getTrackNumber());
            frame.setTimecode(timecode);
            frame.setDuration(blockDuration);
            frame.setKeyFrame(block.isKeyFrame());
            if (hasReference) {
                frame.addReferences(blockReference);
            }
            if (this.seeking) {
                consumer.seekPerformed(this.minimumTimecode, timecode);
                this.seeking = false;
            }
            for (int i = 0; i < frameCount; ++i) {
                frame.setData(block.getFrameBuffer(i));
                consumer.consume(frame);
            }
        }
    }

    private void parseSegmentInfo(Element level1) {
        Element level2 = ((MasterElement)level1).readNextChild(this.reader);
        while (level2 != null) {
            if (level2.isType(MatroskaDocTypes.Duration.getType())) {
                level2.readData(this.dataSource);
                this.duration = ((FloatElement)level2).getValue();
            } else if (level2.isType(MatroskaDocTypes.TimecodeScale.getType())) {
                level2.readData(this.dataSource);
                this.timecodeScale = ((UnsignedIntegerElement)level2).getValue();
            }
            level2.skipData(this.dataSource);
            level2 = ((MasterElement)level1).readNextChild(this.reader);
        }
    }

    private void parseTracks(Element level1) {
        Element level2 = ((MasterElement)level1).readNextChild(this.reader);
        try {
            Method fromElementMethod = MatroskaFileTrack.class.getDeclaredMethod("fromElement", Element.class, DataSource.class, EBMLReader.class);
            fromElementMethod.setAccessible(true);
            while (level2 != null) {
                if (level2.isType(MatroskaDocTypes.TrackEntry.getType())) {
                    this.trackList.add((MatroskaFileTrack)fromElementMethod.invoke(null, level2, this.dataSource, this.reader));
                }
                level2.skipData(this.dataSource);
                level2 = ((MasterElement)level1).readNextChild(this.reader);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        MatroskaDocTypes.Void.getLevel();
    }
}

