/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.container.matroska;

import com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.ebml.io.DataSource;

public class MatroskaStreamDataSource
implements DataSource {
    private final SeekableInputStream stream;
    private final long length;
    private byte[] tempBuffer;

    public MatroskaStreamDataSource(SeekableInputStream stream) {
        this.stream = stream;
        this.length = stream.getContentLength();
    }

    @Override
    public byte readByte() {
        try {
            return (byte)this.stream.read();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private int readChunkFullyToBuffer(ByteBuffer buffer) {
        int actualReadLength;
        try {
            if (buffer.hasArray()) {
                int readSize = buffer.remaining();
                actualReadLength = this.stream.read(buffer.array(), buffer.arrayOffset() + (buffer.capacity() - readSize), readSize);
            } else {
                if (this.tempBuffer == null) {
                    this.tempBuffer = new byte[1024];
                }
                int readSize = Math.min(buffer.remaining(), this.tempBuffer.length);
                actualReadLength = this.stream.read(this.tempBuffer, 0, readSize);
            }
            if (actualReadLength < 0) {
                throw new EOFException("Requested more than was available.");
            }
            buffer.position(buffer.position() + actualReadLength);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return actualReadLength;
    }

    @Override
    public int read(ByteBuffer buffer) {
        int totalReadLength = 0;
        while (buffer.remaining() > 0) {
            totalReadLength += this.readChunkFullyToBuffer(buffer);
        }
        return totalReadLength;
    }

    @Override
    public long skip(long offset) {
        try {
            long totalSkipped;
            long skipped;
            for (totalSkipped = 0L; totalSkipped < offset; totalSkipped += skipped) {
                skipped = this.stream.skip(offset - totalSkipped);
                if (skipped > 0L) {
                    continue;
                }
                throw new EOFException("Tried to skip past the end.");
            }
            return totalSkipped;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public long getFilePointer() {
        return this.stream.getPosition();
    }

    @Override
    public boolean isSeekable() {
        return true;
    }

    @Override
    public long seek(long pos) {
        try {
            this.stream.seek(pos);
            return pos;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

