/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.container.matroska;

import com.sedmelluq.discord.lavaplayer.container.MediaContainerDetection;
import com.sedmelluq.discord.lavaplayer.container.MediaContainerDetectionResult;
import com.sedmelluq.discord.lavaplayer.container.MediaContainerProbe;
import com.sedmelluq.discord.lavaplayer.container.matroska.MatroskaAudioTrack;
import com.sedmelluq.discord.lavaplayer.container.matroska.MatroskaStreamDataSource;
import com.sedmelluq.discord.lavaplayer.container.matroska.MatroskaStreamingFile;
import com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.ebml.matroska.MatroskaFileTrack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatroskaContainerProbe
implements MediaContainerProbe {
    private static final Logger log = LoggerFactory.getLogger(MatroskaContainerProbe.class);
    static final String OPUS_CODEC = "A_OPUS";
    static final String VORBIS_CODEC = "A_VORBIS";
    static final String AAC_CODEC = "A_AAC";
    private static final int[] EBML_TAG = new int[]{26, 69, 223, 163};
    private static final List<String> supportedCodecs = Arrays.asList("A_OPUS", "A_VORBIS", "A_AAC");

    @Override
    public String getName() {
        return "matroska/webm";
    }

    @Override
    public MediaContainerDetectionResult probe(AudioReference reference, SeekableInputStream inputStream) throws IOException {
        if (!MediaContainerDetection.checkNextBytes(inputStream, EBML_TAG)) {
            return null;
        }
        log.debug("Track {} is a matroska file.", (Object)reference.identifier);
        MatroskaStreamingFile file = new MatroskaStreamingFile(new MatroskaStreamDataSource(inputStream));
        file.readFile();
        if (!this.hasSupportedAudioTrack(file)) {
            return new MediaContainerDetectionResult((MediaContainerProbe)this, "No supported audio tracks present in the file.");
        }
        return new MediaContainerDetectionResult((MediaContainerProbe)this, new AudioTrackInfo("Unknown title", "Unknown artist", (long)file.getDuration(), reference.identifier, false));
    }

    private boolean hasSupportedAudioTrack(MatroskaStreamingFile file) {
        for (MatroskaFileTrack track : file.getTrackList()) {
            if (track.getTrackType() != MatroskaFileTrack.TrackType.AUDIO || !supportedCodecs.contains(track.getCodecID())) continue;
            return true;
        }
        return false;
    }

    @Override
    public AudioTrack createTrack(AudioTrackInfo trackInfo, SeekableInputStream inputStream) {
        return new MatroskaAudioTrack(trackInfo, inputStream);
    }
}

