/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.container.adts;

import com.sedmelluq.discord.lavaplayer.container.adts.AdtsPacketHeader;
import com.sedmelluq.discord.lavaplayer.container.adts.AdtsStreamReader;
import com.sedmelluq.discord.lavaplayer.filter.FilterChainBuilder;
import com.sedmelluq.discord.lavaplayer.filter.ShortPcmAudioFilter;
import com.sedmelluq.discord.lavaplayer.natives.aac.AacDecoder;
import com.sedmelluq.discord.lavaplayer.tools.io.DirectBufferStreamBroker;
import com.sedmelluq.discord.lavaplayer.tools.io.ResettableBoundedInputStream;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioProcessingContext;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;

public class AdtsStreamProvider {
    private final AudioProcessingContext context;
    private final AdtsStreamReader streamReader;
    private final AacDecoder decoder;
    private final ResettableBoundedInputStream packetBoundedStream;
    private final DirectBufferStreamBroker directBufferBroker;
    private ShortBuffer outputBuffer;
    private AdtsPacketHeader previousHeader;
    private ShortPcmAudioFilter downstream;

    public AdtsStreamProvider(InputStream inputStream, AudioProcessingContext context) {
        this.context = context;
        this.streamReader = new AdtsStreamReader(inputStream);
        this.decoder = new AacDecoder();
        this.packetBoundedStream = new ResettableBoundedInputStream(inputStream);
        this.directBufferBroker = new DirectBufferStreamBroker(2048);
    }

    public void provideFrames() throws InterruptedException {
        try {
            while (true) {
                AdtsPacketHeader header;
                if ((header = this.streamReader.findPacketHeader()) == null) {
                    return;
                }
                this.configureProcessing(header);
                this.packetBoundedStream.resetLimit(header.payloadLength);
                this.directBufferBroker.consume(true, this.packetBoundedStream);
                ByteBuffer buffer = this.directBufferBroker.getBuffer();
                if (buffer.limit() < header.payloadLength) {
                    return;
                }
                this.decodeAndSend(buffer);
                this.streamReader.nextPacket();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void decodeAndSend(ByteBuffer inputBuffer) throws InterruptedException {
        this.decoder.fill(inputBuffer);
        this.outputBuffer.clear();
        while (this.decoder.decode(this.outputBuffer, false)) {
            this.downstream.process(this.outputBuffer);
            this.outputBuffer.clear();
        }
    }

    private void configureProcessing(AdtsPacketHeader header) {
        if (!header.canUseSameDecoder(this.previousHeader)) {
            this.decoder.configure(header.profile, header.sampleRate, header.channels);
        }
        if (!header.hasSameDecodedFormat(this.previousHeader)) {
            if (this.downstream != null) {
                this.downstream.close();
            }
            this.downstream = FilterChainBuilder.forShortPcm(this.context, header.channels, header.sampleRate, true);
            this.outputBuffer = ByteBuffer.allocateDirect(2048 * header.channels).order(ByteOrder.nativeOrder()).asShortBuffer();
        }
        this.previousHeader = header;
    }

    public void close() {
        try {
            if (this.downstream != null) {
                this.downstream.close();
            }
        }
        finally {
            this.decoder.close();
        }
    }
}

