/*
 * Decompiled with CFR 0.152.
 */
package org.ebml.matroska;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.ebml.BinaryElement;
import org.ebml.EBMLReader;
import org.ebml.Element;
import org.ebml.MasterElement;
import org.ebml.UnsignedIntegerElement;
import org.ebml.io.DataSource;
import org.ebml.matroska.MatroskaDocTypes;
import org.ebml.matroska.MatroskaFileFrame;
import org.ebml.matroska.MatroskaLaceMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MatroskaSimpleBlock {
    private static final Logger LOG = LoggerFactory.getLogger(MatroskaSimpleBlock.class);
    private static final int MAX_LACE_SIZE = 1530;
    private int trackNumber = 0;
    private short timecode = 0;
    private boolean keyFrame = true;
    private MatroskaLaceMode laceMode = MatroskaLaceMode.EBML;
    private boolean invisible = false;
    private boolean discardable = false;
    private final List<MatroskaFileFrame> frames = new ArrayList<MatroskaFileFrame>();
    private int totalSize = 18;
    private long duration = Long.MIN_VALUE;

    public MatroskaSimpleBlock() {
    }

    public MatroskaSimpleBlock(long duration) {
    }

    static MatroskaSimpleBlock fromElement(Element level3, DataSource ioDS, EBMLReader reader) {
        return new MatroskaSimpleBlock();
    }

    Element toElement() {
        if (this.isSimpleBlock()) {
            return this.toSimpleBlock();
        }
        return this.toBlockGroup();
    }

    Element toSimpleBlock() {
        BinaryElement blockElem = MatroskaDocTypes.SimpleBlock.getInstance();
        blockElem.setData(this.createInnerData());
        return blockElem;
    }

    Element toBlockGroup() {
        MasterElement blockGroupElem = MatroskaDocTypes.BlockGroup.getInstance();
        BinaryElement blockElem = MatroskaDocTypes.Block.getInstance();
        blockElem.setData(this.createInnerData());
        UnsignedIntegerElement durationElem = MatroskaDocTypes.BlockDuration.getInstance();
        durationElem.setValue(this.duration);
        blockGroupElem.addChildElement(blockElem);
        blockGroupElem.addChildElement(durationElem);
        return blockGroupElem;
    }

    private ByteBuffer createInnerData() {
        ByteBuffer buf = ByteBuffer.allocate(this.totalSize);
        assert (this.trackNumber < 16384);
        if (this.trackNumber < 128) {
            buf.put((byte)(this.trackNumber | 0x80));
        } else {
            buf.put((byte)(this.trackNumber >> 8 | 0x40));
            buf.put((byte)(this.trackNumber & 0xFF));
        }
        buf.putShort(this.timecode);
        BitSet bs = new BitSet(8);
        bs.set(0, this.keyFrame);
        bs.set(4, this.invisible);
        ByteBuffer sizes = null;
        this.laceMode = this.pickBestLaceMode();
        switch (this.laceMode) {
            case EBML: {
                bs.set(5);
                bs.set(6);
                sizes = this.ebmlEncodeLaceSizes();
                break;
            }
            case XIPH: {
                bs.set(6);
                sizes = this.xiphEncodeLaceSizes();
                break;
            }
            case FIXED: {
                sizes = this.fixedEncodeLaceSizes();
                bs.set(5);
                break;
            }
            case NONE: {
                LOG.trace("Lace mode none!");
                break;
            }
        }
        bs.set(7, this.discardable);
        buf.put(bs.toByteArray());
        if (sizes != null) {
            buf.put(sizes);
        }
        for (MatroskaFileFrame frame : this.frames) {
            LOG.trace("Writing frame {}", (Object)frame.getData().remaining());
            buf.put(frame.getData());
        }
        buf.flip();
        return buf;
    }

    private MatroskaLaceMode pickBestLaceMode() {
        if (this.frames.size() == 1) {
            return MatroskaLaceMode.NONE;
        }
        return this.laceMode;
    }

    private ByteBuffer fixedEncodeLaceSizes() {
        LOG.trace("Encoding fixed lace sizes");
        return ByteBuffer.allocate(1).put((byte)(this.frames.size() - 1));
    }

    private ByteBuffer xiphEncodeLaceSizes() {
        LOG.trace("Encoding xiph lace sizes");
        ByteBuffer buf = ByteBuffer.allocate(30);
        buf.put((byte)(this.frames.size() - 1));
        for (int i = 0; i < this.frames.size() - 1; ++i) {
            int tmpSize;
            for (tmpSize = this.frames.get(i).getData().remaining(); tmpSize >= 255; tmpSize -= 255) {
                buf.put((byte)-1);
            }
            buf.put((byte)tmpSize);
        }
        return buf;
    }

    private ByteBuffer ebmlEncodeLaceSizes() {
        LOG.trace("Encoding ebml lace sizes");
        ByteBuffer buf = ByteBuffer.allocate(30);
        buf.put((byte)(this.frames.size() - 1));
        for (int i = 0; i < this.frames.size() - 1; ++i) {
            int tmpSize = this.frames.get(i).getData().remaining();
            buf.put(Element.makeEbmlCodedSize(tmpSize));
        }
        return buf;
    }

    public long getTimecode() {
        return this.timecode;
    }

    public void setTimecode(long timecode) {
        assert (timecode < 32767L);
        this.timecode = (short)timecode;
    }

    public MatroskaLaceMode getLaceMode() {
        return this.laceMode;
    }

    public void setLaceMode(MatroskaLaceMode laceMode) {
        this.laceMode = laceMode;
    }

    public boolean isInvisible() {
        return this.invisible;
    }

    public void setInvisible(boolean invisible) {
        this.invisible = invisible;
    }

    public boolean isDiscardable() {
        return this.discardable;
    }

    public void setDiscardable(boolean discardable) {
        this.discardable = discardable;
    }

    public boolean addFrame(MatroskaFileFrame frame) {
        LOG.trace("Adding frame {}", (Object)frame.getData().remaining());
        this.setTimecode(frame.getTimecode());
        this.setTrackNumber(frame.getTrackNo());
        this.totalSize += frame.getData().remaining();
        this.frames.add(frame);
        if (frame.getDuration() != Long.MIN_VALUE) {
            this.duration = frame.getDuration();
        }
        if (frame.getData().remaining() > 1530) {
            this.laceMode = MatroskaLaceMode.NONE;
            return false;
        }
        this.totalSize += 4;
        return !this.isSimpleBlock() || !this.laceMode.equals((Object)MatroskaLaceMode.NONE) && this.frames.size() <= 8;
    }

    public int getTrackNumber() {
        return this.trackNumber;
    }

    public void setTrackNumber(int trackNumber) {
        this.trackNumber = trackNumber;
    }

    public boolean isKeyFrame() {
        return this.keyFrame;
    }

    public void setKeyFrame(boolean keyFrame) {
        this.keyFrame = keyFrame;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public boolean isSimpleBlock() {
        return this.duration == Long.MIN_VALUE;
    }
}

