/*
 * Decompiled with CFR 0.152.
 */
package org.ebml.matroska;

import java.util.Date;
import org.ebml.DateElement;
import org.ebml.FloatElement;
import org.ebml.MasterElement;
import org.ebml.StringElement;
import org.ebml.UnsignedIntegerElement;
import org.ebml.io.DataWriter;
import org.ebml.matroska.MatroskaDocTypes;
import org.ebml.matroska.VoidElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatroskaSegmentInfo {
    private static final Logger LOG = LoggerFactory.getLogger(MatroskaSegmentInfo.class);
    private static final long BLOCK_SIZE = 128L;
    private long timecodeScale = 1000000L;
    private Double duration;
    private Date segmentDate = new Date();
    private final long myPosition;

    public MatroskaSegmentInfo(long position) {
        this.myPosition = position;
    }

    public long writeElement(DataWriter ioDW) {
        MasterElement segmentInfoElem = MatroskaDocTypes.Info.getInstance();
        StringElement writingAppElem = MatroskaDocTypes.WritingApp.getInstance();
        writingAppElem.setValue("Matroska File Writer v1.0");
        StringElement muxingAppElem = MatroskaDocTypes.MuxingApp.getInstance();
        muxingAppElem.setValue("JEBML v1.0");
        DateElement dateElem = MatroskaDocTypes.DateUTC.getInstance();
        dateElem.setDate(this.segmentDate);
        UnsignedIntegerElement timecodescaleElem = MatroskaDocTypes.TimecodeScale.getInstance();
        timecodescaleElem.setValue(this.timecodeScale);
        segmentInfoElem.addChildElement(dateElem);
        segmentInfoElem.addChildElement(timecodescaleElem);
        if (this.duration != null) {
            FloatElement durationElem = MatroskaDocTypes.Duration.getInstance();
            durationElem.setValue(this.duration);
            segmentInfoElem.addChildElement(durationElem);
        }
        segmentInfoElem.addChildElement(writingAppElem);
        segmentInfoElem.addChildElement(muxingAppElem);
        long len = segmentInfoElem.writeElement(ioDW);
        VoidElement spacer = new VoidElement(128L - len);
        spacer.writeElement(ioDW);
        return 1L;
    }

    public void update(DataWriter ioDW) {
        LOG.debug("Updating segment info header");
        long startingPos = ioDW.getFilePointer();
        ioDW.seek(this.myPosition);
        this.writeElement(ioDW);
        ioDW.seek(startingPos);
    }

    public double getDuration() {
        return this.duration;
    }

    public void setDuration(double duration) {
        this.duration = duration;
    }

    public Date getDate() {
        return this.segmentDate;
    }

    public void setDate(Date date) {
        this.segmentDate = date;
    }

    public long getTimecodeScale() {
        return this.timecodeScale;
    }

    public void setTimecodeScale(long timecodeScale) {
        this.timecodeScale = timecodeScale;
    }
}

