/*
 * Decompiled with CFR 0.152.
 */
package org.ebml.matroska;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.ebml.BinaryElement;
import org.ebml.EBMLReader;
import org.ebml.Element;
import org.ebml.FloatElement;
import org.ebml.MasterElement;
import org.ebml.StringElement;
import org.ebml.UnsignedIntegerElement;
import org.ebml.io.DataSource;
import org.ebml.matroska.MatroskaDocTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatroskaFileTrack {
    private static final Logger LOG = LoggerFactory.getLogger(MatroskaFileTrack.class);
    private int trackNo = 1;
    private long trackUID = 1337L;
    private boolean flagEnabled = true;
    private boolean flagDefault = true;
    private boolean flagForced = false;
    private boolean flagLacing = true;
    private int minCache = 0;
    private int maxBlockAdditionalId = 0;
    private String name = "unnamed";
    private String language = "eng";
    private String codecID;
    private ByteBuffer codecPrivate;
    private long defaultDuration;
    private boolean codecDecodeAll = true;
    private int seekPreroll = 0;
    private TrackType trackType;
    private MatroskaVideoTrack video = null;
    private MatroskaAudioTrack audio = null;
    private TrackOperation operation = null;
    private final ArrayList<Long> overlayUids = new ArrayList();

    public String toString() {
        String s = new String();
        s = s + "\t\tTrackNo: " + this.getTrackNo() + "\n";
        s = s + "\t\tTrackUID: " + this.getTrackUID() + "\n";
        s = s + "\t\tTrackType: " + this.getTrackType().name() + "\n";
        s = s + "\t\tDefaultDuration: " + this.getDefaultDuration() + "\n";
        s = s + "\t\tName: " + this.getName() + "\n";
        s = s + "\t\tLanguage: " + this.getLanguage() + "\n";
        s = s + "\t\tCodecID: " + this.getCodecID() + "\n";
        if (this.getCodecPrivate() != null) {
            s = s + "\t\tCodecPrivate: " + this.getCodecPrivate().remaining() + " byte(s)\n";
        }
        if (this.getTrackType() == TrackType.VIDEO) {
            s = s + "\t\tPixelWidth: " + this.video.getPixelWidth() + "\n";
            s = s + "\t\tPixelHeight: " + this.video.getPixelHeight() + "\n";
            s = s + "\t\tDisplayWidth: " + this.video.getDisplayWidth() + "\n";
            s = s + "\t\tDisplayHeight: " + this.video.getDisplayHeight() + "\n";
        }
        if (this.getTrackType() == TrackType.AUDIO) {
            s = s + "\t\tSamplingFrequency: " + this.audio.getSamplingFrequency() + "\n";
            if (this.audio.getOutputSamplingFrequency() != 0.0f) {
                s = s + "\t\tOutputSamplingFrequency: " + this.audio.getOutputSamplingFrequency() + "\n";
            }
            s = s + "\t\tChannels: " + this.audio.getChannels() + "\n";
            if (this.audio.getBitDepth() != 0) {
                s = s + "\t\tBitDepth: " + this.audio.getBitDepth() + "\n";
            }
        }
        return s;
    }

    static MatroskaFileTrack fromElement(Element level2, DataSource ioDS, EBMLReader reader) {
        Element level3 = ((MasterElement)level2).readNextChild(reader);
        Element level4 = null;
        MatroskaFileTrack track = new MatroskaFileTrack();
        LOG.debug("Reading track from doc!");
        while (level3 != null) {
            if (level3.isType(MatroskaDocTypes.TrackNumber.getType())) {
                level3.readData(ioDS);
                track.setTrackNo((int)((UnsignedIntegerElement)level3).getValue());
            } else if (level3.isType(MatroskaDocTypes.TrackUID.getType())) {
                level3.readData(ioDS);
                track.setTrackUID(((UnsignedIntegerElement)level3).getValue());
            } else if (level3.isType(MatroskaDocTypes.TrackType.getType())) {
                level3.readData(ioDS);
                track.setTrackType(TrackType.fromOrdinal(((UnsignedIntegerElement)level3).getValue()));
            } else if (level3.isType(MatroskaDocTypes.DefaultDuration.getType())) {
                level3.readData(ioDS);
                track.setDefaultDuration(((UnsignedIntegerElement)level3).getValue());
            } else if (level3.isType(MatroskaDocTypes.Name.getType())) {
                level3.readData(ioDS);
                track.setName(((StringElement)level3).getValue());
            } else if (level3.isType(MatroskaDocTypes.Language.getType())) {
                level3.readData(ioDS);
                track.setLanguage(((StringElement)level3).getValue());
            } else if (level3.isType(MatroskaDocTypes.CodecID.getType())) {
                level3.readData(ioDS);
                track.setCodecID(((StringElement)level3).getValue());
            } else if (level3.isType(MatroskaDocTypes.CodecPrivate.getType())) {
                level3.readData(ioDS);
                track.setCodecPrivate(((BinaryElement)level3).getData());
            } else if (level3.isType(MatroskaDocTypes.Video.getType())) {
                level4 = ((MasterElement)level3).readNextChild(reader);
                track.video = new MatroskaVideoTrack();
                while (level4 != null) {
                    if (level4.isType(MatroskaDocTypes.PixelWidth.getType())) {
                        level4.readData(ioDS);
                        track.video.setPixelWidth((short)((UnsignedIntegerElement)level4).getValue());
                    } else if (level4.isType(MatroskaDocTypes.PixelHeight.getType())) {
                        level4.readData(ioDS);
                        track.video.setPixelHeight((short)((UnsignedIntegerElement)level4).getValue());
                    } else if (level4.isType(MatroskaDocTypes.DisplayWidth.getType())) {
                        level4.readData(ioDS);
                        track.video.setDisplayWidth((short)((UnsignedIntegerElement)level4).getValue());
                    } else if (level4.isType(MatroskaDocTypes.DisplayHeight.getType())) {
                        level4.readData(ioDS);
                        track.video.setDisplayHeight((short)((UnsignedIntegerElement)level4).getValue());
                    }
                    level4.skipData(ioDS);
                    level4 = ((MasterElement)level3).readNextChild(reader);
                }
            } else if (level3.isType(MatroskaDocTypes.Audio.getType())) {
                level4 = ((MasterElement)level3).readNextChild(reader);
                track.audio = new MatroskaAudioTrack();
                while (level4 != null) {
                    if (level4.isType(MatroskaDocTypes.SamplingFrequency.getType())) {
                        level4.readData(ioDS);
                        track.audio.setSamplingFrequency((float)((FloatElement)level4).getValue());
                    } else if (level4.isType(MatroskaDocTypes.OutputSamplingFrequency.getType())) {
                        level4.readData(ioDS);
                        track.audio.setOutputSamplingFrequency((float)((FloatElement)level4).getValue());
                    } else if (level4.isType(MatroskaDocTypes.Channels.getType())) {
                        level4.readData(ioDS);
                        track.audio.setChannels((short)((UnsignedIntegerElement)level4).getValue());
                    } else if (level4.isType(MatroskaDocTypes.BitDepth.getType())) {
                        level4.readData(ioDS);
                        track.audio.setBitDepth((byte)((UnsignedIntegerElement)level4).getValue());
                    }
                    level4.skipData(ioDS);
                    level4 = ((MasterElement)level3).readNextChild(reader);
                }
            }
            level3.skipData(ioDS);
            level3 = ((MasterElement)level2).readNextChild(reader);
        }
        LOG.debug("Read track from doc!");
        return track;
    }

    Element toElement() {
        MasterElement trackEntryElem = MatroskaDocTypes.TrackEntry.getInstance();
        UnsignedIntegerElement trackNoElem = MatroskaDocTypes.TrackNumber.getInstance();
        trackNoElem.setValue(this.getTrackNo());
        UnsignedIntegerElement trackUIDElem = MatroskaDocTypes.TrackUID.getInstance();
        trackUIDElem.setValue(this.getTrackUID());
        UnsignedIntegerElement trackTypeElem = MatroskaDocTypes.TrackType.getInstance();
        trackTypeElem.setValue(this.getTrackType().type);
        LOG.info("Track type set to {}", (Object)this.getTrackType().type);
        UnsignedIntegerElement trackFlagEnabledElem = MatroskaDocTypes.FlagEnabled.getInstance();
        trackFlagEnabledElem.setValue(this.isFlagEnabled() ? 1L : 0L);
        UnsignedIntegerElement trackFlagDefaultElem = MatroskaDocTypes.FlagDefault.getInstance();
        trackFlagDefaultElem.setValue(this.isFlagDefault() ? 1L : 0L);
        UnsignedIntegerElement trackFlagForcedElem = MatroskaDocTypes.FlagForced.getInstance();
        trackFlagForcedElem.setValue(this.isFlagForced() ? 1L : 0L);
        UnsignedIntegerElement trackFlagLacingElem = MatroskaDocTypes.FlagLacing.getInstance();
        trackFlagLacingElem.setValue(this.isFlagLacing() ? 1L : 0L);
        UnsignedIntegerElement trackMinCacheElem = MatroskaDocTypes.MinCache.getInstance();
        trackMinCacheElem.setValue(this.getMinCache());
        UnsignedIntegerElement trackMaxBlockAddIdElem = MatroskaDocTypes.MaxBlockAdditionID.getInstance();
        trackMaxBlockAddIdElem.setValue(this.getMaxBlockAdditionalId());
        StringElement trackNameElem = MatroskaDocTypes.Name.getInstance();
        trackNameElem.setValue(this.getName());
        StringElement trackLangElem = MatroskaDocTypes.Language.getInstance();
        trackLangElem.setValue(this.getLanguage());
        StringElement trackCodecIDElem = MatroskaDocTypes.CodecID.getInstance();
        trackCodecIDElem.setValue(this.getCodecID());
        trackEntryElem.addChildElement(trackNoElem);
        trackEntryElem.addChildElement(trackUIDElem);
        trackEntryElem.addChildElement(trackTypeElem);
        trackEntryElem.addChildElement(trackFlagEnabledElem);
        trackEntryElem.addChildElement(trackFlagDefaultElem);
        trackEntryElem.addChildElement(trackFlagForcedElem);
        trackEntryElem.addChildElement(trackFlagLacingElem);
        trackEntryElem.addChildElement(trackMinCacheElem);
        trackEntryElem.addChildElement(trackMaxBlockAddIdElem);
        trackEntryElem.addChildElement(trackNameElem);
        trackEntryElem.addChildElement(trackLangElem);
        trackEntryElem.addChildElement(trackCodecIDElem);
        if (this.codecPrivate != null && this.codecPrivate.hasRemaining()) {
            BinaryElement trackCodecPrivateElem = MatroskaDocTypes.CodecPrivate.getInstance();
            trackCodecPrivateElem.setData(this.getCodecPrivate());
            trackEntryElem.addChildElement(trackCodecPrivateElem);
        }
        UnsignedIntegerElement trackDefaultDurationElem = MatroskaDocTypes.DefaultDuration.getInstance();
        trackDefaultDurationElem.setValue(this.getDefaultDuration());
        UnsignedIntegerElement trackCodecDecodeAllElem = MatroskaDocTypes.CodecDecodeAll.getInstance();
        trackCodecDecodeAllElem.setValue(this.codecDecodeAll ? 1L : 0L);
        trackEntryElem.addChildElement(trackDefaultDurationElem);
        trackEntryElem.addChildElement(trackCodecDecodeAllElem);
        if (!this.overlayUids.isEmpty()) {
            for (Long overlay : this.overlayUids) {
                UnsignedIntegerElement trackOverlayElem = MatroskaDocTypes.TrackOverlay.getInstance();
                trackOverlayElem.setValue(overlay);
                trackEntryElem.addChildElement(trackOverlayElem);
            }
        }
        if (this.getTrackType() == TrackType.VIDEO) {
            MasterElement trackVideoElem = MatroskaDocTypes.Video.getInstance();
            UnsignedIntegerElement trackVideoPixelWidthElem = MatroskaDocTypes.PixelWidth.getInstance();
            trackVideoPixelWidthElem.setValue(this.video.getPixelWidth());
            UnsignedIntegerElement trackVideoPixelHeightElem = MatroskaDocTypes.PixelHeight.getInstance();
            trackVideoPixelHeightElem.setValue(this.video.getPixelHeight());
            UnsignedIntegerElement trackVideoDisplayWidthElem = MatroskaDocTypes.DisplayWidth.getInstance();
            trackVideoDisplayWidthElem.setValue(this.video.getDisplayWidth());
            UnsignedIntegerElement trackVideoDisplayHeightElem = MatroskaDocTypes.DisplayHeight.getInstance();
            trackVideoDisplayHeightElem.setValue(this.video.getDisplayHeight());
            trackVideoElem.addChildElement(trackVideoPixelWidthElem);
            trackVideoElem.addChildElement(trackVideoPixelHeightElem);
            trackVideoElem.addChildElement(trackVideoDisplayWidthElem);
            trackVideoElem.addChildElement(trackVideoDisplayHeightElem);
            trackEntryElem.addChildElement(trackVideoElem);
        } else if (this.getTrackType() == TrackType.AUDIO) {
            MasterElement trackAudioElem = MatroskaDocTypes.Audio.getInstance();
            UnsignedIntegerElement trackAudioChannelsElem = MatroskaDocTypes.Channels.getInstance();
            trackAudioChannelsElem.setValue(this.audio.getChannels());
            UnsignedIntegerElement trackAudioBitDepthElem = MatroskaDocTypes.BitDepth.getInstance();
            trackAudioBitDepthElem.setValue(this.audio.getBitDepth());
            FloatElement trackAudioSamplingRateElem = MatroskaDocTypes.SamplingFrequency.getInstance();
            trackAudioSamplingRateElem.setValue(this.audio.getSamplingFrequency());
            FloatElement trackAudioOutputSamplingFrequencyElem = MatroskaDocTypes.OutputSamplingFrequency.getInstance();
            trackAudioOutputSamplingFrequencyElem.setValue(this.audio.getOutputSamplingFrequency());
            trackAudioElem.addChildElement(trackAudioChannelsElem);
            trackAudioElem.addChildElement(trackAudioBitDepthElem);
            trackAudioElem.addChildElement(trackAudioSamplingRateElem);
            trackAudioElem.addChildElement(trackAudioOutputSamplingFrequencyElem);
            trackEntryElem.addChildElement(trackAudioElem);
        }
        if (this.operation != null) {
            MasterElement trackOpElem = MatroskaDocTypes.TrackOperation.getInstance();
            MasterElement trackJoinElem = MatroskaDocTypes.TrackJoinBlocks.getInstance();
            for (Long uid : this.operation.joinUIDs) {
                UnsignedIntegerElement joinUidElem = MatroskaDocTypes.TrackJoinUID.getInstance();
                joinUidElem.setValue(uid);
                trackJoinElem.addChildElement(joinUidElem);
            }
            trackOpElem.addChildElement(trackJoinElem);
            trackEntryElem.addChildElement(trackOpElem);
        }
        return trackEntryElem;
    }

    public int getTrackNo() {
        return this.trackNo;
    }

    public void setTrackNo(int trackNo) {
        this.trackNo = trackNo;
    }

    public long getTrackUID() {
        return this.trackUID;
    }

    public void setTrackUID(long trackUID) {
        this.trackUID = trackUID;
    }

    public TrackType getTrackType() {
        return this.trackType;
    }

    public void setTrackType(TrackType trackType) {
        this.trackType = trackType;
    }

    public boolean isFlagEnabled() {
        return this.flagEnabled;
    }

    public void setFlagEnabled(boolean flagEnabled) {
        this.flagEnabled = flagEnabled;
    }

    public boolean isFlagDefault() {
        return this.flagDefault;
    }

    public void setFlagDefault(boolean flagDefault) {
        this.flagDefault = flagDefault;
    }

    public boolean isFlagForced() {
        return this.flagForced;
    }

    public void setFlagForced(boolean flagForced) {
        this.flagForced = flagForced;
    }

    public boolean isFlagLacing() {
        return this.flagLacing;
    }

    public void setFlagLacing(boolean flagLacing) {
        this.flagLacing = flagLacing;
    }

    public int getMinCache() {
        return this.minCache;
    }

    public void setMinCache(int minCache) {
        this.minCache = minCache;
    }

    public int getMaxBlockAdditionalId() {
        return this.maxBlockAdditionalId;
    }

    public void setMaxBlockAdditionalId(int maxBlockAdditionalId) {
        this.maxBlockAdditionalId = maxBlockAdditionalId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getCodecID() {
        return this.codecID;
    }

    public void setCodecID(String codecID) {
        this.codecID = codecID;
    }

    public ByteBuffer getCodecPrivate() {
        return this.codecPrivate;
    }

    public void setCodecPrivate(ByteBuffer codecPrivate) {
        this.codecPrivate = codecPrivate;
    }

    public long getDefaultDuration() {
        return this.defaultDuration;
    }

    public void setDefaultDuration(long defaultDuration) {
        this.defaultDuration = defaultDuration;
    }

    public boolean isCodecDecodeAll() {
        return this.codecDecodeAll;
    }

    public void setCodecDecodeAll(boolean codecDecodeAll) {
        this.codecDecodeAll = codecDecodeAll;
    }

    public int getSeekPreroll() {
        return this.seekPreroll;
    }

    public void setSeekPreroll(int seekPreroll) {
        this.seekPreroll = seekPreroll;
    }

    public MatroskaVideoTrack getVideo() {
        return this.video;
    }

    public void setVideo(MatroskaVideoTrack video) {
        this.video = video;
    }

    public MatroskaAudioTrack getAudio() {
        return this.audio;
    }

    public void setAudio(MatroskaAudioTrack audio) {
        this.audio = audio;
    }

    public TrackOperation getOperation() {
        return this.operation;
    }

    public void setOperation(TrackOperation operation) {
        this.operation = operation;
    }

    public void addTrackOverlay(long overlay) {
        this.overlayUids.add(overlay);
    }

    public static class TrackOperation {
        private final ArrayList<Long> joinUIDs = new ArrayList();

        public void addVirtualTrackPart(long uid) {
            this.joinUIDs.add(uid);
        }
    }

    public static class MatroskaAudioTrack {
        private float samplingFrequency;
        private float outputSamplingFrequency;
        private short channels;
        private byte bitDepth;

        public float getSamplingFrequency() {
            return this.samplingFrequency;
        }

        public void setSamplingFrequency(float samplingFrequency) {
            this.samplingFrequency = samplingFrequency;
        }

        public float getOutputSamplingFrequency() {
            return this.outputSamplingFrequency;
        }

        public void setOutputSamplingFrequency(float outputSamplingFrequency) {
            this.outputSamplingFrequency = outputSamplingFrequency;
        }

        public short getChannels() {
            return this.channels;
        }

        public void setChannels(short channels) {
            this.channels = channels;
        }

        public byte getBitDepth() {
            return this.bitDepth;
        }

        public void setBitDepth(int bitDepth) {
            this.bitDepth = (byte)bitDepth;
        }
    }

    public static class MatroskaVideoTrack {
        private short pixelWidth;
        private short pixelHeight;
        private short displayWidth = 0;
        private short displayHeight = 0;

        public short getPixelWidth() {
            return this.pixelWidth;
        }

        public void setPixelWidth(short pixelWidth) {
            this.pixelWidth = pixelWidth;
        }

        public short getPixelHeight() {
            return this.pixelHeight;
        }

        public void setPixelHeight(short pixelHeight) {
            this.pixelHeight = pixelHeight;
        }

        public short getDisplayWidth() {
            return this.displayWidth;
        }

        public void setDisplayWidth(short displayWidth) {
            this.displayWidth = displayWidth;
        }

        public short getDisplayHeight() {
            return this.displayHeight;
        }

        public void setDisplayHeight(short displayHeight) {
            this.displayHeight = displayHeight;
        }
    }

    public static enum TrackType {
        VIDEO(1),
        AUDIO(2),
        COMPLEX(3),
        LOGO(16),
        SUBTITLE(17),
        BUTTONS(18),
        CONTROL(32);

        final byte type;

        private TrackType(int type) {
            this.type = (byte)type;
        }

        public static TrackType fromOrdinal(long l) {
            LOG.debug("Track type from ordinal: {}", (Object)l);
            switch ((int)l) {
                case 1: {
                    return VIDEO;
                }
                case 2: {
                    return AUDIO;
                }
                case 3: {
                    return COMPLEX;
                }
                case 16: {
                    return LOGO;
                }
                case 17: {
                    return SUBTITLE;
                }
                case 18: {
                    return BUTTONS;
                }
                case 32: {
                    return CONTROL;
                }
            }
            return null;
        }
    }
}

