/*
 * Decompiled with CFR 0.152.
 */
package org.ebml.matroska;

import java.nio.ByteBuffer;
import org.ebml.BinaryElement;
import org.ebml.Element;
import org.ebml.MasterElement;
import org.ebml.UnsignedIntegerElement;
import org.ebml.io.DataWriter;
import org.ebml.matroska.MatroskaDocTypes;
import org.ebml.matroska.VoidElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatroskaFileMetaSeek {
    private static final Logger LOG = LoggerFactory.getLogger(MatroskaFileMetaSeek.class);
    private static final long BLOCK_RESERVE_SIZE = 256L;
    private final long myPosition;
    private final MasterElement seekHeadElem;
    private final VoidElement placeHolderElem;
    private final long referencePosition;

    public MatroskaFileMetaSeek(long referencePosition) {
        this.referencePosition = referencePosition;
        this.myPosition = referencePosition;
        this.seekHeadElem = MatroskaDocTypes.SeekHead.getInstance();
        this.placeHolderElem = new VoidElement(256L - this.seekHeadElem.getTotalSize());
    }

    public long write(DataWriter ioDW) {
        long elemLen = this.seekHeadElem.writeElement(ioDW);
        long voidLen = this.placeHolderElem.writeElement(ioDW);
        assert (elemLen + voidLen == 256L);
        return 256L;
    }

    public void update(DataWriter ioDW) {
        assert (ioDW.isSeekable());
        long pos = ioDW.getFilePointer();
        ioDW.seek(this.myPosition);
        this.write(ioDW);
        ioDW.seek(pos);
        LOG.debug("Updated metaseek section.");
    }

    public void addIndexedElement(Element element, long filePosition) {
        LOG.debug("Adding indexed element {} @ {}", (Object)element.getElementType().getName(), (Object)(filePosition - this.referencePosition));
        this.addIndexedElement(element.getType(), filePosition);
    }

    public void addIndexedElement(ByteBuffer elementType, long filePosition) {
        LOG.debug("Adding indexed element @ {}", (Object)(filePosition - this.referencePosition));
        MasterElement seekEntryElem = MatroskaDocTypes.Seek.getInstance();
        BinaryElement seekEntryIdElem = MatroskaDocTypes.SeekID.getInstance();
        seekEntryIdElem.setData(elementType);
        UnsignedIntegerElement seekEntryPosElem = MatroskaDocTypes.SeekPosition.getInstance();
        seekEntryPosElem.setValue(filePosition - this.referencePosition);
        seekEntryElem.addChildElement(seekEntryIdElem);
        seekEntryElem.addChildElement(seekEntryPosElem);
        this.seekHeadElem.addChildElement(seekEntryElem);
        this.placeHolderElem.setSize(256L - this.seekHeadElem.getTotalSize());
    }
}

