/*
 * Decompiled with CFR 0.152.
 */
package org.ebml.matroska;

import java.util.Collection;
import org.ebml.Element;
import org.ebml.MasterElement;
import org.ebml.UnsignedIntegerElement;
import org.ebml.io.DataWriter;
import org.ebml.matroska.MatroskaDocTypes;
import org.ebml.matroska.MatroskaFileMetaSeek;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatroskaFileCues {
    private static final Logger LOG = LoggerFactory.getLogger(MatroskaFileCues.class);
    private MasterElement cues = MatroskaDocTypes.Cues.getInstance();
    private long endOfEbmlHeaderBytePosition;

    public MatroskaFileCues(long endOfEbmlHeaderBytePosition) {
        this.endOfEbmlHeaderBytePosition = endOfEbmlHeaderBytePosition;
    }

    public void addCue(long positionInFile, long timecodeOfCluster, Collection<Integer> clusterTrackNumbers) {
        LOG.debug("Adding matroska cue to cues element at position [{}], using timecode [{}], for track numbers [{}]", positionInFile, timecodeOfCluster, clusterTrackNumbers);
        UnsignedIntegerElement cueTime = MatroskaDocTypes.CueTime.getInstance();
        cueTime.setValue(timecodeOfCluster);
        MasterElement cuePoint = MatroskaDocTypes.CuePoint.getInstance();
        MasterElement cueTrackPositions = this.createCueTrackPositions(positionInFile, clusterTrackNumbers);
        this.cues.addChildElement(cuePoint);
        cuePoint.addChildElement(cueTime);
        cuePoint.addChildElement(cueTrackPositions);
        LOG.debug("Finished adding matroska cue to cues element");
    }

    private MasterElement createCueTrackPositions(long positionInFile, Collection<Integer> trackNumbers) {
        MasterElement cueTrackPositions = MatroskaDocTypes.CueTrackPositions.getInstance();
        for (Integer trackNumber : trackNumbers) {
            UnsignedIntegerElement cueTrack = MatroskaDocTypes.CueTrack.getInstance();
            cueTrack.setValue(trackNumber.intValue());
            UnsignedIntegerElement cueClusterPosition = MatroskaDocTypes.CueClusterPosition.getInstance();
            cueClusterPosition.setValue(this.getPositionRelativeToSegmentEbmlElement(positionInFile));
            cueTrackPositions.addChildElement(cueTrack);
            cueTrackPositions.addChildElement(cueClusterPosition);
        }
        return cueTrackPositions;
    }

    public Element write(DataWriter ioDW, MatroskaFileMetaSeek metaSeek) {
        long currentBytePositionInFile = ioDW.getFilePointer();
        LOG.debug("Writing matroska cues at file byte position [{}]", (Object)currentBytePositionInFile);
        long numberOfBytesInCueData = this.cues.writeElement(ioDW);
        LOG.debug("Done writing matroska cues, number of bytes was [{}]", (Object)numberOfBytesInCueData);
        metaSeek.addIndexedElement(this.cues, this.getPositionRelativeToSegmentEbmlElement(currentBytePositionInFile));
        return this.cues;
    }

    private long getPositionRelativeToSegmentEbmlElement(long currentBytePositionInFile) {
        return currentBytePositionInFile - this.endOfEbmlHeaderBytePosition;
    }
}

