/*
 * Decompiled with CFR 0.152.
 */
package org.ebml.matroska;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.ebml.DateElement;
import org.ebml.EBMLReader;
import org.ebml.Element;
import org.ebml.FloatElement;
import org.ebml.MasterElement;
import org.ebml.SignedIntegerElement;
import org.ebml.StringElement;
import org.ebml.UnsignedIntegerElement;
import org.ebml.io.DataSource;
import org.ebml.matroska.MatroskaBlock;
import org.ebml.matroska.MatroskaDocTypes;
import org.ebml.matroska.MatroskaFileFrame;
import org.ebml.matroska.MatroskaFileSimpleTag;
import org.ebml.matroska.MatroskaFileTagEntry;
import org.ebml.matroska.MatroskaFileTrack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatroskaFile {
    public static final int CLUSTER_TRACK_SEARCH_COUNT = 4;
    protected static final Logger LOG = LoggerFactory.getLogger(MatroskaFile.class);
    private final DataSource ioDS;
    private final EBMLReader reader;
    private Element level0 = null;
    private String segmentTitle;
    private Date segmentDate;
    private String muxingApp;
    private String writingApp;
    private long timecodeScale = 1000000L;
    private double duration;
    private final ArrayList<MatroskaFileTrack> trackList = new ArrayList();
    private final ArrayList<MatroskaFileTagEntry> tagList = new ArrayList();
    private final Queue<MatroskaFileFrame> frameQueue = new ConcurrentLinkedQueue<MatroskaFileFrame>();
    private boolean scanFirstCluster = true;

    public MatroskaFile(DataSource inputDataSource) {
        this.ioDS = inputDataSource;
        this.reader = new EBMLReader(this.ioDS);
    }

    public void readFile() {
        Element level1 = null;
        Element level2 = null;
        this.level0 = this.reader.readNextElement();
        if (this.level0 == null) {
            throw new RuntimeException("Error: Unable to scan for EBML elements");
        }
        if (this.level0.isType(MatroskaDocTypes.EBML.getType())) {
            level1 = ((MasterElement)this.level0).readNextChild(this.reader);
            while (level1 != null) {
                String docType;
                level1.readData(this.ioDS);
                if (level1.isType(MatroskaDocTypes.DocType.getType()) && (docType = ((StringElement)level1).getValue()).compareTo("matroska") != 0 && docType.compareTo("webm") != 0) {
                    throw new RuntimeException("Error: DocType is not matroska, \"" + ((StringElement)level1).getValue() + "\"");
                }
                level1 = ((MasterElement)this.level0).readNextChild(this.reader);
            }
        } else {
            throw new RuntimeException("Error: EBML Header not the first element in the file");
        }
        this.level0 = this.reader.readNextElement();
        if (this.level0.isType(MatroskaDocTypes.Segment.getType())) {
            level1 = ((MasterElement)this.level0).readNextChild(this.reader);
            LOG.debug("Got segment element");
            while (level1 != null) {
                LOG.debug("Got {} element in segment", (Object)level1.getElementType().getName());
                if (level1.isType(MatroskaDocTypes.Info.getType())) {
                    this.parseSegmentInfo(level1, level2);
                } else if (level1.isType(MatroskaDocTypes.Tracks.getType())) {
                    this.parseTracks(level1, level2);
                } else {
                    if (level1.isType(MatroskaDocTypes.Cluster.getType())) {
                        if (this.scanFirstCluster) {
                            this.parseNextCluster(level1);
                        }
                        break;
                    }
                    if (level1.isType(MatroskaDocTypes.Tags.getType())) {
                        this.parseTags(level1, level2);
                    }
                }
                level1.skipData(this.ioDS);
                level1 = ((MasterElement)this.level0).readNextChild(this.reader);
            }
        } else {
            throw new RuntimeException(String.format("Error: Segment not the second element in the file: was %s instead", this.level0.getElementType().getName()));
        }
    }

    public MatroskaFileFrame getNextFrame() {
        if (this.frameQueue.isEmpty()) {
            this.fillFrameQueue();
        }
        if (this.frameQueue.isEmpty()) {
            return null;
        }
        return this.frameQueue.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MatroskaFileFrame getNextFrame(int trackNo) {
        if (this.frameQueue.isEmpty()) {
            this.fillFrameQueue();
        }
        if (this.frameQueue.isEmpty()) {
            return null;
        }
        int tryCount = 0;
        MatroskaFileFrame frame = null;
        try {
            Iterator iter = this.frameQueue.iterator();
            while (frame == null) {
                if (iter.hasNext()) {
                    frame = (MatroskaFileFrame)iter.next();
                    if (frame.getTrackNo() == trackNo) {
                        Queue<MatroskaFileFrame> queue = this.frameQueue;
                        synchronized (queue) {
                            iter.remove();
                        }
                        return frame;
                    }
                    frame = null;
                    continue;
                }
                this.fillFrameQueue();
                if (++tryCount <= 4) continue;
                return null;
            }
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            return null;
        }
        return frame;
    }

    public boolean isSeekable() {
        return this.ioDS.isSeekable();
    }

    public long seek(long timecode) {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillFrameQueue() {
        if (this.level0 == null) {
            throw new IllegalStateException("Call readFile() before reading frames");
        }
        Element element = this.level0;
        synchronized (element) {
            Element level1 = ((MasterElement)this.level0).readNextChild(this.reader);
            while (level1 != null) {
                if (level1.isType(MatroskaDocTypes.Cluster.getType())) {
                    this.parseNextCluster(level1);
                }
                level1.skipData(this.ioDS);
                level1 = ((MasterElement)this.level0).readNextChild(this.reader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseNextCluster(Element level1) {
        Element level2 = null;
        Element level3 = null;
        long clusterTimecode = 0L;
        level2 = ((MasterElement)level1).readNextChild(this.reader);
        while (level2 != null) {
            if (level2.isType(MatroskaDocTypes.Timecode.getType())) {
                level2.readData(this.ioDS);
                clusterTimecode = ((UnsignedIntegerElement)level2).getValue();
            } else if (level2.isType(MatroskaDocTypes.SimpleBlock.getType())) {
                level2.readData(this.ioDS);
                MatroskaBlock block = null;
                long blockDuration = 0L;
                block = new MatroskaBlock(level2.getData());
                block.parseBlock();
                MatroskaFileFrame frame = new MatroskaFileFrame();
                frame.setTrackNo(block.getTrackNo());
                frame.setTimecode(block.getAdjustedBlockTimecode(clusterTimecode, this.timecodeScale));
                frame.setDuration(0L);
                frame.setData(block.getFrame(0));
                frame.setKeyFrame(block.isKeyFrame());
                Queue<MatroskaFileFrame> queue = this.frameQueue;
                synchronized (queue) {
                    this.frameQueue.add(new MatroskaFileFrame(frame));
                }
                if (block.getFrameCount() > 1) {
                    for (int f = 1; f < block.getFrameCount(); ++f) {
                        frame.setData(block.getFrame(f));
                        this.frameQueue.add(new MatroskaFileFrame(frame));
                    }
                }
                level2.skipData(this.ioDS);
            } else if (level2.isType(MatroskaDocTypes.BlockGroup.getType())) {
                long blockDuration = 0L;
                long blockReference = 0L;
                level3 = ((MasterElement)level2).readNextChild(this.reader);
                MatroskaBlock block = null;
                while (level3 != null) {
                    if (level3.isType(MatroskaDocTypes.Block.getType())) {
                        level3.readData(this.ioDS);
                        block = new MatroskaBlock(level3.getData());
                        block.parseBlock();
                    } else if (level3.isType(MatroskaDocTypes.BlockDuration.getType())) {
                        level3.readData(this.ioDS);
                        blockDuration = ((UnsignedIntegerElement)level3).getValue();
                    } else if (level3.isType(MatroskaDocTypes.ReferenceBlock.getType())) {
                        level3.readData(this.ioDS);
                        blockReference = ((SignedIntegerElement)level3).getValue();
                    }
                    level3.skipData(this.ioDS);
                    level3 = ((MasterElement)level2).readNextChild(this.reader);
                }
                if (block == null) {
                    throw new NullPointerException("BlockGroup element with no child Block!");
                }
                MatroskaFileFrame frame = new MatroskaFileFrame();
                frame.setTrackNo(block.getTrackNo());
                frame.setTimecode(block.getAdjustedBlockTimecode(clusterTimecode, this.timecodeScale));
                frame.setDuration(blockDuration);
                frame.addReferences(blockReference);
                frame.setData(block.getFrame(0));
                this.frameQueue.add(new MatroskaFileFrame(frame));
                if (block.getFrameCount() > 1) {
                    for (int f = 1; f < block.getFrameCount(); ++f) {
                        frame.setData(block.getFrame(f));
                        this.frameQueue.add(new MatroskaFileFrame(frame));
                    }
                }
            }
            level2.skipData(this.ioDS);
            level2 = ((MasterElement)level1).readNextChild(this.reader);
        }
    }

    protected boolean badMP3Headers() {
        Iterator iter = this.frameQueue.iterator();
        while (iter.hasNext()) {
            MatroskaFileFrame frame = (MatroskaFileFrame)iter.next();
            if (frame.getTrackNo() != 2 || frame.getData().get(3) == 84) continue;
            throw new RuntimeException("Bad MP3 Header! Index: " + iter);
        }
        return false;
    }

    private void parseSegmentInfo(Element level1, Element level2) {
        level2 = ((MasterElement)level1).readNextChild(this.reader);
        while (level2 != null) {
            if (level2.isType(MatroskaDocTypes.Title.getType())) {
                level2.readData(this.ioDS);
                this.segmentTitle = ((StringElement)level2).getValue();
            } else if (level2.isType(MatroskaDocTypes.DateUTC.getType())) {
                level2.readData(this.ioDS);
                this.segmentDate = ((DateElement)level2).getDate();
            } else if (level2.isType(MatroskaDocTypes.MuxingApp.getType())) {
                level2.readData(this.ioDS);
                this.muxingApp = ((StringElement)level2).getValue();
            } else if (level2.isType(MatroskaDocTypes.WritingApp.getType())) {
                level2.readData(this.ioDS);
                this.writingApp = ((StringElement)level2).getValue();
            } else if (level2.isType(MatroskaDocTypes.Duration.getType())) {
                level2.readData(this.ioDS);
                this.duration = ((FloatElement)level2).getValue();
            } else if (level2.isType(MatroskaDocTypes.TimecodeScale.getType())) {
                level2.readData(this.ioDS);
                this.timecodeScale = ((UnsignedIntegerElement)level2).getValue();
            }
            level2.skipData(this.ioDS);
            level2 = ((MasterElement)level1).readNextChild(this.reader);
        }
    }

    private void parseTracks(Element level1, Element level2) {
        level2 = ((MasterElement)level1).readNextChild(this.reader);
        while (level2 != null) {
            if (level2.isType(MatroskaDocTypes.TrackEntry.getType())) {
                this.trackList.add(MatroskaFileTrack.fromElement(level2, this.ioDS, this.reader));
            }
            level2.skipData(this.ioDS);
            level2 = ((MasterElement)level1).readNextChild(this.reader);
        }
    }

    private void parseTags(Element level1, Element level2) {
        Element level3 = null;
        Element level4 = null;
        level2 = ((MasterElement)level1).readNextChild(this.reader);
        while (level2 != null) {
            if (level2.isType(MatroskaDocTypes.Tag.getType())) {
                MatroskaFileTagEntry tag = new MatroskaFileTagEntry();
                level3 = ((MasterElement)level2).readNextChild(this.reader);
                while (level3 != null) {
                    if (level3.isType(MatroskaDocTypes.Targets.getType())) {
                        level4 = ((MasterElement)level3).readNextChild(this.reader);
                        while (level4 != null) {
                            if (level4.isType(MatroskaDocTypes.TagTrackUID.getType())) {
                                level4.readData(this.ioDS);
                                tag.trackUID.add(new Long(((UnsignedIntegerElement)level4).getValue()));
                            } else if (level4.isType(MatroskaDocTypes.TagChapterUID.getType())) {
                                level4.readData(this.ioDS);
                                tag.chapterUID.add(new Long(((UnsignedIntegerElement)level4).getValue()));
                            } else if (level4.isType(MatroskaDocTypes.TagAttachmentUID.getType())) {
                                level4.readData(this.ioDS);
                                tag.attachmentUID.add(new Long(((UnsignedIntegerElement)level4).getValue()));
                            }
                            level4.skipData(this.ioDS);
                            level4 = ((MasterElement)level3).readNextChild(this.reader);
                        }
                    } else if (level3.isType(MatroskaDocTypes.SimpleTag.getType())) {
                        tag.simpleTags.add(this.parseTagsSimpleTag(level3, level4));
                    }
                    level3.skipData(this.ioDS);
                    level3 = ((MasterElement)level2).readNextChild(this.reader);
                }
                this.tagList.add(tag);
            }
            level2.skipData(this.ioDS);
            level2 = ((MasterElement)level1).readNextChild(this.reader);
        }
    }

    private MatroskaFileSimpleTag parseTagsSimpleTag(Element level3, Element level4) {
        MatroskaFileSimpleTag simpleTag = new MatroskaFileSimpleTag();
        level4 = ((MasterElement)level3).readNextChild(this.reader);
        while (level4 != null) {
            if (level4.isType(MatroskaDocTypes.TagName.getType())) {
                level4.readData(this.ioDS);
                simpleTag.name = ((StringElement)level4).getValue();
            } else if (level4.isType(MatroskaDocTypes.TagString.getType())) {
                level4.readData(this.ioDS);
                simpleTag.value = ((StringElement)level4).getValue();
            }
            level4.skipData(this.ioDS);
            level4 = ((MasterElement)level3).readNextChild(this.reader);
        }
        return simpleTag;
    }

    public String getReport() {
        int t;
        StringWriter s = new StringWriter();
        s.write("MatroskaFile report\n");
        s.write("Infomation Segment \n");
        s.write("\tSegment Title: " + this.segmentTitle + "\n");
        s.write("\tSegment Date: " + this.segmentDate + "\n");
        s.write("\tMuxing App : " + this.muxingApp + "\n");
        s.write("\tWriting App : " + this.writingApp + "\n");
        s.write("\tDuration : " + this.duration / 1000.0 + "sec \n");
        s.write("\tTimecodeScale : " + this.timecodeScale + "\n");
        s.write("Track Count: " + this.trackList.size() + "\n");
        for (t = 0; t < this.trackList.size(); ++t) {
            s.write("\tTrack " + t + "\n");
            s.write(this.trackList.get(t).toString());
        }
        s.write("Tag Count: " + this.tagList.size() + "\n");
        for (t = 0; t < this.tagList.size(); ++t) {
            s.write("\tTag Entry \n");
            s.write(this.tagList.get(t).toString());
        }
        s.write("End report\n");
        return s.getBuffer().toString();
    }

    public String getWritingApp() {
        return this.writingApp;
    }

    public MatroskaFileTrack[] getTrackList() {
        if (this.trackList.size() > 0) {
            MatroskaFileTrack[] tracks = new MatroskaFileTrack[this.trackList.size()];
            for (int t = 0; t < this.trackList.size(); ++t) {
                tracks[t] = this.trackList.get(t);
            }
            return tracks;
        }
        return new MatroskaFileTrack[0];
    }

    public MatroskaFileTrack getTrack(int trackNo) {
        for (int t = 0; t < this.trackList.size(); ++t) {
            MatroskaFileTrack track = this.trackList.get(t);
            if (track.getTrackNo() != trackNo) continue;
            return track;
        }
        return null;
    }

    public long getTimecodeScale() {
        return this.timecodeScale;
    }

    public String getSegmentTitle() {
        return this.segmentTitle;
    }

    public String getMuxingApp() {
        return this.muxingApp;
    }

    public double getDuration() {
        return this.duration;
    }

    public void setScanFirstCluster(boolean scanFirstCluster) {
        this.scanFirstCluster = scanFirstCluster;
    }

    public boolean getScanFirstCluster() {
        return this.scanFirstCluster;
    }

    static {
        MatroskaDocTypes.Void.getLevel();
    }
}

