/*
 * Decompiled with CFR 0.152.
 */
package org.ebml.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.ebml.io.DataWriter;

public class FileDataWriter
implements DataWriter {
    RandomAccessFile file = null;
    FileChannel fc = null;

    public FileDataWriter(String filename) throws FileNotFoundException, IOException {
        this.file = new RandomAccessFile(filename, "rw");
        this.fc = this.file.getChannel();
    }

    public FileDataWriter(String filename, String mode) throws FileNotFoundException, IOException {
        this.file = new RandomAccessFile(filename, mode);
        this.fc = this.file.getChannel();
    }

    @Override
    public int write(byte b) {
        try {
            this.file.write(b);
            return 1;
        }
        catch (IOException ex) {
            return 0;
        }
    }

    @Override
    public int write(ByteBuffer buff) {
        try {
            return this.fc.write(buff);
        }
        catch (IOException ex) {
            return 0;
        }
    }

    @Override
    public long length() {
        try {
            return this.file.length();
        }
        catch (IOException ex) {
            return -1L;
        }
    }

    @Override
    public long getFilePointer() {
        try {
            return this.file.getFilePointer();
        }
        catch (IOException ex) {
            return -1L;
        }
    }

    @Override
    public boolean isSeekable() {
        return true;
    }

    @Override
    public long seek(long pos) {
        try {
            this.file.seek(pos);
            return this.file.getFilePointer();
        }
        catch (IOException ex) {
            return -1L;
        }
    }

    public void close() throws IOException {
        this.file.close();
    }
}

