/*
 * Decompiled with CFR 0.152.
 */
package org.ebml.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.ebml.io.DataSource;

public class FileDataSource
implements DataSource,
AutoCloseable {
    RandomAccessFile file = null;
    FileChannel fc = null;

    public FileDataSource(String filename) throws FileNotFoundException, IOException {
        this.file = new RandomAccessFile(filename, "r");
        this.fc = this.file.getChannel();
    }

    public FileDataSource(String filename, String mode) throws FileNotFoundException, IOException {
        this.file = new RandomAccessFile(filename, mode);
        this.fc = this.file.getChannel();
    }

    @Override
    public byte readByte() {
        try {
            return this.file.readByte();
        }
        catch (IOException ex) {
            return 0;
        }
    }

    @Override
    public int read(ByteBuffer buff) {
        try {
            return this.fc.read(buff);
        }
        catch (IOException ex) {
            return 0;
        }
    }

    @Override
    public long skip(long offset) {
        try {
            return this.file.skipBytes((int)offset);
        }
        catch (IOException ex) {
            return 0L;
        }
    }

    @Override
    public long length() {
        try {
            return this.file.length();
        }
        catch (IOException ex) {
            return -1L;
        }
    }

    @Override
    public long getFilePointer() {
        try {
            return this.file.getFilePointer();
        }
        catch (IOException ex) {
            return -1L;
        }
    }

    @Override
    public boolean isSeekable() {
        return true;
    }

    @Override
    public long seek(long pos) {
        try {
            this.file.seek(pos);
            return this.file.getFilePointer();
        }
        catch (IOException ex) {
            return -1L;
        }
    }

    @Override
    public void close() throws IOException {
        this.fc.close();
        this.file.close();
    }
}

