/*
 * Decompiled with CFR 0.152.
 */
package org.ebml;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.ebml.BinaryElement;

public class StringElement
extends BinaryElement {
    private Charset charset = StandardCharsets.US_ASCII;

    public StringElement(byte[] typeID) {
        super(typeID);
    }

    public StringElement() {
    }

    public StringElement(byte[] typeID, Charset encoding) {
        super(typeID);
        this.charset = encoding;
    }

    public StringElement(Charset encoding) {
        this.charset = encoding;
    }

    public String getValue() {
        return new String(this.data.array(), this.charset);
    }

    public void setValue(String value) {
        this.setData(ByteBuffer.wrap(value.getBytes(this.charset)));
    }

    public Charset getEncoding() {
        return this.charset;
    }
}

