/*
 * Decompiled with CFR 0.152.
 */
package org.ebml;

import java.util.ArrayList;
import org.ebml.EBMLReader;
import org.ebml.Element;
import org.ebml.io.DataSource;
import org.ebml.io.DataWriter;

public class MasterElement
extends Element {
    protected long usedSize = 0L;
    protected ArrayList<Element> children = new ArrayList();

    public MasterElement(byte[] type) {
        super(type);
    }

    public MasterElement() {
    }

    public Element readNextChild(EBMLReader reader) {
        if (this.usedSize >= this.getSize()) {
            LOG.trace("Can't read any more children");
            return null;
        }
        Element elem = reader.readNextElement();
        if (elem == null) {
            LOG.debug("Reader returned null");
            return null;
        }
        elem.setParent(this);
        this.usedSize += elem.getTotalSize();
        LOG.trace("Read element {} of size {}: {} remaining", elem.typeInfo.getName(), elem.getTotalSize(), this.size - this.usedSize);
        return elem;
    }

    @Override
    public void skipData(DataSource source) {
        source.skip(this.size - this.usedSize);
    }

    @Override
    public long writeData(DataWriter writer) {
        long len = 0L;
        for (int i = 0; i < this.children.size(); ++i) {
            Element elem = this.children.get(i);
            len += elem.writeElement(writer);
        }
        return len;
    }

    public void addChildElement(Element elem) {
        this.children.add(elem);
        this.size += elem.getTotalSize();
    }
}

