/*
 * Decompiled with CFR 0.152.
 */
package org.ebml;

import java.nio.ByteBuffer;
import org.ebml.Element;
import org.ebml.ProtoType;
import org.ebml.io.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EBMLReader {
    private static final Logger LOG = LoggerFactory.getLogger(EBMLReader.class);
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    protected DataSource source;

    public EBMLReader(DataSource source) {
        this.source = source;
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public Element readNextElement() {
        long position = this.source.getFilePointer();
        ByteBuffer elementType = EBMLReader.readEBMLCodeAsBytes(this.source);
        if (elementType == null) {
            return null;
        }
        Element elem = ProtoType.getInstance(elementType);
        if (elem == null) {
            return null;
        }
        LOG.trace("Read element {}", (Object)elem.getElementType().getName());
        long elementSize = EBMLReader.readEBMLCode(this.source);
        if (elementSize == 0L) {
            LOG.error("Invalid element size for {}", (Object)elem.typeInfo.getName());
        }
        long end = this.source.getFilePointer();
        elem.setSize(elementSize);
        elem.setHeadersSize(end - position);
        LOG.trace("Read element {} with size {}", (Object)elem.typeInfo.getName(), (Object)elem.getTotalSize());
        return elem;
    }

    public static ByteBuffer getEBMLCodeAsBytes(DataSource source) {
        byte firstByte = source.readByte();
        int numBytes = EBMLReader.readEBMLCodeSize(firstByte);
        if (numBytes == 0) {
            LOG.error("Failed to read ebml code size from {}", (Object)firstByte);
            return null;
        }
        ByteBuffer buf = ByteBuffer.allocate(numBytes);
        buf.put((byte)(firstByte & 255 >>> numBytes));
        if (numBytes > 1) {
            source.read(buf);
        }
        buf.flip();
        return buf;
    }

    public static int readEBMLCodeSize(byte firstByte) {
        int numBytes = 0;
        long mask = 128L;
        for (int i = 0; i < 8; ++i) {
            if (((long)firstByte & mask) == mask) {
                numBytes = i + 1;
                i = 8;
            }
            mask >>>= 1;
        }
        return numBytes;
    }

    public static long readEBMLCode(DataSource source) {
        byte firstByte = source.readByte();
        int numBytes = EBMLReader.readEBMLCodeSize(firstByte);
        LOG.trace("Reading ebml code of {} bytes", (Object)numBytes);
        if (numBytes == 0) {
            return 0L;
        }
        ByteBuffer data = ByteBuffer.allocate(numBytes);
        data.put((byte)(firstByte & 255 >>> numBytes));
        if (numBytes > 1) {
            source.read(data);
        }
        data.flip();
        return EBMLReader.parseEBMLCode(data);
    }

    public static long parseEBMLCode(ByteBuffer data) {
        if (data == null) {
            return 0L;
        }
        data.mark();
        long size = 0L;
        for (int i = data.remaining() - 1; i >= 0; --i) {
            long n = data.get() & 0xFF;
            size |= n << 8 * i;
        }
        data.reset();
        LOG.trace("Parsed ebml code {} as {}", (Object)EBMLReader.bytesToHex(data.array()), (Object)size);
        return size;
    }

    public static long readEBMLCode(ByteBuffer source) {
        byte firstByte = source.get();
        int numBytes = EBMLReader.readEBMLCodeSize(firstByte);
        if (numBytes == 0) {
            return 0L;
        }
        ByteBuffer data = ByteBuffer.allocate(numBytes);
        data.put((byte)(firstByte & 255 >>> numBytes));
        while (data.hasRemaining()) {
            data.put(source.get());
        }
        data.flip();
        return EBMLReader.parseEBMLCode(data);
    }

    public static long readSignedEBMLCode(ByteBuffer source) {
        byte firstByte = source.get();
        int numBytes = EBMLReader.readEBMLCodeSize(firstByte);
        if (numBytes == 0) {
            return 0L;
        }
        ByteBuffer data = ByteBuffer.allocate(numBytes);
        data.put((byte)(firstByte & 255 >>> numBytes));
        while (data.hasRemaining()) {
            data.put(source.get());
        }
        data.flip();
        long size = EBMLReader.parseEBMLCode(data);
        if (numBytes == 1) {
            size -= 63L;
        } else if (numBytes == 2) {
            size -= 8191L;
        } else if (numBytes == 3) {
            size -= 1048575L;
        } else if (numBytes == 4) {
            size -= 0x7FFFFFFL;
        }
        return size;
    }

    public static long readSignedEBMLCode(DataSource source) {
        byte firstByte = source.readByte();
        int numBytes = EBMLReader.readEBMLCodeSize(firstByte);
        if (numBytes == 0) {
            return 0L;
        }
        ByteBuffer data = ByteBuffer.allocate(numBytes);
        data.put((byte)(firstByte & 255 >>> numBytes));
        if (numBytes > 1) {
            source.read(data);
        }
        data.flip();
        long size = EBMLReader.parseEBMLCode(data);
        if (numBytes == 1) {
            size -= 63L;
        } else if (numBytes == 2) {
            size -= 8191L;
        } else if (numBytes == 3) {
            size -= 1048575L;
        } else if (numBytes == 4) {
            size -= 0x7FFFFFFL;
        }
        return size;
    }

    public static ByteBuffer readEBMLCodeAsBytes(DataSource source) {
        byte firstByte = source.readByte();
        int numBytes = EBMLReader.readEBMLCodeSize(firstByte);
        if (numBytes == 0) {
            LOG.error("Failed to read ebml code size from {}", (Object)firstByte);
            return null;
        }
        ByteBuffer buf = ByteBuffer.allocate(numBytes);
        buf.put(firstByte);
        if (numBytes > 1) {
            source.read(buf);
        }
        buf.flip();
        return buf;
    }
}

