/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.requests;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.exceptions.ErrorResponseException;
import net.dv8tion.jda.core.exceptions.PermissionException;
import net.dv8tion.jda.core.exceptions.RateLimitedException;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.utils.SimpleLog;

public abstract class RestAction<T> {
    public static final SimpleLog LOG = SimpleLog.getLog("RestAction");
    public static final Consumer DEFAULT_SUCCESS = o -> {};
    public static final Consumer<Throwable> DEFAULT_FAILURE = t -> {
        if (LOG.getEffectiveLevel().getPriority() <= SimpleLog.Level.DEBUG.getPriority()) {
            LOG.log((Throwable)t);
        } else {
            LOG.fatal("RestAction queue returned failure: [" + t.getClass().getSimpleName() + "] " + t.getMessage());
        }
    };
    protected final JDAImpl api;
    protected final Route.CompiledRoute route;
    protected final Object data;

    public RestAction(JDA api, Route.CompiledRoute route, Object data) {
        this.api = (JDAImpl)api;
        this.route = route;
        this.data = data != null ? data : "";
    }

    public void queue() {
        this.queue(null, null);
    }

    public void queue(Consumer<T> success) {
        this.queue(success, null);
    }

    public void queue(Consumer<T> success, Consumer<Throwable> failure) {
        if (success == null) {
            success = DEFAULT_SUCCESS;
        }
        if (failure == null) {
            failure = DEFAULT_FAILURE;
        }
        this.api.getRequester().request(new Request(this, success, failure, true));
    }

    public T block() throws RateLimitedException {
        CompletableFuture future = new CompletableFuture();
        this.api.getRequester().request(new Request<Object>(this, successReturn -> future.complete(successReturn), failThrowable -> future.completeExceptionally((Throwable)failThrowable), false));
        try {
            return future.get();
        }
        catch (Exception e) {
            if (e instanceof ExecutionException) {
                Throwable t = e.getCause();
                if (t instanceof RateLimitedException) {
                    throw (RateLimitedException)t;
                }
                if (t instanceof PermissionException) {
                    throw (PermissionException)t;
                }
                if (t instanceof ErrorResponseException) {
                    throw (ErrorResponseException)t;
                }
            }
            throw new RuntimeException(e);
        }
    }

    public T block(long timeout, TimeUnit timeUnit) throws RateLimitedException, TimeoutException {
        CompletableFuture future = new CompletableFuture();
        this.api.getRequester().request(new Request<Object>(this, successReturn -> future.complete(successReturn), failThrowable -> future.completeExceptionally((Throwable)failThrowable), false));
        try {
            return future.get(timeout, timeUnit);
        }
        catch (Exception e) {
            if (e instanceof ExecutionException) {
                Throwable t = e.getCause();
                if (t instanceof RateLimitedException) {
                    throw (RateLimitedException)t;
                }
                if (t instanceof PermissionException) {
                    throw (PermissionException)t;
                }
                if (t instanceof ErrorResponseException) {
                    throw (ErrorResponseException)t;
                }
            } else if (e instanceof TimeoutException) {
                throw (TimeoutException)e;
            }
            throw new RuntimeException(e);
        }
    }

    protected abstract void handleResponse(Response var1, Request var2);

    public static class EmptyRestAction<T>
    extends RestAction<T> {
        private final T returnObj;

        public EmptyRestAction(T returnObj) {
            super(null, null, null);
            this.returnObj = returnObj;
        }

        @Override
        public void queue(Consumer<T> success, Consumer<Throwable> failure) {
            if (success != null) {
                success.accept(this.returnObj);
            }
        }

        @Override
        public T block() {
            return this.returnObj;
        }

        @Override
        public T block(long timeout, TimeUnit timeUnit) {
            return this.returnObj;
        }

        @Override
        protected void handleResponse(Response response, Request request) {
        }
    }
}

