/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.handle;

import java.util.LinkedList;
import net.dv8tion.jda.client.entities.Group;
import net.dv8tion.jda.client.events.message.group.GroupMessageEmbedEvent;
import net.dv8tion.jda.client.events.message.group.GroupMessageUpdateEvent;
import net.dv8tion.jda.core.AccountType;
import net.dv8tion.jda.core.entities.EntityBuilder;
import net.dv8tion.jda.core.entities.Message;
import net.dv8tion.jda.core.entities.MessageChannel;
import net.dv8tion.jda.core.entities.MessageEmbed;
import net.dv8tion.jda.core.entities.MessageType;
import net.dv8tion.jda.core.entities.PrivateChannel;
import net.dv8tion.jda.core.entities.TextChannel;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.events.message.MessageEmbedEvent;
import net.dv8tion.jda.core.events.message.MessageUpdateEvent;
import net.dv8tion.jda.core.events.message.guild.GuildMessageEmbedEvent;
import net.dv8tion.jda.core.events.message.guild.GuildMessageUpdateEvent;
import net.dv8tion.jda.core.events.message.priv.PrivateMessageEmbedEvent;
import net.dv8tion.jda.core.events.message.priv.PrivateMessageUpdateEvent;
import net.dv8tion.jda.core.handle.EventCache;
import net.dv8tion.jda.core.handle.SocketHandler;
import net.dv8tion.jda.core.requests.GuildLock;
import net.dv8tion.jda.core.requests.WebSocketClient;
import org.json.JSONArray;
import org.json.JSONObject;

public class MessageUpdateHandler
extends SocketHandler {
    public MessageUpdateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected String handleInternally(JSONObject content) {
        if (content.has("author")) {
            if (content.has("type")) {
                MessageType type = MessageType.fromId(content.getInt("type"));
                switch (type) {
                    case DEFAULT: {
                        return this.handleDefaultMessage(content);
                    }
                }
                WebSocketClient.LOG.debug("JDA received a message of unknown type. Type: " + (Object)((Object)type) + "  JSON: " + content);
                return null;
            }
            return null;
        }
        if (content.has("call")) {
            this.handleCallMessage(content);
            return null;
        }
        return this.handleMessageEmbed(content);
    }

    private String handleDefaultMessage(JSONObject content) {
        Message message;
        try {
            message = EntityBuilder.get(this.api).createMessage(content);
        }
        catch (IllegalArgumentException e) {
            switch (e.getMessage()) {
                case "MISSING_CHANNEL": {
                    EventCache.get(this.api).cache(EventCache.Type.CHANNEL, content.getString("channel_id"), () -> this.handle(this.responseNumber, this.allContent));
                    EventCache.LOG.debug("Received a message update for a channel that JDA does not currently have cached");
                    return null;
                }
                case "MISSING_USER": {
                    EventCache.get(this.api).cache(EventCache.Type.USER, content.getJSONObject("author").getString("id"), () -> this.handle(this.responseNumber, this.allContent));
                    EventCache.LOG.debug("Received a message update for a user that JDA does not currently have cached");
                    return null;
                }
            }
            throw e;
        }
        switch (message.getChannelType()) {
            case TEXT: {
                TextChannel channel = message.getTextChannel();
                if (GuildLock.get(this.api).isLocked(channel.getGuild().getId())) {
                    return channel.getGuild().getId();
                }
                this.api.getEventManager().handle(new GuildMessageUpdateEvent(this.api, this.responseNumber, message));
                break;
            }
            case PRIVATE: {
                this.api.getEventManager().handle(new PrivateMessageUpdateEvent(this.api, this.responseNumber, message));
            }
            case GROUP: {
                this.api.getEventManager().handle(new GroupMessageUpdateEvent(this.api, this.responseNumber, message));
                break;
            }
            default: {
                WebSocketClient.LOG.warn("Received a MESSAGE_UPDATE with a unknown MessageChannel ChannelType. JSON: " + content);
                return null;
            }
        }
        this.api.getEventManager().handle(new MessageUpdateEvent(this.api, this.responseNumber, message));
        return null;
    }

    private String handleMessageEmbed(JSONObject content) {
        EntityBuilder builder = EntityBuilder.get(this.api);
        String messageId = content.getString("id");
        String channelId = content.getString("channel_id");
        LinkedList<MessageEmbed> embeds = new LinkedList<MessageEmbed>();
        MessageChannel channel = this.api.getTextChannelMap().get(channelId);
        if (channel == null) {
            channel = this.api.getPrivateChannelMap().get(channelId);
        }
        if (channel == null) {
            channel = this.api.getFakePrivateChannelMap().get(channelId);
        }
        if (channel == null && this.api.getAccountType() == AccountType.CLIENT) {
            channel = this.api.asClient().getGroupById(channelId);
        }
        if (channel == null) {
            EventCache.get(this.api).cache(EventCache.Type.CHANNEL, channelId, () -> this.handle(this.responseNumber, this.allContent));
            EventCache.LOG.debug("Received message update for embeds for a channel/group that JDA does not have cached yet.");
            return null;
        }
        JSONArray embedsJson = content.getJSONArray("embeds");
        for (int i = 0; i < embedsJson.length(); ++i) {
            embeds.add(builder.createMessageEmbed(embedsJson.getJSONObject(i)));
        }
        if (channel instanceof TextChannel) {
            TextChannel tChannel = (TextChannel)channel;
            if (GuildLock.get(this.api).isLocked(tChannel.getGuild().getId())) {
                return tChannel.getGuild().getId();
            }
            this.api.getEventManager().handle(new GuildMessageEmbedEvent(this.api, this.responseNumber, messageId, tChannel, embeds));
        } else if (channel instanceof PrivateChannel) {
            this.api.getEventManager().handle(new PrivateMessageEmbedEvent(this.api, this.responseNumber, messageId, (PrivateChannel)channel, embeds));
        } else {
            this.api.getEventManager().handle(new GroupMessageEmbedEvent(this.api, this.responseNumber, messageId, (Group)channel, embeds));
        }
        this.api.getEventManager().handle(new MessageEmbedEvent(this.api, this.responseNumber, messageId, channel, embeds));
        return null;
    }

    public void handleCallMessage(JSONObject content) {
        WebSocketClient.LOG.debug("Received a MESSAGE_UPDATE of type CALL:  " + content.toString());
    }
}

