/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.handle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import net.dv8tion.jda.core.entities.Emote;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.entities.impl.EmoteImpl;
import net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.handle.EventCache;
import net.dv8tion.jda.core.handle.SocketHandler;
import net.dv8tion.jda.core.requests.GuildLock;
import org.json.JSONArray;
import org.json.JSONObject;

public class GuildEmojisUpdateHandler
extends SocketHandler {
    public GuildEmojisUpdateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected String handleInternally(JSONObject content) {
        String guild_id = content.getString("guild_id");
        if (GuildLock.get(this.api).isLocked(guild_id)) {
            return content.getString("guild_id");
        }
        GuildImpl guild = (GuildImpl)this.api.getGuildMap().get(guild_id);
        if (guild == null) {
            EventCache.get(this.api).cache(EventCache.Type.GUILD, guild_id, () -> this.handle(this.responseNumber, this.allContent));
            return null;
        }
        JSONArray array = content.getJSONArray("emojis");
        HashMap<String, Emote> emoteMap = guild.getEmoteMap();
        ArrayList oldEmotes = new ArrayList(emoteMap.values());
        for (int i = 0; i < array.length(); ++i) {
            JSONObject current = array.getJSONObject(i);
            String emoteId = current.getString("id");
            EmoteImpl emote = (EmoteImpl)emoteMap.get(emoteId);
            if (emote == null) {
                emote = new EmoteImpl(emoteId, guild);
            } else {
                oldEmotes.remove(emote);
            }
            emote.setName(current.getString("name")).setManaged(current.getBoolean("managed"));
            JSONArray roles = current.getJSONArray("roles");
            HashSet<Role> newRoles = emote.getRoleSet();
            HashSet<Role> oldRoles = new HashSet<Role>(newRoles);
            for (int j = 0; j < roles.length(); ++j) {
                Role role = guild.getRoleById(roles.getString(j));
                newRoles.add(role);
                oldRoles.remove(role);
            }
            for (Role r : oldRoles) {
                newRoles.remove(r);
            }
            emoteMap.put(emote.getId(), emote);
        }
        for (Emote e : oldEmotes) {
            emoteMap.remove(e.getId());
        }
        return null;
    }
}

