/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.handle;

import net.dv8tion.jda.core.entities.EntityBuilder;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.events.guild.GuildBanEvent;
import net.dv8tion.jda.core.events.guild.GuildUnbanEvent;
import net.dv8tion.jda.core.handle.EventCache;
import net.dv8tion.jda.core.handle.SocketHandler;
import net.dv8tion.jda.core.requests.GuildLock;
import org.json.JSONObject;

public class GuildBanHandler
extends SocketHandler {
    private final boolean banned;

    public GuildBanHandler(JDAImpl api, boolean banned) {
        super(api);
        this.banned = banned;
    }

    @Override
    protected String handleInternally(JSONObject content) {
        if (GuildLock.get(this.api).isLocked(content.getString("guild_id"))) {
            return content.getString("guild_id");
        }
        JSONObject userJson = content.getJSONObject("user");
        GuildImpl guild = (GuildImpl)this.api.getGuildMap().get(content.getString("guild_id"));
        if (guild == null) {
            EventCache.get(this.api).cache(EventCache.Type.GUILD, content.getString("guild_id"), () -> this.handle(this.responseNumber, this.allContent));
            EventCache.LOG.debug("Received Guild Member " + (this.banned ? "Ban" : "Unban") + " event for a Guild not yet cached.");
            return null;
        }
        User user = EntityBuilder.get(this.api).createFakeUser(userJson, false);
        if (this.banned) {
            this.api.getEventManager().handle(new GuildBanEvent(this.api, this.responseNumber, guild, user));
        } else {
            this.api.getEventManager().handle(new GuildUnbanEvent(this.api, this.responseNumber, guild, user));
        }
        return null;
    }
}

