/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.entities.impl;

import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.request.body.MultipartBody;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.dv8tion.jda.client.entities.Call;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.MessageBuilder;
import net.dv8tion.jda.core.MessageHistory;
import net.dv8tion.jda.core.entities.ChannelType;
import net.dv8tion.jda.core.entities.EntityBuilder;
import net.dv8tion.jda.core.entities.Message;
import net.dv8tion.jda.core.entities.MessageChannel;
import net.dv8tion.jda.core.entities.MessageEmbed;
import net.dv8tion.jda.core.entities.PrivateChannel;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.entities.impl.MessageImpl;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.utils.IOUtil;
import org.apache.http.util.Args;
import org.json.JSONArray;
import org.json.JSONObject;

public class PrivateChannelImpl
implements PrivateChannel {
    private final String id;
    private final User user;
    private Call currentCall = null;
    private boolean fake = false;

    public PrivateChannelImpl(String id, User user) {
        this.id = id;
        this.user = user;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public String getName() {
        return this.user.getName();
    }

    @Override
    public ChannelType getType() {
        return ChannelType.PRIVATE;
    }

    @Override
    public JDA getJDA() {
        return this.user.getJDA();
    }

    @Override
    public RestAction<Message> sendMessage(String text) {
        return this.sendMessage(new MessageBuilder().appendString(text).build());
    }

    @Override
    public RestAction<Message> sendMessage(MessageEmbed embed) {
        return this.sendMessage(new MessageBuilder().setEmbed(embed).build());
    }

    @Override
    public RestAction<Message> sendMessage(Message msg) {
        Args.notNull(msg, "Message");
        Route.CompiledRoute route = Route.Messages.SEND_MESSAGE.compile(this.getId());
        JSONObject json = ((MessageImpl)msg).toJSONObject();
        return new RestAction<Message>(this.getJDA(), route, (Object)json){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    Message m = EntityBuilder.get(PrivateChannelImpl.this.getJDA()).createMessage(response.getObject());
                    request.onSuccess(m);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public RestAction<Message> sendFile(File file, Message message) throws IOException {
        this.checkNull(file, "file");
        return this.sendFile(file, file.getName(), message);
    }

    @Override
    public RestAction<Message> sendFile(File file, String fileName, Message message) throws IOException {
        this.checkNull(file, "file");
        if (file == null || !file.exists() || !file.canRead()) {
            throw new IllegalArgumentException("Provided file is either null, doesn't exist or is not readable!");
        }
        if (file.length() > 0x800000L) {
            throw new IllegalArgumentException("File is to big! Max file-size is 8MB");
        }
        return this.sendFile(IOUtil.readFully(file), fileName, message);
    }

    @Override
    public RestAction<Message> sendFile(InputStream data, String fileName, Message message) {
        this.checkNull(data, "data InputStream");
        this.checkNull(fileName, "fileName");
        Route.CompiledRoute route = Route.Messages.SEND_MESSAGE.compile(this.id);
        MultipartBody body = Unirest.post("https://discordapp.com/api/" + route.getCompiledRoute()).fields(null);
        body.field("file", data, fileName);
        if (message != null) {
            body.field("content", message.getRawContent());
            body.field("tts", message.isTTS());
        }
        return new RestAction<Message>(this.getJDA(), route, (Object)body){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(EntityBuilder.get(this.api).createMessage(response.getObject()));
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public RestAction<Message> sendFile(byte[] data, String fileName, Message message) {
        this.checkNull(fileName, "fileName");
        if (data.length > 0x800000) {
            throw new IllegalArgumentException("Provided data is too large! Max file-size is 8MB");
        }
        Route.CompiledRoute route = Route.Messages.SEND_MESSAGE.compile(this.id);
        MultipartBody body = Unirest.post("https://discordapp.com/api/" + route.getCompiledRoute()).fields(null);
        body.field("file", data, fileName);
        if (message != null) {
            body.field("content", message.getRawContent());
            body.field("tts", message.isTTS());
        }
        return new RestAction<Message>(this.getJDA(), route, (Object)body){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(EntityBuilder.get(this.api).createMessage(response.getObject()));
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public RestAction<Message> getMessageById(String messageId) {
        this.checkNull(messageId, "messageId");
        Route.CompiledRoute route = Route.Messages.GET_MESSAGE.compile(this.getId(), messageId);
        return new RestAction<Message>(this.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    Message m = EntityBuilder.get(PrivateChannelImpl.this.getJDA()).createMessage(response.getObject());
                    request.onSuccess(m);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public RestAction<Void> deleteMessageById(String messageId) {
        this.checkNull(messageId, "messageId");
        Route.CompiledRoute route = Route.Messages.DELETE_MESSAGE.compile(this.getId(), messageId);
        return new RestAction<Void>(this.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public MessageHistory getHistory() {
        return new MessageHistory(this);
    }

    @Override
    public RestAction<MessageHistory> getHistoryAround(Message markerMessage, int limit) {
        return MessageHistory.getHistoryAround((MessageChannel)this, markerMessage, limit);
    }

    @Override
    public RestAction<MessageHistory> getHistoryAround(String markedMessageId, int limit) {
        return MessageHistory.getHistoryAround((MessageChannel)this, markedMessageId, limit);
    }

    public RestAction sendTyping() {
        Route.CompiledRoute route = Route.Channels.SEND_TYPING.compile(this.id);
        return new RestAction<Void>(this.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public RestAction<Void> pinMessageById(String messageId) {
        this.checkNull(messageId, "messageId");
        Route.CompiledRoute route = Route.Messages.ADD_PINNED_MESSAGE.compile(this.getId(), messageId);
        return new RestAction<Void>(this.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public RestAction<Void> unpinMessageById(String messageId) {
        this.checkNull(messageId, "messageId");
        Route.CompiledRoute route = Route.Messages.REMOVE_PINNED_MESSAGE.compile(this.getId(), messageId);
        return new RestAction<Void>(this.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public RestAction<List<Message>> getPinnedMessages() {
        Route.CompiledRoute route = Route.Messages.GET_PINNED_MESSAGES.compile(this.getId());
        return new RestAction<List<Message>>(this.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    LinkedList<Message> pinnedMessages = new LinkedList<Message>();
                    EntityBuilder builder = EntityBuilder.get(PrivateChannelImpl.this.getJDA());
                    JSONArray pins = response.getArray();
                    for (int i = 0; i < pins.length(); ++i) {
                        pinnedMessages.add(builder.createMessage(pins.getJSONObject(i)));
                    }
                    request.onSuccess(Collections.unmodifiableList(pinnedMessages));
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public RestAction<Void> close() {
        Route.CompiledRoute route = Route.Channels.DELETE_CHANNEL.compile(this.id);
        return new RestAction<Void>(this.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isFake() {
        return this.fake;
    }

    @Override
    public RestAction<Call> startCall() {
        return null;
    }

    @Override
    public Call getCurrentCall() {
        return this.currentCall;
    }

    public PrivateChannelImpl setFake(boolean fake) {
        this.fake = fake;
        return this;
    }

    public PrivateChannelImpl setCurrentCall(Call currentCall) {
        this.currentCall = currentCall;
        return this;
    }

    private void checkNull(Object obj, String name) {
        if (obj == null) {
            throw new NullPointerException("Provided " + name + " was null!");
        }
    }
}

