/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.entities.impl;

import com.mashape.unirest.http.Unirest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.security.auth.login.LoginException;
import net.dv8tion.jda.bot.JDABot;
import net.dv8tion.jda.bot.entities.impl.JDABotImpl;
import net.dv8tion.jda.client.JDAClient;
import net.dv8tion.jda.client.entities.impl.JDAClientImpl;
import net.dv8tion.jda.core.AccountType;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.audio.AudioWebSocket;
import net.dv8tion.jda.core.audio.factory.DefaultSendFactory;
import net.dv8tion.jda.core.audio.factory.IAudioSendFactory;
import net.dv8tion.jda.core.entities.Emote;
import net.dv8tion.jda.core.entities.EntityBuilder;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.PrivateChannel;
import net.dv8tion.jda.core.entities.SelfUser;
import net.dv8tion.jda.core.entities.TextChannel;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.entities.VoiceChannel;
import net.dv8tion.jda.core.exceptions.AccountTypeException;
import net.dv8tion.jda.core.exceptions.RateLimitedException;
import net.dv8tion.jda.core.hooks.IEventManager;
import net.dv8tion.jda.core.hooks.InterfacedEventManager;
import net.dv8tion.jda.core.managers.AudioManager;
import net.dv8tion.jda.core.managers.Presence;
import net.dv8tion.jda.core.managers.impl.PresenceImpl;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Requester;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.requests.WebSocketClient;
import net.dv8tion.jda.core.requests.ratelimit.IBucket;
import net.dv8tion.jda.core.utils.SimpleLog;
import org.apache.http.HttpHost;
import org.apache.http.util.Args;
import org.json.JSONObject;

public class JDAImpl
implements JDA {
    public static final SimpleLog LOG = SimpleLog.getLog("JDA");
    protected final HashMap<String, User> users = new HashMap(200);
    protected final HashMap<String, Guild> guilds = new HashMap(10);
    protected final HashMap<String, TextChannel> textChannels = new HashMap();
    protected final HashMap<String, VoiceChannel> voiceChannels = new HashMap();
    protected final HashMap<String, PrivateChannel> privateChannels = new HashMap();
    protected final HashMap<String, User> fakeUsers = new HashMap();
    protected final HashMap<String, PrivateChannel> fakePrivateChannels = new HashMap();
    protected final HashMap<String, AudioManager> audioManagers = new HashMap();
    protected final AccountType accountType;
    protected final PresenceImpl presence;
    protected final JDAClient jdaClient;
    protected final JDABot jdaBot;
    protected HttpHost proxy;
    protected WebSocketClient client;
    protected Requester requester;
    protected IEventManager eventManager = new InterfacedEventManager();
    protected IAudioSendFactory audioSendFactory = new DefaultSendFactory();
    protected JDA.Status status = JDA.Status.INITIALIZING;
    protected SelfUser selfUser;
    protected JDA.ShardInfo shardInfo;
    protected String token = null;
    protected boolean audioEnabled;
    protected boolean useShutdownHook;
    protected boolean bulkDeleteSplittingEnabled;
    protected boolean autoReconnect;
    protected long responseTotal;

    public JDAImpl(AccountType accountType, HttpHost proxy, boolean autoReconnect, boolean audioEnabled, boolean useShutdownHook, boolean bulkDeleteSplittingEnabled) {
        this.presence = new PresenceImpl(this);
        this.accountType = accountType;
        this.requester = new Requester(this);
        this.proxy = proxy;
        this.autoReconnect = autoReconnect;
        this.audioEnabled = audioEnabled;
        this.useShutdownHook = useShutdownHook;
        this.bulkDeleteSplittingEnabled = bulkDeleteSplittingEnabled;
        this.jdaClient = accountType == AccountType.CLIENT ? new JDAClientImpl(this) : null;
        JDABot jDABot = this.jdaBot = accountType == AccountType.BOT ? new JDABotImpl(this) : null;
        if (audioEnabled) {
            // empty if block
        }
    }

    public void login(String token, JDA.ShardInfo shardInfo) throws LoginException, RateLimitedException {
        this.setStatus(JDA.Status.LOGGING_IN);
        if (token == null || token.isEmpty()) {
            throw new LoginException("Provided token was null or empty!");
        }
        this.setToken(token);
        this.verifyToken();
        this.shardInfo = shardInfo;
        LOG.info("Login Successful!");
        this.client = new WebSocketClient(this);
        if (this.useShutdownHook) {
            Runtime.getRuntime().addShutdownHook(new Thread("JDA Shutdown Hook"){

                @Override
                public void run() {
                    JDAImpl.this.shutdownNow(true);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(JDA.Status status) {
        JDA.Status status2 = this.status;
        synchronized (status2) {
            JDA.Status oldStatus = this.status;
            this.status = status;
        }
    }

    public void setToken(String token) {
        this.token = this.getAccountType() == AccountType.BOT ? "Bot " + token : token;
    }

    public void verifyToken() throws LoginException, RateLimitedException {
        RestAction<JSONObject> login = new RestAction<JSONObject>((JDA)this, Route.Self.GET_SELF.compile(new String[0]), null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(response.getObject());
                } else if (response.isRateLimit()) {
                    request.onFailure(new RateLimitedException(request.getRoute(), response.retryAfter));
                } else if (response.code == 401) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(new LoginException("When verifying the authenticity of the provided token, Discord returned an unknown response:\n" + response.toString()));
                }
            }
        };
        JSONObject userResponse = null;
        try {
            userResponse = (JSONObject)login.block();
        }
        catch (RuntimeException e) {
            Throwable ex;
            Throwable throwable = ex = e.getCause() != null ? e.getCause().getCause() : null;
            if (ex instanceof LoginException) {
                throw (LoginException)ex;
            }
            throw e;
        }
        if (userResponse != null) {
            this.verifyToken(userResponse);
        } else {
            if (this.getAccountType() == AccountType.BOT) {
                this.token = this.token.replace("Bot ", "");
                this.requester = new Requester(this, AccountType.CLIENT);
            } else {
                this.token = "Bot " + this.token;
                this.requester = new Requester(this, AccountType.BOT);
            }
            try {
                userResponse = (JSONObject)login.block();
            }
            catch (RuntimeException e) {
                Throwable ex;
                Throwable throwable = ex = e.getCause() != null ? e.getCause().getCause() : null;
                if (ex instanceof LoginException) {
                    throw (LoginException)ex;
                }
                throw e;
            }
            if (userResponse != null) {
                this.verifyToken(userResponse);
            } else {
                throw new LoginException("The provided token is invalid!");
            }
        }
    }

    private void verifyToken(JSONObject userResponse) {
        if (this.getAccountType() == AccountType.BOT) {
            if (!userResponse.has("bot") || !userResponse.getBoolean("bot")) {
                throw new AccountTypeException(AccountType.BOT, "Attempted to login as a BOT with a CLIENT token!");
            }
        } else if (userResponse.has("bot") && userResponse.getBoolean("bot")) {
            throw new AccountTypeException(AccountType.CLIENT, "Attempted to login as a CLIENT with a BOT token!");
        }
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public HttpHost getGlobalProxy() {
        return this.proxy;
    }

    @Override
    public boolean isAudioEnabled() {
        return this.audioEnabled;
    }

    @Override
    public boolean isBulkDeleteSplittingEnabled() {
        return this.bulkDeleteSplittingEnabled;
    }

    @Override
    public void setAutoReconnect(boolean autoReconnect) {
        this.autoReconnect = autoReconnect;
        if (this.client != null) {
            this.client.setAutoReconnect(autoReconnect);
        }
    }

    @Override
    public boolean isAutoReconnect() {
        return this.autoReconnect;
    }

    @Override
    public JDA.Status getStatus() {
        return this.status;
    }

    @Override
    public List<User> getUsers() {
        return Collections.unmodifiableList(new ArrayList<User>(this.users.values()));
    }

    @Override
    public User getUserById(String id) {
        return this.users.get(id);
    }

    @Override
    public List<User> getUsersByName(String name, boolean ignoreCase) {
        return this.users.values().stream().filter(u -> ignoreCase ? name.equalsIgnoreCase(u.getName()) : name.equals(u.getName())).collect(Collectors.toList());
    }

    @Override
    public RestAction<User> retrieveUserById(String id) {
        if (this.accountType != AccountType.BOT) {
            throw new AccountTypeException(AccountType.BOT);
        }
        Args.notNull(id, "User id");
        User user = this.getUserById(id);
        if (user != null) {
            return new RestAction.EmptyRestAction<User>(user);
        }
        Route.CompiledRoute route = Route.Users.GET_USER.compile(id);
        return new RestAction<User>((JDA)this, route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (!response.isOk()) {
                    request.onFailure(response);
                    return;
                }
                JSONObject user = response.getObject();
                request.onSuccess(EntityBuilder.get(this.api).createFakeUser(user, false));
            }
        };
    }

    @Override
    public List<Guild> getGuilds() {
        return Collections.unmodifiableList(new ArrayList<Guild>(this.guilds.values()));
    }

    @Override
    public Guild getGuildById(String id) {
        return this.guilds.get(id);
    }

    @Override
    public List<Guild> getGuildsByName(String name, boolean ignoreCase) {
        return this.guilds.values().stream().filter(g -> ignoreCase ? name.equalsIgnoreCase(g.getName()) : name.equals(g.getName())).collect(Collectors.toList());
    }

    @Override
    public List<TextChannel> getTextChannels() {
        return Collections.unmodifiableList(new ArrayList<TextChannel>(this.textChannels.values()));
    }

    @Override
    public TextChannel getTextChannelById(String id) {
        return this.textChannels.get(id);
    }

    @Override
    public List<TextChannel> getTextChannelsByName(String name, boolean ignoreCase) {
        return this.textChannels.values().stream().filter(tc -> ignoreCase ? name.equalsIgnoreCase(tc.getName()) : name.equals(tc.getName())).collect(Collectors.toList());
    }

    @Override
    public List<VoiceChannel> getVoiceChannels() {
        return Collections.unmodifiableList(new ArrayList<VoiceChannel>(this.voiceChannels.values()));
    }

    @Override
    public VoiceChannel getVoiceChannelById(String id) {
        return this.voiceChannels.get(id);
    }

    @Override
    public List<VoiceChannel> getVoiceChannelByName(String name, boolean ignoreCase) {
        return this.voiceChannels.values().stream().filter(vc -> ignoreCase ? name.equalsIgnoreCase(vc.getName()) : name.equals(vc.getName())).collect(Collectors.toList());
    }

    @Override
    public List<PrivateChannel> getPrivateChannels() {
        return Collections.unmodifiableList(new ArrayList<PrivateChannel>(this.privateChannels.values()));
    }

    @Override
    public PrivateChannel getPrivateChannelById(String id) {
        return this.privateChannels.get(id);
    }

    @Override
    public List<Emote> getEmotes() {
        ArrayList emotes = new ArrayList();
        this.getGuilds().parallelStream().forEach(g -> emotes.addAll(g.getEmotes()));
        return Collections.unmodifiableList(emotes);
    }

    @Override
    public List<Emote> getEmotesByName(String name, boolean ignoreCase) {
        ArrayList emotes = new ArrayList();
        this.getGuilds().parallelStream().forEach(g -> emotes.addAll(g.getEmotesByName(name, ignoreCase)));
        return Collections.unmodifiableList(emotes);
    }

    @Override
    public Emote getEmoteById(String id) {
        for (Guild guild : this.getGuilds()) {
            Emote emote = guild.getEmoteById(id);
            if (emote == null) continue;
            return emote;
        }
        return null;
    }

    @Override
    public SelfUser getSelfUser() {
        return this.selfUser;
    }

    @Override
    public void shutdown() {
        this.shutdown(true);
    }

    @Override
    public void shutdown(boolean free) {
        this.setStatus(JDA.Status.SHUTTING_DOWN);
        this.getRequester().shutdown();
        this.audioManagers.forEach((guildId, mng) -> mng.closeAudioConnection());
        if (AudioWebSocket.KEEP_ALIVE_POOLS.containsKey(this)) {
            AudioWebSocket.KEEP_ALIVE_POOLS.get(this).shutdownNow();
        }
        this.getClient().setAutoReconnect(false);
        this.getClient().close();
        if (free) {
            try {
                Unirest.shutdown();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.setStatus(JDA.Status.SHUTDOWN);
    }

    @Override
    public List<IBucket> shutdownNow(boolean free) {
        this.setStatus(JDA.Status.SHUTTING_DOWN);
        List<IBucket> buckets = this.getRequester().shutdownNow();
        this.audioManagers.forEach((guildId, mng) -> mng.closeAudioConnection());
        if (AudioWebSocket.KEEP_ALIVE_POOLS.containsKey(this)) {
            AudioWebSocket.KEEP_ALIVE_POOLS.get(this).shutdownNow();
        }
        this.getClient().setAutoReconnect(false);
        this.getClient().close();
        if (free) {
            try {
                Unirest.shutdown();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.setStatus(JDA.Status.SHUTDOWN);
        return buckets;
    }

    @Override
    public JDAClient asClient() {
        if (this.getAccountType() != AccountType.CLIENT) {
            throw new AccountTypeException(AccountType.CLIENT);
        }
        return this.jdaClient;
    }

    @Override
    public JDABot asBot() {
        if (this.getAccountType() != AccountType.BOT) {
            throw new AccountTypeException(AccountType.BOT);
        }
        return this.jdaBot;
    }

    @Override
    public long getResponseTotal() {
        return this.responseTotal;
    }

    @Override
    public JDA.ShardInfo getShardInfo() {
        return this.shardInfo;
    }

    @Override
    public Presence getPresence() {
        return this.presence;
    }

    @Override
    public void installAuxiliaryCable(int port) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Nice try m8!");
    }

    @Override
    public AccountType getAccountType() {
        return this.accountType;
    }

    @Override
    public void setEventManager(IEventManager eventManager) {
        this.eventManager = eventManager;
    }

    @Override
    public void addEventListener(Object ... listeners) {
        for (Object listener : listeners) {
            this.eventManager.register(listener);
        }
    }

    @Override
    public void removeEventListener(Object ... listeners) {
        for (Object listener : listeners) {
            this.eventManager.unregister(listener);
        }
    }

    @Override
    public List<Object> getRegisteredListeners() {
        return Collections.unmodifiableList(this.eventManager.getRegisteredListeners());
    }

    public IAudioSendFactory getAudioSendFactory() {
        return this.audioSendFactory;
    }

    public void setAudioSendFactory(IAudioSendFactory factory) {
        Args.notNull(factory, "Provided IAudioSendFactory");
        this.audioSendFactory = factory;
    }

    public Requester getRequester() {
        return this.requester;
    }

    public IEventManager getEventManager() {
        return this.eventManager;
    }

    public WebSocketClient getClient() {
        return this.client;
    }

    public HashMap<String, User> getUserMap() {
        return this.users;
    }

    public HashMap<String, Guild> getGuildMap() {
        return this.guilds;
    }

    public HashMap<String, TextChannel> getTextChannelMap() {
        return this.textChannels;
    }

    public HashMap<String, VoiceChannel> getVoiceChannelMap() {
        return this.voiceChannels;
    }

    public HashMap<String, PrivateChannel> getPrivateChannelMap() {
        return this.privateChannels;
    }

    public HashMap<String, User> getFakeUserMap() {
        return this.fakeUsers;
    }

    public HashMap<String, PrivateChannel> getFakePrivateChannelMap() {
        return this.fakePrivateChannels;
    }

    public HashMap<String, AudioManager> getAudioManagerMap() {
        return this.audioManagers;
    }

    public void setSelfUser(SelfUser selfUser) {
        this.selfUser = selfUser;
    }

    public void setResponseTotal(int responseTotal) {
        this.responseTotal = responseTotal;
    }

    public String getIdentifierString() {
        if (this.shardInfo != null) {
            return "JDA " + this.shardInfo.getShardString();
        }
        return "JDA";
    }
}

