/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core;

import java.awt.Color;
import java.time.OffsetDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import net.dv8tion.jda.core.entities.MessageEmbed;
import net.dv8tion.jda.core.entities.impl.MessageEmbedImpl;

public class EmbedBuilder {
    public static final int TITLE_MAX_LENGTH = 256;
    public static final int VALUE_MAX_LENGTH = 1024;
    public static final int TEXT_MAX_LENGTH = 2048;
    public static final int URL_MAX_LENGTH = 2000;
    public static final String ZERO_WIDTH_SPACE = "\u200e";
    public static final Pattern URL_PATTERN = Pattern.compile("\\s*https?:\\/\\/.+\\..{2,}\\s*", 2);
    private String url;
    private String title;
    private String description;
    private OffsetDateTime timestamp;
    private Color color;
    private MessageEmbed.Thumbnail thumbnail;
    private MessageEmbed.Provider siteProvider;
    private MessageEmbed.AuthorInfo author;
    private MessageEmbed.VideoInfo videoInfo;
    private MessageEmbed.Footer footer;
    private MessageEmbed.ImageInfo image;
    private final List<MessageEmbed.Field> fields = new LinkedList<MessageEmbed.Field>();

    public EmbedBuilder() {
        this(null);
    }

    public EmbedBuilder(MessageEmbed embed) {
        if (embed != null) {
            this.url = embed.getUrl();
            this.title = embed.getTitle();
            this.description = embed.getDescription();
            this.timestamp = embed.getTimestamp();
            this.color = embed.getColor();
            this.thumbnail = embed.getThumbnail();
            this.siteProvider = embed.getSiteProvider();
            this.author = embed.getAuthor();
            this.videoInfo = embed.getVideoInfo();
            this.footer = embed.getFooter();
            this.image = embed.getImage();
            if (embed.getFields() != null) {
                this.fields.addAll(embed.getFields());
            }
        }
    }

    public MessageEmbed build() {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot build an empty embed!");
        }
        return new MessageEmbedImpl().setTitle(this.title).setUrl(this.url).setDescription(this.description).setTimestamp(this.timestamp).setColor(this.color).setThumbnail(this.thumbnail).setSiteProvider(this.siteProvider).setAuthor(this.author).setVideoInfo(this.videoInfo).setFooter(this.footer).setImage(this.image).setFields(this.fields);
    }

    public boolean isEmpty() {
        return this.title == null && this.url == null && this.description == null && this.timestamp == null && this.color == null && this.thumbnail == null && this.siteProvider == null && this.author == null && this.videoInfo == null && this.footer == null && this.image == null && this.fields.isEmpty();
    }

    public EmbedBuilder setUrl(String url) {
        this.urlCheck(url);
        this.url = url;
        return this;
    }

    public EmbedBuilder setTitle(String title) {
        if (title != null && title.length() > 256) {
            throw new IllegalArgumentException("Title cannot be longer than 256 characters.");
        }
        this.title = title;
        return this;
    }

    public EmbedBuilder setDescription(String description) {
        if (description != null && description.length() > 2048) {
            throw new IllegalArgumentException("Description cannot be longer than 2048 characters.");
        }
        this.description = description;
        return this;
    }

    public EmbedBuilder setTimestamp(TemporalAccessor temporal) {
        this.timestamp = temporal == null ? null : OffsetDateTime.from(temporal);
        return this;
    }

    public EmbedBuilder setColor(Color color) {
        this.color = color;
        return this;
    }

    public EmbedBuilder setThumbnail(String url) {
        if (url == null) {
            this.thumbnail = null;
        } else {
            this.urlCheck(url);
            this.thumbnail = new MessageEmbed.Thumbnail(url, null, 0, 0);
        }
        return this;
    }

    public EmbedBuilder setVideo(String url) {
        if (url == null) {
            this.videoInfo = null;
        } else {
            this.urlCheck(url);
            this.videoInfo = new MessageEmbed.VideoInfo(url, 0, 0);
        }
        return this;
    }

    public EmbedBuilder setImage(String url) {
        if (url == null) {
            this.image = null;
        } else {
            this.urlCheck(url);
            this.image = new MessageEmbed.ImageInfo(url, null, 0, 0);
        }
        return this;
    }

    public EmbedBuilder setProvider(String name, String url) {
        if (name == null && url == null) {
            this.siteProvider = null;
        } else {
            this.urlCheck(url);
            this.siteProvider = new MessageEmbed.Provider(name, url);
        }
        return this;
    }

    public EmbedBuilder setAuthor(String name, String url, String iconUrl) {
        if (name == null && url == null && iconUrl == null) {
            this.author = null;
        } else {
            this.urlCheck(url);
            this.author = new MessageEmbed.AuthorInfo(name, url, iconUrl, null);
        }
        return this;
    }

    public EmbedBuilder setFooter(String text, String iconUrl) {
        if (text == null && iconUrl == null) {
            this.footer = null;
        } else {
            if (text != null && text.length() > 2048) {
                throw new IllegalArgumentException("Text cannot be longer than 2048 characters.");
            }
            this.urlCheck(iconUrl);
            this.footer = new MessageEmbed.Footer(text, iconUrl, null);
        }
        return this;
    }

    public EmbedBuilder addField(MessageEmbed.Field field) {
        return this.addField(field.getName(), field.getValue(), field.isInline());
    }

    public EmbedBuilder addField(String name, String value, boolean inline) {
        if (name == null && value == null) {
            return this;
        }
        if (name == null || value == null) {
            throw new IllegalArgumentException("Both Name and Value must be set!");
        }
        if (name.length() > 256) {
            throw new IllegalArgumentException("Name cannot be longer than 256 characters.");
        }
        if (value.length() > 1024) {
            throw new IllegalArgumentException("Value cannot be longer than 1024 characters.");
        }
        if (name.isEmpty()) {
            name = ZERO_WIDTH_SPACE;
        }
        if (value.isEmpty()) {
            value = ZERO_WIDTH_SPACE;
        }
        this.fields.add(new MessageEmbed.Field(name, value, inline));
        return this;
    }

    public EmbedBuilder addBlankField(boolean inline) {
        this.fields.add(new MessageEmbed.Field(ZERO_WIDTH_SPACE, ZERO_WIDTH_SPACE, inline));
        return this;
    }

    private void urlCheck(String url) {
        if (url == null) {
            return;
        }
        if (url.length() > 2000) {
            throw new IllegalArgumentException("URL cannot be longer than 2000 characters.");
        }
        if (!URL_PATTERN.matcher(url).matches()) {
            throw new IllegalArgumentException("URL must be a valid http or https url.");
        }
    }
}

